/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.util.CollectionUtils;
import org.w3c.dom.Node;

public final class DomModelEvent
extends EventObject {
    public static final int NODES_ADDED_FLAG = 1;
    public static final int NODES_REMOVED_FLAG = 2;
    public static final int NODES_MOVED_FLAG = 4;
    public static final int ATTRIBUTES_CHANGED_FLAG = 8;
    public static final int CHARACTERS_CHANGED_FLAG = 16;
    public static final int PROPERTIES_CHANGED_FLAG = 32;
    public static final int DOM_STRUCTURE_FLAGS = 7;
    public static final int DOM_TREE_FLAGS = 31;
    private final DomModel _domModel;
    private final Node _changeRoot;
    private final int _changeFlags;
    private final Map _propertyChanges;
    private final List _domChanges;
    private final NodeChangeDetails _details;

    public DomModelEvent(DomModel domModel, Node changeRoot, int changeFlags, List domChanges, Map propertyChanges, NodeChangeDetails details) {
        super(domModel);
        if (domModel == null) {
            throw new IllegalArgumentException("DOM model required");
        }
        if (details == null) {
            details = NodeChangeDetails.NO_DETAILS_AVAILABLE;
        }
        this._domModel = domModel;
        this._changeRoot = changeRoot;
        this._details = details;
        changeFlags = changeRoot == null ? (changeFlags &= 0xFFFFFFFA) : (changeFlags &= 0x1F);
        if (propertyChanges != null && !propertyChanges.isEmpty()) {
            this._propertyChanges = CollectionUtils.createUnmodifiableMap(propertyChanges);
            changeFlags |= 0x20;
        } else {
            this._propertyChanges = Collections.EMPTY_MAP;
        }
        this._domChanges = domChanges == null ? Collections.EMPTY_LIST : CollectionUtils.createUnmodifiableList(domChanges);
        this._changeFlags = changeFlags;
    }

    public DomModel getDomModel() {
        return this._domModel;
    }

    public Node getChangeRoot() {
        return this._changeRoot;
    }

    public int getChangeFlags() {
        return this._changeFlags;
    }

    public final boolean isDomStructureChanged() {
        return (this.getChangeFlags() & 7) != 0;
    }

    public final boolean isDomTreeChanged() {
        return (this.getChangeFlags() & 0x1F) != 0;
    }

    public final boolean isPropertyChanged() {
        return (this.getChangeFlags() & 0x20) != 0;
    }

    public final PropertyChange getDocumentPropertyChange() {
        return this.getPropertyChange("documentChanged");
    }

    public final PropertyChange getReadOnlyPropertyChange() {
        return this.getPropertyChange("readOnly");
    }

    public final boolean isTextBufferModified() {
        PropertyChange change = this.getPropertyChange("textBufferModified");
        if (change != null) {
            return change.getNewBooleanValue();
        }
        return false;
    }

    public Map getPropertyChanges() {
        return this._propertyChanges;
    }

    public final PropertyChange getPropertyChange(String propertyName) {
        return (PropertyChange)this.getPropertyChanges().get(propertyName);
    }

    public final boolean containsPropertyChange(String propertyName) {
        return this.getPropertyChanges().containsKey(propertyName);
    }

    public List getDomChanges() {
        return this._domChanges;
    }

    public NodeChangeDetails getNodeChangeDetails() {
        return this._details;
    }

    public String toString() {
        int changeFlags;
        String outString = super.toString();
        if (this._changeRoot != null) {
            outString = outString + "root: " + this._changeRoot;
        }
        if ((changeFlags = this._changeFlags) != 0) {
            outString = outString + "Changes:[";
            if ((changeFlags & 1) != 0) {
                outString = outString + "Nodes+ ";
            }
            if ((changeFlags & 2) != 0) {
                outString = outString + "Nodes- ";
            }
            if ((changeFlags & 4) != 0) {
                outString = outString + "Nodes Moved ";
            }
            if ((changeFlags & 8) != 0) {
                outString = outString + "Attr+- ";
            }
            if ((changeFlags & 0x10) != 0) {
                outString = outString + "Chars+- ";
            }
            if ((changeFlags & 0x20) != 0) {
                outString = outString + "Prop changed";
            }
            outString = outString + "]";
        }
        if (!this._propertyChanges.isEmpty()) {
            outString = outString + "\nproperty changes: " + this._propertyChanges;
        }
        if (!this._domChanges.isEmpty()) {
            outString = outString + "\nDOM changes: " + this._domChanges;
        }
        if (this._details != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
            outString = outString + "\nDetails: " + this._details;
        }
        return outString;
    }
}

