/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.util.Map;
import oracle.bali.xml.dom.MapNamedNodeMap;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.util.DummyNode;
import oracle.bali.xml.dom.view.standalone.ProxyingAttr;
import oracle.bali.xml.grammar.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ProxyingMapNamedNodeMap
extends MapNamedNodeMap {
    private static final Node _REMOVED_NODE = DummyNode.INSTANCE;
    private int _removedCount;
    private int _overrideCount;
    private NamedNodeMap _proxiedMap;

    public ProxyingMapNamedNodeMap(Element owner, Map storage, NamedNodeMap proxiedMap) {
        super(owner, storage);
        this.$init$();
        if (proxiedMap == null) {
            throw new IllegalArgumentException("No map to proxy specified");
        }
        this._proxiedMap = proxiedMap;
    }

    public Node getNamedItem(String name) {
        Node namedItem = super.getNamedItem(name);
        if (namedItem != null) {
            if (namedItem == _REMOVED_NODE) {
                return null;
            }
            return namedItem;
        }
        Node attrNode = this._proxiedMap.getNamedItem(name);
        if (attrNode != null) {
            ++this._overrideCount;
            Attr proxyAttrNode = this._createAttrProxy((Attr)attrNode);
            super.setNamedItem(proxyAttrNode);
            return proxyAttrNode;
        }
        return null;
    }

    public Node removeNamedItem(String name) throws DOMException {
        return this._removeKeyedItem(this.getKey(name), this._proxiedMap.getNamedItem(name));
    }

    public Node setNamedItem(Node node) throws DOMException {
        Node newValue = super.setNamedItem(node);
        if (newValue == null && (newValue = this._proxiedMap.getNamedItem(node.getNodeName())) != null) {
            ++this._overrideCount;
        }
        return newValue;
    }

    public Node item(int index) {
        boolean hasRemovedNodes;
        if (index < 0) {
            return null;
        }
        NamedNodeMap proxiedMap = this._proxiedMap;
        int proxiedMapSize = proxiedMap.getLength();
        if (this._overrideCount + this._removedCount != proxiedMapSize) {
            int i = 0;
            while (i < proxiedMapSize) {
                Node currProxiedNode = proxiedMap.item(i);
                if (super.getNamedItemNS(currProxiedNode.getNamespaceURI(), DomUtils.getLocalName((Node)currProxiedNode)) == null) {
                    ++this._overrideCount;
                    super.setNamedItem(this._createAttrProxy((Attr)currProxiedNode));
                }
                ++i;
            }
        }
        boolean bl = hasRemovedNodes = this._removedCount != 0;
        if (!hasRemovedNodes) {
            return super.item(index);
        }
        Map storage = this.getStorage();
        if (!storage.isEmpty()) {
            for (Object currKey : storage.keySet()) {
                Object currValue = storage.get(currKey);
                if (currValue == _REMOVED_NODE) continue;
                if (index == 0) {
                    return (Node)currValue;
                }
                --index;
            }
        }
        return null;
    }

    public int getLength() {
        return super.getLength() + this._proxiedMap.getLength() - this._removedCount * 2 - this._overrideCount;
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        Node namedItem = super.getNamedItemNS(namespaceURI, localName);
        if (namedItem != null) {
            if (namedItem == _REMOVED_NODE) {
                return null;
            }
            return namedItem;
        }
        Node attrNode = this._proxiedMap.getNamedItemNS(namespaceURI, localName);
        if (attrNode != null) {
            ++this._overrideCount;
            return super.setNamedItem(this._createAttrProxy((Attr)attrNode));
        }
        return null;
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        QualifiedName qName = QualifiedName.getQualifiedName((String)namespaceURI, (String)localName);
        return this._removeKeyedItem(qName, this._proxiedMap.getNamedItemNS(namespaceURI, localName));
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        Node newValue = super.setNamedItemNS(node);
        if (newValue == null && (newValue = this._proxiedMap.getNamedItemNS(node.getNamespaceURI(), DomUtils.getLocalName((Node)node))) != null) {
            ++this._overrideCount;
        }
        return newValue;
    }

    private Node _removeKeyedItem(Object key, Node proxiedItem) {
        Node keyedItem = this.getKeyedItem(key);
        if (keyedItem == _REMOVED_NODE || keyedItem == null && proxiedItem == null) {
            throw new DOMException(8, "Not attribute named " + key + " found in " + this.getOwner());
        }
        if (keyedItem != null) {
            --this._overrideCount;
        }
        ++this._removedCount;
        return this.getStorage().put(key, _REMOVED_NODE);
    }

    private Attr _createAttrProxy(Attr proxiedAttr) {
        return new ProxyingAttr((Element)this.getOwner(), proxiedAttr);
    }

    private void $init$() {
        this._removedCount = 0;
        this._overrideCount = 0;
    }
}

