/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.DomMutationListener;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.impl.DomModelPlugin;
import oracle.bali.xml.dom.impl.DomModelPluginContext;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.MutationEvent;

public class SynchronizedDomModel
extends DomModelPlugin {
    private volatile boolean _needsInit;
    private final DomModel _peerDomModel;

    public SynchronizedDomModel(DomModelPluginContext context, DomModel peerDomModel) {
        super(context);
        this.$init$();
        this._peerDomModel = peerDomModel;
        peerDomModel.addDomMutationListener(new MutationListener(null));
    }

    public DOMImplementation getDOMImplementation() {
        return this._peerDomModel.getDOMImplementation();
    }

    protected void postReplaceDocument(Document newDocument) {
        if (newDocument == null) {
            this._needsInit = true;
        }
    }

    public boolean isReadOnly() {
        return this._peerDomModel.isReadOnly();
    }

    protected void acquireReadLockDirectly() {
        this._peerDomModel.acquireReadLock();
    }

    protected void releaseReadLockDirectly() {
        this._peerDomModel.releaseReadLock();
    }

    protected void acquireWriteLockDirectly() {
        this._peerDomModel.acquireWriteLock();
    }

    protected void releaseWriteLockDirectly() {
        this._peerDomModel.releaseWriteLock();
    }

    public int getLockStatus() {
        return this._peerDomModel.getLockStatus();
    }

    public List getCurrentDomParseProblems() {
        return this._peerDomModel.getCurrentDomParseProblems();
    }

    public DomModel.FragmentParseResult parseFragment(Document document, Node contextNode, Map predefinedPrefixes, String text) {
        Node peerContextNode = this._getPeerNode(contextNode);
        DomModel.FragmentParseResult peerResult = this._peerDomModel.parseFragment(peerContextNode, predefinedPrefixes, text);
        if (peerResult == null) {
            return null;
        }
        DocumentFragment peerFragment = peerResult.getDocumentFragment();
        if (peerFragment == null) {
            return peerResult;
        }
        DocumentFragment ourFragment = (DocumentFragment)document.importNode(peerFragment, true);
        return new DomModel.FragmentParseResult(ourFragment);
    }

    protected UndoableEdit setDocType(String qualifiedName, String publicId, String systemId) {
        this._peerDomModel.setDocType(qualifiedName, publicId, systemId);
        return null;
    }

    protected UndoableEdit removeDocType() {
        this._peerDomModel.removeDocType();
        return null;
    }

    protected void refreshModel(boolean force) {
        this._peerDomModel.refreshModel(force);
    }

    public boolean needsReparse() {
        return false;
    }

    protected void getTextOffsets(Node node, int[] results) {
        Node peerNode = this._getPeerNode(node);
        if (peerNode != null) {
            this._peerDomModel.getTextOffsets(node, results);
        } else {
            super.getTextOffsets(node, results);
        }
    }

    protected int getTextOffset(DomPosition position) {
        Node flattenedNode = position.getTargetNode();
        Node peerNode = this._getPeerNode(flattenedNode);
        if (peerNode != null) {
            return this._peerDomModel.getTextOffset(position.getRetargetedPosition(peerNode, false));
        }
        return -1;
    }

    protected synchronized void ensureDocumentAvailable() {
        if (this._needsInit) {
            this._needsInit = false;
            Document peerDocument = this._peerDomModel.getDocument();
            if (peerDocument != null) {
                this._peerDomModel.acquireReadLock();
                Document clone = null;
                try {
                    clone = this._clonePeerDocument(peerDocument);
                }
                finally {
                    this._peerDomModel.releaseReadLock();
                }
                this.getContext().replaceDocument(clone);
            }
        }
    }

    protected void handleCommittedDomChanges(DomChangesUndoableEdit domChanges) {
    }

    protected void handlePeerMutation(DomChange change, MutationEvent mEvent) {
        System.out.println("Peer Mutation:" + mEvent);
    }

    private Node _getPeerNode(Node node) {
        if (node == null) {
            return null;
        }
        return this.getContext().getDomModelContext().remapNode(this._peerDomModel.getDocument(), node);
    }

    private Document _clonePeerDocument(Document peerDocument) {
        String peerLocalName;
        DOMImplementation implementation = this.getDOMImplementation();
        DocumentType peerDocumentType = peerDocument.getDoctype();
        DocumentType clonedDocumentType = null;
        if (peerDocumentType != null) {
            clonedDocumentType = implementation.createDocumentType(peerDocumentType.getNamespaceURI(), peerDocumentType.getPublicId(), peerDocumentType.getSystemId());
        }
        String peerPrefix = peerDocument.getPrefix();
        String peerQName = peerLocalName = peerDocument.getLocalName();
        if (peerPrefix != null) {
            peerQName = peerPrefix + ":" + peerLocalName;
        }
        Document clonedDocument = implementation.createDocument(peerDocument.getNamespaceURI(), peerQName, clonedDocumentType);
        NodeList peerChildren = peerDocument.getChildNodes();
        int childCount = peerChildren.getLength();
        int i = 0;
        while (i < childCount) {
            Node currPeerChild = peerChildren.item(i);
            if (currPeerChild.getNodeType() != 10) {
                Node clonedChild = clonedDocument.importNode(currPeerChild, true);
                clonedDocument.appendChild(clonedChild);
            }
            ++i;
        }
        return clonedDocument;
    }

    private void $init$() {
        this._needsInit = true;
    }

    static DomModel ra$_peerDomModel(SynchronizedDomModel synchronizedDomModel) {
        return synchronizedDomModel._peerDomModel;
    }

    private class MutationListener
    implements DomMutationListener,
    DomChangeHandler {
        public void domMutated(DomModel domModel, DomChange change, MutationEvent mEvent) {
            if (change != null) {
                try {
                    change.process(this);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    LogRecord record = new LogRecord(Level.SEVERE, "Unexpected Exception Synchronizing");
                    record.setThrown(e);
                    SynchronizedDomModel.this.getContext().getLogger().log(record);
                }
            } else if (mEvent == null) {
                SynchronizedDomModel.this.getContext().replaceDocument(null);
            } else {
                SynchronizedDomModel.this.handlePeerMutation(change, mEvent);
            }
        }

        public void handleAttrAddedChange(AttrAddedChange change) {
            Element peerOwner = change.getOwnerElement(SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument());
            Element ourOwner = (Element)SynchronizedDomModel.this.getContext().getDomModelContext().remapNode(SynchronizedDomModel.this.getContext().getDocument(), peerOwner);
            if (ourOwner != null) {
                DomUtils.addAttr((Element)ourOwner, (Attr)change.getAddedAttributeClone());
            }
        }

        public void handleAttrRemovedChange(AttrRemovedChange change) {
            Element peerOwner = change.getOwnerElement(SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument());
            Element ourOwner = (Element)SynchronizedDomModel.this.getContext().getDomModelContext().remapNode(SynchronizedDomModel.this.getContext().getDocument(), peerOwner);
            if (ourOwner != null) {
                DomUtils.removeAttr((Element)ourOwner, (Attr)change.getRemovedAttributeClone());
            }
        }

        public void handleAttrValueChange(AttrValueChange change) {
            Document peerDocument = SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument();
            Element peerOwner = change.getOwnerElement(peerDocument);
            Element ourOwner = (Element)SynchronizedDomModel.this.getContext().getDomModelContext().remapNode(SynchronizedDomModel.this.getContext().getDocument(), peerOwner);
            if (ourOwner != null) {
                Attr changedAttr = change.getChangedAttr(peerDocument);
                ourOwner.setAttributeNS(changedAttr.getNamespaceURI(), DomUtils.getLocalName((Node)changedAttr), change.getNewValue());
            }
        }

        public void handleNodeInsertedChange(NodeInsertedChange change) {
            Node ourInsertedParent;
            Node ourInsertedBefore;
            Document peerDocument = SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument();
            Document ourDocument = SynchronizedDomModel.this.getContext().getDocument();
            Node peerInsertedNode = change.getNodeRef().getCorrespondingNode(peerDocument);
            Node peerInsertedBefore = peerInsertedNode.getNextSibling();
            DomModelContext context = SynchronizedDomModel.this.getContext().getDomModelContext();
            if (peerInsertedBefore != null) {
                ourInsertedBefore = context.remapNode(ourDocument, peerInsertedBefore);
                if (ourInsertedBefore == null) {
                    return;
                }
                ourInsertedParent = ourInsertedBefore.getParentNode();
            } else {
                ourInsertedBefore = null;
                ourInsertedParent = context.remapNode(ourDocument, peerInsertedNode.getParentNode());
                if (ourInsertedParent == null) {
                    return;
                }
            }
            Node ourInsertedNode = ourDocument.importNode(peerInsertedNode, true);
            ourInsertedParent.insertBefore(ourInsertedNode, ourInsertedBefore);
        }

        public void handleNodeRemovedChange(NodeRemovedChange change) {
            Node peerRemovedNode = change.getNodeRef().getCorrespondingNode(SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument());
            Node ourRemovedNode = SynchronizedDomModel.this.getContext().getDomModelContext().remapNode(SynchronizedDomModel.this.getContext().getDocument(), peerRemovedNode);
            if (ourRemovedNode != null) {
                ourRemovedNode.getParentNode().removeChild(ourRemovedNode);
            }
        }

        public void handleNodeValueChange(NodeValueChange change) {
            Node peerChangedNode = change.getNodeRef().getCorrespondingNode(SynchronizedDomModel.ra$_peerDomModel(SynchronizedDomModel.this).getDocument());
            Node ourChangedNode = SynchronizedDomModel.this.getContext().getDomModelContext().remapNode(SynchronizedDomModel.this.getContext().getDocument(), peerChangedNode);
            if (ourChangedNode != null) {
                ourChangedNode.setNodeValue(change.getNewValue());
            }
        }

        private MutationListener() {
        }

        MutationListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

