/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.BufferDomDocumentParser;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.DocumentHandler;
import oracle.bali.xml.dom.buffer.parser.DocumentScanner;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceResult;
import oracle.javatools.buffer.ReadTextBuffer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

abstract class AbstractBufferDomParser
implements DocumentHandler {
    static final /* synthetic */ boolean $assertionsDisabled;
    private LocatorManager _manager;
    private Map _locatorMap;
    private Node _currentParent;
    private DocumentScanner _currentDocumentScanner;
    private final DOMImplementation _domImpl;
    private final WhitespaceHandler _whitespaceHandler;
    private final ParserConfiguration _parserConfiguration;
    private final DocumentScannerFactory _docScannerFactory;
    private final List _textNodesWithModeTrim;
    private static final Logger _LOGGER;

    protected AbstractBufferDomParser(DOMImplementation domImpl, ParserConfiguration parserConfiguration, DocumentScannerFactory docScannerFactory, WhitespaceHandler whitespaceHandler) {
        this.$init$();
        if (domImpl == null) {
            throw new IllegalArgumentException("null DOMImplementation");
        }
        if (whitespaceHandler == null) {
            throw new IllegalArgumentException("null WhitespaceHandler");
        }
        this._domImpl = domImpl;
        this._parserConfiguration = parserConfiguration;
        this._docScannerFactory = docScannerFactory;
        this._whitespaceHandler = whitespaceHandler;
    }

    public void handleStartElement(ResolvedName name, AttributeDeclarations attributes, ElementLocator locator) {
        this._handleElement(name, attributes, locator, false);
    }

    public void handleEmptyElement(ResolvedName name, AttributeDeclarations attributes, ElementLocator locator) {
        this._handleElement(name, attributes, locator, true);
    }

    public void handleEndElement(ResolvedName name, SimpleLocator locator, boolean complete) {
        if (this._currentParent != null && this._currentParent.getNodeType() == 1) {
            ElementLocator elementLocator;
            if (this._locatorMap != null && (elementLocator = (ElementLocator)this._locatorMap.get(this._currentParent)) != null) {
                elementLocator.setEndTagLocator(locator);
                elementLocator.setEndTagComplete(complete);
            }
            this._currentParent = this._currentParent.getParentNode();
        }
    }

    public void handleCDATASection(String characters, SimpleLocator locator) {
        CDATASection cData = null;
        try {
            if (this._parentAllowsCharacterContent()) {
                cData = this.getOwnerDocument().createCDATASection(characters);
            }
        }
        catch (Exception e) {
            cData = null;
            this.getLogger().log(Level.WARNING, "Exception creating CDATA", e);
        }
        if (cData != null) {
            this._currentParent.appendChild(cData);
            this.mapToLocator(cData, locator);
        } else {
            this._manager.detach(locator);
        }
    }

    static {
        $assertionsDisabled = AbstractBufferDomParser.class.desiredAssertionStatus() ^ true;
        _LOGGER = Logger.getLogger(AbstractBufferDomParser.class.getName());
    }

    public void handleText(String origCharacters, TextLocator origLocator) {
        WhitespaceResult result;
        Element parentForWs;
        if (!$assertionsDisabled && origCharacters.length() <= 0) {
            throw new AssertionError((Object)"must have some characters");
        }
        if (!$assertionsDisabled && origLocator.getLength() <= 0) {
            throw new AssertionError((Object)"must have some location");
        }
        String characters = origCharacters;
        Text text = null;
        TextLocator textLocator = null;
        origLocator.attach(this._manager, false);
        if (!this._parentAllowsCharacterContent()) {
            return;
        }
        WhitespaceMode mode = WhitespaceMode.MODE_PRESERVE;
        if (this._currentParent != null && (parentForWs = this.getPotentialParentElement(this._currentParent)) != null) {
            mode = this.getWhitespaceHandler().getElementContentWhitespaceMode(this.getTraversalForWhitespaceHandler(), parentForWs);
        }
        if ((result = mode.apply(characters)) == null) {
            origLocator.attach(this._manager, true);
            textLocator = origLocator;
        } else {
            if (characters.length() != result.getTotalLength()) {
                throw new IllegalStateException("Result has wrong length. Chars=||" + characters + "|| " + "charsLen=" + characters.length() + " resultLen=" + result.getTotalLength());
            }
            if (result.isEmpty()) {
                characters = null;
            } else {
                characters = result.getValue();
                if (result.hasNoWhitespace()) {
                    origLocator.attach(this._manager, true);
                    textLocator = origLocator;
                } else {
                    textLocator = this._makeTextLocator(origCharacters, origLocator, result);
                }
            }
        }
        if (characters != null) {
            try {
                text = this.getOwnerDocument().createTextNode(characters);
            }
            catch (Exception e) {
                text = null;
                this.getLogger().log(Level.WARNING, "Exception creating Text", e);
            }
        }
        if (text != null) {
            if (textLocator == null) {
                throw new IllegalStateException("no locator! text=" + text);
            }
            this._currentParent.appendChild(text);
            this.mapToLocator(text, textLocator);
            if (mode == WhitespaceMode.MODE_TRIM) {
                this._textNodesWithModeTrim.add(text);
            }
        }
    }

    public void handleProcessingInstruction(String target, String data, SimpleLocator locator) {
        ProcessingInstruction pi = null;
        if (target != null) {
            try {
                if (this.getOwnerDocument() != null) {
                    pi = this.getOwnerDocument().createProcessingInstruction(target, data);
                } else {
                    Document scratchDocument = DomUtils.getScratchDocument();
                    pi = scratchDocument.createProcessingInstruction(target, data);
                }
            }
            catch (Exception e) {
                pi = null;
                this.getLogger().log(Level.WARNING, "Exception creating PI", e);
            }
        }
        if (pi != null) {
            if (this.getOwnerDocument() != null) {
                this._currentParent.appendChild(pi);
                this.mapToLocator(pi, locator);
            } else {
                this.handleCommentOrPIBeforeDocumentCreated(pi, locator);
            }
        } else {
            this._manager.detach(locator);
        }
    }

    public void handleComment(String text, SimpleLocator locator) {
        Comment comment = null;
        try {
            if (this.getOwnerDocument() != null) {
                comment = this.getOwnerDocument().createComment(text);
            } else {
                Document scratchDocument = DomUtils.getScratchDocument();
                comment = scratchDocument.createComment(text);
            }
        }
        catch (Exception e) {
            comment = null;
            this.getLogger().log(Level.WARNING, "Exception creating Comment", e);
        }
        if (comment != null) {
            if (this.getOwnerDocument() != null) {
                this._currentParent.appendChild(comment);
                this.mapToLocator(comment, locator);
            } else {
                this.handleCommentOrPIBeforeDocumentCreated(comment, locator);
            }
        } else {
            this._manager.detach(locator);
        }
    }

    public final DOMImplementation getDOMImplementation() {
        return this._domImpl;
    }

    public final WhitespaceHandler getWhitespaceHandler() {
        return this._whitespaceHandler;
    }

    public final ParserConfiguration getParserConfiguration() {
        return this._parserConfiguration;
    }

    public final DocumentScannerFactory getDocumentScannerFactory() {
        return this._docScannerFactory;
    }

    protected Logger getLogger() {
        return _LOGGER;
    }

    protected final void doParse(ReadTextBuffer buffer, LocatorManager manager, Map locatorMap, Node initialParent, NamespaceDeclarations initialNamespaceDecls) {
        this._locatorMap = locatorMap;
        this._manager = manager;
        this._currentParent = initialParent;
        this._textNodesWithModeTrim.clear();
        this.getWhitespaceHandler().beginCacheablePeriod();
        try {
            this._currentDocumentScanner = this.getDocumentScannerFactory().createDocumentScanner();
            this._currentDocumentScanner.scanDocument(buffer, this, manager, initialNamespaceDecls);
            this._currentDocumentScanner = null;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Unexpected error in document scanner", t);
            this._locatorMap.clear();
            this.handleDocumentScannerException();
        }
        if (!this._textNodesWithModeTrim.isEmpty()) {
            for (Text text : this._textNodesWithModeTrim) {
                this._postProcessTrimTextNode(text);
            }
        }
    }

    protected final void doCleanup() {
        this._locatorMap = null;
        this._manager = null;
        this._currentParent = null;
        this._textNodesWithModeTrim.clear();
        this.getWhitespaceHandler().endCacheablePeriod();
    }

    protected final void clearRegularLocators() {
        Locator xmlDeclLocator = (Locator)this._locatorMap.get(BufferDomDocumentParser.DECLARATION_LOCATOR_KEY);
        Locator docTypeLocator = (Locator)this._locatorMap.get(BufferDomDocumentParser.DOCUMENT_TYPE_LOCATOR_KEY);
        this._manager.clear();
        this._locatorMap.clear();
        this._restore(BufferDomDocumentParser.DECLARATION_LOCATOR_KEY, xmlDeclLocator);
        this._restore(BufferDomDocumentParser.DOCUMENT_TYPE_LOCATOR_KEY, docTypeLocator);
    }

    protected final void mapToLocator(Object key, Locator locator) {
        if (key != null) {
            this._locatorMap.put(key, locator);
        }
    }

    protected final LocatorManager getLocatorManager() {
        return this._manager;
    }

    protected final void setCurrentParent(Node node) {
        this._currentParent = node;
    }

    protected final DocumentScanner getCurrentDocumentScanner() {
        return this._currentDocumentScanner;
    }

    protected TreeTraversal getTraversalForWhitespaceHandler() {
        return DocumentTreeTraversal.INSTANCE;
    }

    protected Element getPotentialParentElement(Node trueCurrentParent) {
        return DomUtils.asElement((Node)trueCurrentParent);
    }

    protected abstract Document getOwnerDocument();

    protected abstract void handleDocumentScannerException();

    protected abstract void handleCommentOrPIBeforeDocumentCreated(Node var1, Locator var2);

    protected abstract Element handleElementBeforeDocumentCreated(ResolvedName var1, ElementLocator var2);

    private void _handleElement(ResolvedName name, AttributeDeclarations attributes, ElementLocator locator, boolean empty) {
        Element newElement = null;
        if (name.getLocalName() != null) {
            if (this.getOwnerDocument() == null) {
                newElement = this.handleElementBeforeDocumentCreated(name, locator);
            } else if (this._currentParent != this.getOwnerDocument()) {
                try {
                    newElement = this.getOwnerDocument().createElementNS(name.getNamespace(), name.getRawName());
                }
                catch (Exception e) {
                    newElement = null;
                    this.getLogger().log(Level.WARNING, "Exception creating Element", e);
                }
                if (newElement != null) {
                    this._currentParent.appendChild(newElement);
                }
            }
        }
        if (newElement != null) {
            this.mapToLocator(newElement, locator);
            this._handleAttributes(newElement, attributes);
            if (!empty) {
                this._currentParent = newElement;
            } else if (this._currentParent == null) {
                this._currentParent = newElement.getParentNode();
            }
        }
    }

    private void _handleAttributes(Element element, AttributeDeclarations attributes) {
        ResolvedName name = null;
        String value = null;
        AttributeLocator locator = null;
        int i = 0;
        while (i < attributes.getLength()) {
            Attr anAttribute = null;
            name = attributes.getResolvedName(i);
            value = attributes.getValue(i);
            locator = attributes.getLocator(i);
            if (name.getLocalName() != null) {
                try {
                    anAttribute = this.getOwnerDocument().createAttributeNS(name.getNamespace(), name.getRawName());
                }
                catch (Exception e) {
                    anAttribute = null;
                    this.getLogger().log(Level.WARNING, "Exception creating Attr", e);
                }
                if (anAttribute != null) {
                    WhitespaceMode mode;
                    WhitespaceResult result;
                    element.setAttributeNodeNS(anAttribute);
                    if (value != null && (result = (mode = this.getWhitespaceHandler().getAttributeContentWhitespaceMode(this.getTraversalForWhitespaceHandler(), element, name.getNamespace(), name.getLocalName())).apply(value)) != null) {
                        value = result.getValue();
                    }
                    if (value != null) {
                        anAttribute.setValue(value);
                    }
                    this.mapToLocator(anAttribute, locator);
                }
            }
            ++i;
        }
    }

    private TextLocator _makeTextLocator(String origCharacters, TextLocator origLocator, WhitespaceResult result) {
        ArrayList<EntityRefLocator> whitespaceLocators = new ArrayList<EntityRefLocator>(0);
        ArrayList<SimpleLocator> contentLocators = new ArrayList<SimpleLocator>(0);
        int startingOffset = origLocator.getStartOffset();
        BitSet whitespaceIndices = result.getWhitespaceBitSet();
        Iterator origContentItor = origLocator.getContentLocators().iterator();
        int precedingCharsToSkip = startingOffset;
        while (origContentItor.hasNext()) {
            SimpleLocator curOrigLocator = (SimpleLocator)origContentItor.next();
            if (curOrigLocator.getLength() == 0) {
                if (!this.getLogger().isLoggable(Level.WARNING)) continue;
                this.getLogger().log(Level.WARNING, "zero-length locator {0} found inside {1} for text ||{2}||", new Object[]{curOrigLocator, origLocator, origCharacters});
                continue;
            }
            boolean reuseOrigLocator = false;
            if (curOrigLocator instanceof EntityRefLocator) {
                EntityRefLocator erl = (EntityRefLocator)curOrigLocator;
                int replacementLength = erl.getReplacementText().length();
                boolean foundNonWs = false;
                int adjustedCurStart = erl.getStartOffset() - precedingCharsToSkip;
                int i = 0;
                while (i < replacementLength) {
                    if (!whitespaceIndices.get(adjustedCurStart + i)) {
                        foundNonWs = true;
                        break;
                    }
                    ++i;
                }
                int deltaSize = erl.getLength() - replacementLength;
                precedingCharsToSkip += deltaSize;
                if (foundNonWs) {
                    reuseOrigLocator = true;
                } else if (!contentLocators.isEmpty()) {
                    erl.attach(this._manager, true);
                    whitespaceLocators.add(erl);
                }
            } else {
                int adjustedCurStart = curOrigLocator.getStartOffset() - precedingCharsToSkip;
                int adjustedCurEnd = curOrigLocator.getEndOffset() - precedingCharsToSkip;
                int firstWsIndex = whitespaceIndices.nextSetBit(adjustedCurStart);
                if (firstWsIndex >= adjustedCurEnd) {
                    reuseOrigLocator = true;
                } else {
                    this._processEachCharForWhitespace(whitespaceLocators, contentLocators, whitespaceIndices, precedingCharsToSkip, adjustedCurStart, adjustedCurEnd);
                }
            }
            if (!reuseOrigLocator) continue;
            this._manager.attach(curOrigLocator);
            contentLocators.add(curOrigLocator);
        }
        int wsCount = whitespaceLocators.size();
        if (wsCount > 0) {
            int totalEnd = origLocator.getEndOffset();
            ListIterator wsItor = whitespaceLocators.listIterator(wsCount);
            while (wsItor.hasPrevious()) {
                Locator loc = (Locator)wsItor.previous();
                if (loc.getEndOffset() != totalEnd) break;
                loc.attach(this._manager, false);
                wsItor.remove();
                totalEnd = loc.getStartOffset();
            }
        }
        return this._manager.createTextLocator(contentLocators, whitespaceLocators);
    }

    private void _processEachCharForWhitespace(List whitespaceLocators, List contentLocators, BitSet whitespaceIndices, int precedingCharsToSkip, int adjustedCurStart, int adjustedCurEnd) {
        int runStart = -1;
        boolean runIsWs = false;
        int i = adjustedCurStart;
        while (i < adjustedCurEnd) {
            boolean iIsWs = whitespaceIndices.get(i);
            if (runStart == -1) {
                runIsWs = iIsWs;
                runStart = i;
            } else if (iIsWs != runIsWs) {
                this._flushRun(whitespaceLocators, contentLocators, precedingCharsToSkip, runStart, i, runIsWs);
                runIsWs = iIsWs;
                runStart = i;
            }
            ++i;
        }
        if (runStart != -1) {
            this._flushRun(whitespaceLocators, contentLocators, precedingCharsToSkip, runStart, adjustedCurEnd, runIsWs);
        }
    }

    private void _flushRun(List whitespaceLocators, List contentLocators, int precedingCharsToSkip, int runStart, int runEnd, boolean runIsWs) {
        SimpleLocator nextLoc = this._manager.createSimpleLocator(precedingCharsToSkip + runStart, precedingCharsToSkip + runEnd);
        if (runIsWs) {
            if (!contentLocators.isEmpty()) {
                whitespaceLocators.add(nextLoc);
            }
        } else {
            contentLocators.add(nextLoc);
        }
    }

    private void _postProcessTrimTextNode(Text text) {
        boolean isLast;
        Node parent = text.getParentNode();
        boolean isFirst = parent.getFirstChild() == text;
        boolean bl = isLast = parent.getLastChild() == text;
        if (isFirst || isLast) {
            String origValue = text.getNodeValue();
            TextLocator textLocator = (TextLocator)this._locatorMap.get(text);
            if (" ".equals(origValue)) {
                this._locatorMap.remove(text);
                parent.removeChild(text);
            } else {
                if (isFirst && origValue.startsWith(" ")) {
                    text.deleteData(0, 1);
                    textLocator.removeFirstCharFromContent();
                }
                if (isLast && origValue.endsWith(" ")) {
                    text.deleteData(text.getLength() - 1, 1);
                    textLocator.removeLastCharFromContent();
                }
            }
        }
    }

    private boolean _parentAllowsCharacterContent() {
        boolean allowsCharacterContent = true;
        if (this._currentParent == null || this._currentParent.getNodeType() == 9) {
            allowsCharacterContent = false;
        }
        return allowsCharacterContent;
    }

    private void _restore(Object key, Locator locator) {
        if (locator != null) {
            locator.attach(this._manager, true);
            this._locatorMap.put(key, locator);
        }
    }

    private void $init$() {
        this._manager = null;
        this._locatorMap = null;
        this._currentParent = null;
        this._currentDocumentScanner = null;
        this._textNodesWithModeTrim = new LinkedList();
    }
}

