/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.logging.Logger;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.BufferDomRelatedChange;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import org.w3c.dom.Node;

class AddOrRemoveEndTagLocatorChange
extends BufferDomRelatedChange {
    private final NodeRef _nodeRef;
    private final SimpleLocator _newEndLocator;
    private final boolean _isAdd;
    private static final Logger _LOGGER = Logger.getLogger(AddOrRemoveEndTagLocatorChange.class.getName());

    public AddOrRemoveEndTagLocatorChange(Node node, SimpleLocator newEndLocator, boolean isAdd) {
        this(NodeRefFactory.getNodeRef((Node)node), newEndLocator, isAdd);
    }

    public AddOrRemoveEndTagLocatorChange(NodeRef nodeRef, SimpleLocator newEndLocator, boolean isAdd) {
        this._nodeRef = nodeRef;
        this._newEndLocator = newEndLocator;
        this._isAdd = isAdd;
    }

    protected void preUndoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (this._isAdd) {
            this._removeEndTag(model, plugin);
        } else {
            this._addEndTag(model, plugin);
        }
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
    }

    protected void postRedoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (this._isAdd) {
            this._addEndTag(model, plugin);
        } else {
            this._removeEndTag(model, plugin);
        }
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
    }

    private void _removeEndTag(DomModel model, BufferDomModel plugin) {
        Node node = TextSyncUtils.getNode(model, this._nodeRef);
        ElementLocator curLocator = (ElementLocator)plugin.getLocator(node);
        plugin.getLocatorManager().removeEndTagAtLocator(curLocator);
    }

    private void _addEndTag(DomModel model, BufferDomModel plugin) {
        Node node = TextSyncUtils.getNode(model, this._nodeRef);
        ElementLocator curLocator = (ElementLocator)plugin.getLocator(node);
        plugin.getLocatorManager().addEndTagAtLocator(curLocator, (SimpleLocator)Locator.getCopy(this._newEndLocator));
    }
}

