/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomParseProblem;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.buffer.BufferDomDocumentParser;
import oracle.bali.xml.dom.buffer.BufferDomFragmentParser;
import oracle.bali.xml.dom.buffer.BufferDomParseCancelledException;
import oracle.bali.xml.dom.buffer.BufferDomTextSync;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.ReformatPCWrapper;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.bali.xml.dom.impl.DomModelPlugin;
import oracle.bali.xml.dom.impl.DomModelPluginContext;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.UndoableEditWrapper;
import oracle.bali.xml.share.WeakListenerProxy;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.NamedTimer;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public final class BufferDomModel
extends DomModelPlugin {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final Reference _bufferDomPluginRef;
    private static final int _DEFAULT_INDENTATION_SIZE = 2;
    private static final int _TIMER_DELAY = 750;
    private static final Timer _updateTimer;
    private volatile UpdateTimerTask _currentTask;
    private volatile boolean _forceParse;
    private volatile boolean _textSyncInProgress;
    private volatile int _synchedChangeCount;
    private volatile boolean _immediateParseInProgress;
    private volatile boolean _documentChangeInProgress;
    private volatile boolean _reparseAfterDocumentChange;
    private TextBuffer _textBuffer;
    private int _indentationSize;
    private LocatorManager _manager;
    private HashMap _locatorMap;
    private List _wfErrors;
    private XmlDeclarationInfo _xmlDeclarationInfo;
    private final ReadWriteLock _optionalTextBufferLock;
    private boolean _recomputeIndentSize;
    private boolean _inSetUnspecifiedAttribute;
    private ParserConfiguration _reformatPC;
    private TextBufferListener _weakTextBufferListenerWrapper;
    private final ParserConfiguration _parserConfiguration;
    private final DocumentScannerFactory _docScannerFactory;
    private final BufferDomDocumentParser _parser;
    private final BufferDomTextSync _textSync;
    private final Comparator _nodeComparatorByLocator;
    private final TextBufferListener _textBufferListener;

    public BufferDomModel(DomModelPluginContext context, TextBuffer textBuffer, DOMImplementation domImpl, ParserConfiguration parserConfiguration, DocumentScannerFactory docScannerFactory) {
        this(context, textBuffer, domImpl, parserConfiguration, docScannerFactory, null);
    }

    public BufferDomModel(DomModelPluginContext context, TextBuffer textBuffer, DOMImplementation domImpl, ParserConfiguration parserConfiguration, DocumentScannerFactory docScannerFactory, ReadWriteLock optionalTextBufferLock) {
        super(context);
        this.$init$();
        this._textBuffer = textBuffer;
        this._optionalTextBufferLock = optionalTextBufferLock;
        this._parser = new BufferDomDocumentParser(domImpl, parserConfiguration, docScannerFactory, context.getWhitespaceHandler());
        this._manager = new LocatorManager(this._textBuffer.getLineMap());
        this._locatorMap = new HashMap();
        this._attachTextBufferListener();
        this._parserConfiguration = parserConfiguration;
        this._docScannerFactory = docScannerFactory;
    }

    public DOMImplementation getDOMImplementation() {
        return this._parser.getDOMImplementation();
    }

    protected void ensureDocumentAvailable() {
        if (this._forceParse) {
            this._ensureSynchronizedImmediate();
        }
    }

    public boolean isReadOnly() {
        boolean isReadOnly;
        this.getContext().verifyLock();
        try {
            isReadOnly = this._textBuffer.isReadOnly();
        }
        catch (ExpiredTextBufferException e) {
            isReadOnly = true;
            this.getContext().getLogger().log(Level.INFO, "ExpiredTextBufferException encountered by DomModel.isReadOnly(), tolerating and returning true");
        }
        return isReadOnly;
    }

    public int getIndentSize() {
        this.getContext().verifyLock();
        return this._indentationSize;
    }

    public Locator getLocator(Node node) {
        this.getContext().verifyLock();
        return this._getLocatorDirectly(node);
    }

    public final Reference getBufferDomPluginReference() {
        return this._bufferDomPluginRef;
    }

    private Locator _getLocatorDirectly(Node node) {
        Locator ret = (Locator)this._locatorMap.get(node);
        if (ret != null) {
            return ret;
        }
        if (node == null) {
            throw new IllegalArgumentException("null node");
        }
        if (node.getNodeType() == 10 && node.getOwnerDocument() == this.getContext().getDocument()) {
            return this.getDocumentTypeLocator();
        }
        return null;
    }

    public DeclarationLocator getXMLDeclarationLocator() {
        this.getContext().verifyLock();
        return (DeclarationLocator)this._locatorMap.get(BufferDomDocumentParser.DECLARATION_LOCATOR_KEY);
    }

    public Locator getDocumentTypeLocator() {
        this.getContext().verifyLock();
        return (Locator)this._locatorMap.get(BufferDomDocumentParser.DOCUMENT_TYPE_LOCATOR_KEY);
    }

    public boolean isUnspecifiedAttribute(Attr attr) {
        this.getContext().verifyLock();
        AttributeLocator loc = (AttributeLocator)this._getLocatorDirectly(attr);
        return loc.isSpecified() ^ true;
    }

    protected void acquireReadLockDirectly() {
        this._textBuffer.readLock();
    }

    protected void releaseReadLockDirectly() {
        this._textBuffer.readUnlock();
    }

    protected void acquireWriteLockDirectly() {
        this._textBuffer.writeLock(false);
    }

    protected void releaseWriteLockDirectly() {
        this._textBuffer.writeUnlock();
    }

    public int getLockStatus() {
        return this._textBuffer.getLockStatus();
    }

    public List getCurrentDomParseProblems() {
        if (this._wfErrors == null) {
            this._doWfCheck();
        }
        return Collections.unmodifiableList(this._wfErrors);
    }

    public DomModel.FragmentParseResult parseFragment(Document document, Node contextNode, Map predefinedPrefixes, String text) {
        BufferDomFragmentParser parser;
        DocumentFragment fragment;
        if (document != null && (fragment = (parser = new BufferDomFragmentParser(this.getDOMImplementation(), this.getParserConfiguration(), this.getDocumentScannerFactory(), this.getContext().getWhitespaceHandler())).parseFragment(document, contextNode, predefinedPrefixes, text)) != null) {
            return new DomModel.FragmentParseResult(fragment);
        }
        return null;
    }

    protected XmlDeclarationInfo getXmlDeclarationInfo() {
        this.getContext().verifyLock();
        return this._xmlDeclarationInfo;
    }

    protected UndoableEdit setXmlDeclarationInfo(XmlDeclarationInfo info) {
        StringBuffer insertionBuffer = null;
        DeclarationLocator oldDeclLocator = this.getXMLDeclarationLocator();
        if (info == null) {
            if (oldDeclLocator == null) {
                return null;
            }
        } else {
            if (oldDeclLocator != null && ((Locator)oldDeclLocator).getStartOffset() == 0 && info.equals(this._xmlDeclarationInfo)) {
                return null;
            }
            insertionBuffer = info.getAsXml();
            insertionBuffer.append('\n');
        }
        UndoableEdit edit = null;
        this._textSyncInProgress = true;
        this._textBuffer.beginEdit();
        try {
            if (oldDeclLocator != null) {
                Node firstChild;
                int start = ((Locator)oldDeclLocator).getStartOffset();
                int end = ((Locator)oldDeclLocator).getEndOffset();
                Document doc = this.getContext().getDocument();
                Node node = firstChild = doc == null ? null : doc.getFirstChild();
                if (firstChild != null) {
                    Locator fcLoc = this._getLocatorDirectly(firstChild);
                    end = Math.max(end, fcLoc.getStartOffset());
                }
                this._textBuffer.remove(start, end - start);
            }
            if (insertionBuffer != null) {
                this._textBuffer.insert(0, insertionBuffer.toString().toCharArray());
            }
        }
        finally {
            edit = this._textBuffer.endEdit();
            this._textSyncInProgress = false;
        }
        if (edit != null) {
            this._ensureSynchronizedImmediate();
            return new ForceReparseUndoableEditWrapper(this, edit);
        }
        return null;
    }

    protected void reformatSubtree(String undoLabel, Node node, Object options) {
        this.getContext().startTransaction(undoLabel);
        this.acquireWriteLockDirectly();
        try {
            this._reformatPC = new ReformatPCWrapper(this._parserConfiguration, this, node, options);
            if (DomUtils.isDocument((Node)node)) {
                NodeList children;
                Element root = ((Document)node).getDocumentElement();
                ElementLocator rootLocator = (ElementLocator)this._getLocatorDirectly(root);
                if (rootLocator.getNameLocator().getLength() == 0) {
                    node = root;
                }
                if ((children = node.getChildNodes()).getLength() > 0) {
                    Node[] removedChildren = new Node[children.getLength()];
                    int i = 0;
                    while (i < children.getLength()) {
                        Node child = children.item(i);
                        if (child.getNodeType() != 10) {
                            removedChildren[i] = child;
                            this._removeUnspecifiedAttributes(child);
                        }
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < removedChildren.length) {
                        Node child = removedChildren[i2];
                        if (child != null) {
                            node.removeChild(child);
                        }
                        ++i2;
                    }
                    int i3 = 0;
                    while (i3 < removedChildren.length) {
                        Node child = removedChildren[i3];
                        if (child != null) {
                            DomUtils.insertChildAtIndex((Node)child, (Node)node, (int)i3);
                        }
                        ++i3;
                    }
                }
            } else {
                Node parent = node.getParentNode();
                Node nextSibling = node.getNextSibling();
                parent.removeChild(node);
                parent.insertBefore(node, nextSibling);
            }
            this.getContext().commitTransaction();
        }
        finally {
            this._reformatPC = null;
            this.releaseWriteLockDirectly();
        }
    }

    protected void refreshModel(boolean force) {
        if (this.getContext().getLogger().isLoggable(Level.FINER)) {
            this.getContext().getLogger().log(Level.FINER, "refreshModel syncedCount={0} thread={1}", new Object[]{IntegerUtils.getInteger((int)this._synchedChangeCount), Thread.currentThread()});
        }
        if (force) {
            if (this._documentChangeInProgress) {
                this._reparseAfterDocumentChange = true;
                return;
            }
            this._forceParse = true;
        }
        this._ensureSynchronizedImmediate();
    }

    public boolean needsReparse() {
        return this._isOutOfSync();
    }

    protected LocatorManager getLocatorManager() {
        return this._manager;
    }

    protected void mapNodeToLocator(Node node, Locator locator) {
        if (node != null) {
            if (locator == null) {
                this._locatorMap.remove(node);
            } else {
                this._locatorMap.put(node, locator);
            }
        }
    }

    protected void nodeSubtreeInserted(Node newNode) {
        Locator locator = this._getLocatorDirectly(newNode);
        if (locator == null) {
            throw new IllegalArgumentException("Nodes must be mapped to Locators prior to calling this method.");
        }
        this._attachNodeLocators(newNode, false);
        this._manager.charactersAdded(locator.getStartOffset(), locator.getLength());
        this._attachNodeLocators(newNode, true);
    }

    protected void nodeSubtreeRemoved(Node oldNode) {
        Locator locator = this._getLocatorDirectly(oldNode);
        if (locator == null) {
            throw new IllegalArgumentException("Nodes must be mapped to Locators prior to calling this method.");
        }
        this._attachNodeLocators(oldNode, false);
        this._manager.charactersRemoved(locator.getStartOffset(), locator.getLength());
    }

    protected void getTextOffsets(Node node, int[] results) {
        if (DomUtils.isDocument((Node)node)) {
            results[0] = 0;
            results[1] = this._textBuffer.getLength();
        } else {
            Locator loc = this._getLocatorDirectly(node);
            if (loc == null) {
                super.getTextOffsets(node, results);
            } else {
                results[0] = loc.getStartOffset();
                results[1] = loc.getEndOffset();
            }
        }
    }

    protected int getTextOffset(DomPosition pos) {
        Node node = pos.getTargetNode();
        int relPos = pos.getRelativePosition();
        Locator loc = this._getLocatorDirectly(node);
        if (loc != null) {
            switch (relPos) {
                case 1: {
                    return loc.getStartOffset();
                }
                case 2: {
                    return loc.getEndOffset();
                }
                case 0: {
                    if (pos.hasTextOffset()) {
                        return this._getSubNodeTextOffset(pos, loc);
                    }
                    if (DomUtils.isElement((Node)node)) {
                        Locator lastChildLoc;
                        Node lastChild = node.getLastChild();
                        if (lastChild != null && (lastChildLoc = this._getLocatorDirectly(lastChild)) != null) {
                            return lastChildLoc.getEndOffset();
                        }
                        ElementLocator eLoc = (ElementLocator)loc;
                        SimpleLocator endTagLoc = eLoc.getEndTagLocator();
                        if (endTagLoc != null) {
                            return ((Locator)endTagLoc).getStartOffset();
                        }
                        return loc.getEndOffset();
                    }
                    return loc.getEndOffset();
                }
            }
        }
        return -1;
    }

    protected Node getNodeAtOffset(int offset) {
        return this._getNodeAtOffsetHelper(this.getContext().getDocument(), offset);
    }

    protected DomPosition getDomPosition(int caretPosition, boolean considerAttrs) {
        DomPosition domPos = null;
        Node containingNode = this._getNodeContainingCaretPosition(this.getContext().getDocument(), caretPosition);
        if (containingNode == null) {
            containingNode = this.getContext().getDocument();
        }
        if (containingNode != null) {
            SimpleLocator startLocator;
            ElementLocator elementLocator;
            if (containingNode.getNodeType() == 1 && (elementLocator = (ElementLocator)this._getLocatorDirectly(containingNode)) != null && (startLocator = elementLocator.getStartTagLocator()) != null && startLocator.containsNotAtStart(caretPosition)) {
                NamedNodeMap attrs;
                if (considerAttrs && (attrs = containingNode.getAttributes()) != null) {
                    int numAttrs = attrs.getLength();
                    int i = 0;
                    while (i < numAttrs) {
                        TextLocator valueLocator;
                        Attr attr = (Attr)attrs.item(i);
                        AttributeLocator attrLocator = (AttributeLocator)this._getLocatorDirectly(attr);
                        if (attrLocator != null && (valueLocator = attrLocator.getValueLocator()) != null && valueLocator.containsNotAtStart(caretPosition)) {
                            int domContentPosition = 0;
                            domPos = DomPositionFactory.createAttributePosition((Attr)attr, (int)domContentPosition);
                            break;
                        }
                        ++i;
                    }
                }
                if (domPos == null) {
                    domPos = DomPositionFactory.inside((Node)containingNode);
                }
            }
            if (domPos == null) {
                SimpleLocator loc;
                Node firstChild = containingNode.getFirstChild();
                if (firstChild != null) {
                    Node current = firstChild;
                    Node nodeBeforeCaret = null;
                    while (current != null) {
                        Locator childLocator = this._getLocatorDirectly(current);
                        if (childLocator != null) {
                            if (caretPosition < childLocator.getEndOffset()) break;
                            nodeBeforeCaret = current;
                        }
                        current = current.getNextSibling();
                    }
                    domPos = nodeBeforeCaret != null ? DomPositionFactory.after(nodeBeforeCaret) : DomPositionFactory.before((Node)firstChild);
                } else if (DomUtils.isText((Node)containingNode)) {
                    TextLocator loc2 = (TextLocator)this._getLocatorDirectly(containingNode);
                    if (loc2 != null) {
                        int contentPos = this._convertToDomContentPosition(loc2, caretPosition);
                        return DomPositionFactory.createTextPosition((CharacterData)((Text)containingNode), (int)contentPos);
                    }
                } else if ((DomUtils.isNodeType((Node)containingNode, (int)8) || DomUtils.isNodeType((Node)containingNode, (int)4)) && (loc = (SimpleLocator)this._getLocatorDirectly(containingNode)) != null) {
                    int pos = caretPosition - loc.getStartOffset();
                    return DomPositionFactory.createTextPosition((CharacterData)((CharacterData)containingNode), (int)pos);
                }
                if (domPos == null) {
                    domPos = DomPositionFactory.createInsideOrAfterPosition((Node)containingNode);
                }
            }
        }
        return domPos;
    }

    protected SortedSet getSortedAttributesSet(Node node) {
        TreeSet<Node> set = new TreeSet<Node>(this.getNodeByLocatorComparator());
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                set.add(attrs.item(i));
                ++i;
            }
        }
        return set;
    }

    protected Comparator getNodeByLocatorComparator() {
        return this._nodeComparatorByLocator;
    }

    protected void handleUncommittedMutationEventHook(DomChange domChange, MutationEvent mEvent, boolean modifiesUndoStack) {
        super.handleUncommittedMutationEventHook(domChange, mEvent, modifiesUndoStack);
        if (this._recomputeIndentSize) {
            this._recomputeIndentSize = false;
            Node target = (Node)((Object)mEvent.getTarget());
            this._updateIndentationSize(DomUtils.getOwnerDocument((Node)target));
        }
        if (modifiesUndoStack) {
            this._textSync.handleChange(domChange, mEvent);
        }
    }

    protected void handleChangeRollbackPreHook(DomChange change) {
        super.handleChangeRollbackPreHook(change);
        this._textSync.preRollbackChange(change);
    }

    protected void handleChangeRollbackPostHook(DomChange change) {
        super.handleChangeRollbackPostHook(change);
        this._textSync.postRollbackChange(change);
    }

    protected void handleCommittedDomChanges(DomChangesUndoableEdit domChanges) {
        this._textSyncInProgress = true;
        UndoableEdit textEdit = this._textSync.applyChanges();
        if (textEdit != null) {
            domChanges.addSubEdit(textEdit);
        }
        this._synchedChangeCount = this._textBuffer.getChangeId();
        this._textSyncInProgress = false;
    }

    protected void handleUndoOccuredPreHook(DomChangesUndoableEdit edit) {
        this._textSyncInProgress = true;
    }

    protected void handleUndoOccuredPostHook(DomChangesUndoableEdit edit) {
        this._synchedChangeCount = this._textBuffer.getChangeId();
        this._textSyncInProgress = false;
    }

    protected void handleRedoOccuredPreHook(DomChangesUndoableEdit edit) {
        this._textSyncInProgress = true;
    }

    protected void handleRedoOccuredPostHook(DomChangesUndoableEdit edit) {
        this._synchedChangeCount = this._textBuffer.getChangeId();
        this._textSyncInProgress = false;
    }

    protected TextBuffer getTextBuffer() {
        return this._textBuffer;
    }

    protected Map getExtraPropertyChanges(Node changeTarget, int changeFlags, boolean isNestedTransaction, boolean isUndoRedoTransaction) {
        Logger log = this.getContext().getLogger();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "WFCheck getExtraProps: nested={0} target={1} flags={2}", new Object[]{isNestedTransaction, changeTarget, new Integer(changeFlags)});
        }
        if (!isNestedTransaction && (changeFlags & 0x1F) > 0) {
            List oldErrs = this._wfErrors;
            if (!isUndoRedoTransaction && oldErrs != null && oldErrs.isEmpty() && changeTarget != null && changeTarget.getNodeType() != 9) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "WFCheck skipped: target={0} oldErrs={1} flags={2}", new Object[]{changeTarget, oldErrs, new Integer(changeFlags)});
                }
            } else {
                if (oldErrs != null && !oldErrs.isEmpty()) {
                    for (DomParseProblem problem : oldErrs) {
                        problem.dispose();
                    }
                }
                this._doWfCheck();
                Collections.sort(this._wfErrors);
                PropertyChange change = new PropertyChange("parseProblems", oldErrs, this._wfErrors);
                return Collections.singletonMap(change.getPropertyName(), change);
            }
        }
        return null;
    }

    protected final DocumentScannerFactory getDocumentScannerFactory() {
        return this._docScannerFactory;
    }

    protected final ParserConfiguration getParserConfiguration() {
        ParserConfiguration reformatPC = this._reformatPC;
        if (reformatPC != null) {
            return reformatPC;
        }
        return this._parserConfiguration;
    }

    protected UndoableEdit removeDocType() {
        Locator doctypeLocator = this.getDocumentTypeLocator();
        if (doctypeLocator != null) {
            Locator firstLoc;
            Node firstNode;
            int start = doctypeLocator.getStartOffset();
            int end = doctypeLocator.getEndOffset();
            DocumentType doctype = this._getDocType();
            if (doctype != null && (firstNode = doctype.getNextSibling()) != null && (firstLoc = this._getLocatorDirectly(firstNode)) != null) {
                end = firstLoc.getStartOffset();
            }
            this._textBuffer.beginEdit();
            this._textSyncInProgress = true;
            UndoableEdit edit = null;
            try {
                this._textBuffer.remove(start, end - start);
            }
            finally {
                edit = this._textBuffer.endEdit();
                this._textSyncInProgress = false;
            }
            if (edit != null) {
                this._ensureSynchronizedImmediate();
                return new ForceReparseUndoableEditWrapper(this, edit);
            }
        }
        return null;
    }

    protected UndoableEdit setDocType(String qualifiedName, String publicId, String systemId) {
        int quoteChar = 34;
        StringBuffer buf = new StringBuffer(300);
        buf.append("<!DOCTYPE ");
        buf.append(qualifiedName);
        if (systemId != null) {
            buf.append(" ");
            if (publicId != null) {
                buf.append("PUBLIC ");
                buf.append('\"');
                buf.append(publicId);
                buf.append('\"');
            } else {
                buf.append("SYSTEM");
            }
            buf.append(" ");
            buf.append('\"');
            buf.append(systemId);
            buf.append('\"');
        } else if (publicId != null) {
            this.getContext().getLogger().log(Level.WARNING, "Tried to set public ID to ''{0}'' with no system id!", publicId);
        }
        buf.append(">");
        UndoableEdit textEdit = null;
        this._textSyncInProgress = true;
        this._textBuffer.beginEdit();
        try {
            int insertOffset;
            Locator oldDoctypeLocator = this.getDocumentTypeLocator();
            if (oldDoctypeLocator != null) {
                insertOffset = oldDoctypeLocator.getStartOffset();
                this._textBuffer.remove(insertOffset, oldDoctypeLocator.getLength());
            } else {
                DeclarationLocator xmlDeclLocator = this.getXMLDeclarationLocator();
                if (xmlDeclLocator != null) {
                    buf.insert(0, '\n');
                    insertOffset = ((Locator)xmlDeclLocator).getEndOffset();
                } else {
                    insertOffset = 0;
                    buf.append('\n');
                }
            }
            this._textBuffer.insert(insertOffset, buf.toString().toCharArray());
        }
        finally {
            this._textSyncInProgress = false;
            textEdit = this._textBuffer.endEdit();
        }
        this._ensureSynchronizedImmediate();
        if (textEdit == null) {
            return null;
        }
        return new ForceReparseUndoableEditWrapper(this, textEdit);
    }

    protected Attr setUnspecifiedAttribute(Element owner, String namespaceURI, String qname, String value) {
        this._inSetUnspecifiedAttribute = true;
        try {
            Attr attr = super.setUnspecifiedAttribute(owner, namespaceURI, qname, value);
            return attr;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this._inSetUnspecifiedAttribute = false;
        }
    }

    protected void dispose() {
        this.getBufferDomPluginReference().clear();
    }

    boolean __isInSetUnspecifiedAttribute() {
        return this._inSetUnspecifiedAttribute;
    }

    private void _attachTextBufferListener() {
        if (this._textBuffer != null) {
            this._weakTextBufferListenerWrapper = (TextBufferListener)WeakListenerProxy.create(TextBufferListener.class, (Object)this._textBufferListener, TextBuffer.class, (Object)this._textBuffer, (String)"removeTextBufferListener");
            this._textBuffer.addTextBufferListener(this._weakTextBufferListenerWrapper);
        }
    }

    private void _detachTextBufferListener() {
        if (this._textBuffer != null && this._weakTextBufferListenerWrapper != null) {
            this._textBuffer.removeTextBufferListener(this._weakTextBufferListenerWrapper);
            this._weakTextBufferListenerWrapper = null;
        }
    }

    private DocumentType _getDocType() {
        Document doc = this.getContext().getDocument();
        if (doc != null) {
            return doc.getDoctype();
        }
        return null;
    }

    private int _convertToDomContentPosition(TextLocator textLocator, int textBufferCaretPosition) {
        int domContentPosition = 0;
        List contentLocators = textLocator.getContentLocators();
        for (SimpleLocator loc : contentLocators) {
            int startOffset = loc.getStartOffset();
            if (textBufferCaretPosition <= startOffset) break;
            int domLength = loc.getDomLength();
            if (textBufferCaretPosition < loc.getEndOffset()) {
                int approxPosInside = textBufferCaretPosition - startOffset;
                if (domLength < approxPosInside) {
                    approxPosInside = domLength;
                }
                domContentPosition += approxPosInside;
                break;
            }
            domContentPosition += domLength;
        }
        return domContentPosition;
    }

    private int _getSubNodeTextOffset(DomPosition pos, Locator loc) {
        Node node = pos.getTargetNode();
        int offset = pos.getTextOffset();
        if (pos.hasAttributeQName()) {
            Attr attr = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)pos.getAttributeQName());
            if (attr == null || this.isUnspecifiedAttribute(attr)) {
                return -1;
            }
            node = attr;
            loc = this._getLocatorDirectly(attr);
        }
        if (offset < 0 || offset > node.getNodeValue().length()) {
            return -1;
        }
        switch (node.getNodeType()) {
            case 3: {
                return ((TextLocator)loc).getContentTextOffset(offset);
            }
            case 2: {
                AttributeLocator al = (AttributeLocator)loc;
                TextLocator valueLoc = al.getValueLocator();
                if (valueLoc == null) {
                    return -1;
                }
                int ret = valueLoc.getContentTextOffset(offset);
                if (ret != -1 && al.isStartQuotePresent()) {
                    ++ret;
                }
                return ret;
            }
            case 4: {
                return loc.getStartOffset() + 9 + offset;
            }
            case 8: {
                return loc.getStartOffset() + 4 + offset;
            }
        }
        throw new IllegalArgumentException("no subnode location for " + pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node _getNodeAtOffsetHelper(Node currentNode, int offset) {
        boolean locatorContainsCurrentNode = false;
        if (currentNode == null) return null;
        Locator currentLocator = this._getLocatorDirectly(currentNode);
        if (currentLocator != null) {
            if (!currentLocator.contains(offset)) return null;
            locatorContainsCurrentNode = true;
        }
        if (currentNode.getNodeType() == 1 || currentNode.getNodeType() == 9) {
            Node child = currentNode.getFirstChild();
            Node nodeAtOffset = null;
            while (child != null) {
                nodeAtOffset = this._getNodeAtOffsetHelper(child, offset);
                if (nodeAtOffset != null) {
                    return nodeAtOffset;
                }
                child = child.getNextSibling();
            }
        }
        if (!locatorContainsCurrentNode) return null;
        return currentNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node _getNodeContainingCaretPosition(Node currentNode, int caretPosition) {
        boolean nodeContainsCaretPosition = false;
        if (currentNode == null) return null;
        Locator currentLocator = this._getLocatorDirectly(currentNode);
        if (currentLocator != null) {
            if (caretPosition <= currentLocator.getStartOffset() || caretPosition >= currentLocator.getEndOffset()) return null;
            nodeContainsCaretPosition = true;
        }
        if (currentNode.getNodeType() == 1 || currentNode.getNodeType() == 9) {
            Node child = currentNode.getFirstChild();
            Node containingNode = null;
            while (child != null) {
                containingNode = this._getNodeContainingCaretPosition(child, caretPosition);
                if (containingNode != null) {
                    return containingNode;
                }
                child = child.getNextSibling();
            }
        }
        if (!nodeContainsCaretPosition) return null;
        return currentNode;
    }

    private void _ensureSynchronizedImmediate() {
        if (this._immediateParseInProgress) {
            return;
        }
        if (this._textSyncInProgress) {
            return;
        }
        try {
            this._immediateParseInProgress = true;
            this._realEnsureSynchronizedImmediate();
        }
        finally {
            this._immediateParseInProgress = false;
        }
    }

    private void _realEnsureSynchronizedImmediate() {
        if (this._currentTask != null) {
            this._currentTask.cancel();
            this._currentTask = null;
        }
        if (this._isOutOfSync()) {
            this._forceParse = false;
            Integer[] changeCounts = new Integer[2];
            changeCounts[0] = IntegerUtils.getInteger((int)this._synchedChangeCount);
            long before = System.currentTimeMillis();
            LocatorManager manager = new LocatorManager(this._textBuffer.getLineMap());
            HashMap locatorMap = new HashMap();
            Document newDocument = null;
            try {
                newDocument = BufferDomModel._parseCurrentTextBuffer(this._parser, this._textBuffer, manager, locatorMap, changeCounts, this.getContext().getLogger(), null);
            }
            catch (BufferDomParseCancelledException parseCancelledEx) {
                throw new IllegalStateException("BufferDomModel: Parse cancelled during ensureSynchronizedImmediate");
            }
            long after = System.currentTimeMillis();
            Logger log = this.getContext().getLogger();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "BufferDom parse time (foreground): {0}ms file={1}", new Object[]{new Long(after - before), this});
            }
            this._changeDocument(newDocument, this._parser.__getXmlDeclarationInfo(), manager, locatorMap, changeCounts);
        }
    }

    private void _ensureSynchronizedThreaded() {
        if (this._isOutOfSync()) {
            BufferDomDocumentParser parser = new BufferDomDocumentParser(this._parser.getDOMImplementation(), this._parser.getParserConfiguration(), this._parser.getDocumentScannerFactory(), this._parser.getWhitespaceHandler());
            LocatorManager manager = new LocatorManager(this._textBuffer.getLineMap());
            HashMap locatorMap = new HashMap();
            Integer[] changeCounts = new Integer[2];
            changeCounts[0] = IntegerUtils.getInteger((int)this._synchedChangeCount);
            long before = System.currentTimeMillis();
            Document newDocument = null;
            boolean parseCancelled = false;
            try {
                newDocument = BufferDomModel._parseCurrentTextBuffer(parser, this._textBuffer, manager, locatorMap, changeCounts, this.getContext().getLogger(), this._optionalTextBufferLock);
            }
            catch (BufferDomParseCancelledException parseCancelledEx) {
                parseCancelled = true;
            }
            long after = System.currentTimeMillis();
            Logger log = this.getContext().getLogger();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "BufferDom parse time (background, cancelled={0}, thread={1}): {2}ms file={3}", new Object[]{parseCancelled, Thread.currentThread(), new Long(after - before), this});
            }
            if (!parseCancelled) {
                this._changeDocument(newDocument, parser.__getXmlDeclarationInfo(), manager, locatorMap, changeCounts);
            }
        }
    }

    private boolean _isOutOfSync() {
        if (this._textSyncInProgress) {
            return false;
        }
        if (this._forceParse) {
            return true;
        }
        return this._synchedChangeCount != this._textBuffer.getChangeId();
    }

    private static Document _parseCurrentTextBuffer(BufferDomDocumentParser parser, TextBuffer textBuffer, LocatorManager manager, HashMap locatorMap, Integer[] changeCounts, Logger logger, ReadWriteLock optionalLockUsedToCancelParse) throws BufferDomParseCancelledException {
        Document document = null;
        manager.clear();
        locatorMap.clear();
        ParseCancelListener parseCancelListener = new ParseCancelListener(parser);
        try {
            try {
                textBuffer.readLock();
                if (optionalLockUsedToCancelParse != null) {
                    optionalLockUsedToCancelParse.addWriteLockRequestListener((WriteLockRequestListener)parseCancelListener);
                }
                changeCounts[1] = IntegerUtils.getInteger((int)textBuffer.getChangeId());
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "About to parse; oldCount={0} newCount={1} thread={2}", new Object[]{changeCounts[0], changeCounts[1], Thread.currentThread().getName()});
                }
                if (parseCancelListener.isCancelled()) {
                    throw new BufferDomParseCancelledException();
                }
                document = parser.parse((ReadTextBuffer)textBuffer, manager, locatorMap);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "DONE parse; oldCount={0} newCount={1} thread={2}", new Object[]{changeCounts[0], changeCounts[1], Thread.currentThread().getName()});
                }
            }
            catch (BufferDomParseCancelledException parseCancelled) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "CANCELLED parse; oldCount={0} newCount={1} thread={2}", new Object[]{changeCounts[0], changeCounts[1], Thread.currentThread().getName()});
                }
                throw parseCancelled;
            }
            catch (RuntimeException unexpected) {
                logger.log(Level.SEVERE, "BufferDomModel parse failed with unexpected exception", unexpected);
                document = null;
            }
        }
        finally {
            if (optionalLockUsedToCancelParse != null) {
                optionalLockUsedToCancelParse.removeWriteLockRequestListener((WriteLockRequestListener)parseCancelListener);
            }
            textBuffer.readUnlock();
        }
        return document;
    }

    static {
        $assertionsDisabled = BufferDomModel.class.desiredAssertionStatus() ^ true;
        _updateTimer = new NamedTimer("BufferDomModel background parse thread", 1, true);
    }

    private void _changeDocument(Document document, XmlDeclarationInfo xmlDecl, LocatorManager manager, HashMap locatorMap, Integer[] changeCounts) {
        if (!$assertionsDisabled && !BufferDomModel._assertLocatorStateAfterReparse(document, xmlDecl, manager, locatorMap)) {
            throw new AssertionError();
        }
        if (changeCounts[0] == this._synchedChangeCount) {
            this.acquireWriteLockDirectly();
            this._documentChangeInProgress = true;
            try {
                this._synchedChangeCount = changeCounts[1];
                this.getContext().firePropertyChange("textBufferModified", Boolean.FALSE, Boolean.TRUE);
                if (this._manager != manager) {
                    this._manager.clear();
                    this._manager = manager;
                }
                if (this._locatorMap != locatorMap) {
                    this._locatorMap.clear();
                    this._locatorMap = locatorMap;
                }
                this._xmlDeclarationInfo = xmlDecl;
                this.getContext().replaceDocument(document);
                if (this._reparseAfterDocumentChange) {
                    this._reparseAfterDocumentChange = false;
                    this._documentChangeInProgress = false;
                    this._forceParse = true;
                    this._realEnsureSynchronizedImmediate();
                }
            }
            finally {
                this._reparseAfterDocumentChange = false;
                this._documentChangeInProgress = false;
                this.releaseWriteLockDirectly();
            }
        }
    }

    protected void postReplaceDocument(Document newDocument) {
        this._recomputeIndentSize = true;
        if (newDocument == null) {
            this._manager.clear();
            this._locatorMap.clear();
            this._forceParse = true;
        }
    }

    private void _attachNodeLocators(Node node, boolean attach) {
        Locator locator = this._getLocatorDirectly(node);
        Locator.attach(this._manager, attach, locator);
        if (node.getNodeType() == 1) {
            Node child = node.getFirstChild();
            while (child != null) {
                this._attachNodeLocators(child, attach);
                child = child.getNextSibling();
            }
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            if (attributes != null) {
                int numAttributes = attributes.getLength();
                int i = 0;
                while (i < numAttributes) {
                    Attr attr = (Attr)attributes.item(i);
                    if (attr != null) {
                        this._attachNodeLocators(attr, attach);
                    }
                    ++i;
                }
            }
        }
    }

    private void _updateIndentationSize(Document document) {
        Element root;
        if (document != null && (root = document.getDocumentElement()) != null) {
            int[] frequencies = new int[8];
            ElementLocator rootLocator = (ElementLocator)this._getLocatorDirectly(root);
            this._findIndentationSizeForChildren(root, rootLocator, frequencies);
            int maxFrequency = 0;
            int maxIndentValue = -1;
            int i = 0;
            while (i < frequencies.length) {
                if (frequencies[i] > maxFrequency) {
                    maxIndentValue = i + 1;
                    maxFrequency = frequencies[i];
                }
                ++i;
            }
            if (maxIndentValue != -1) {
                this._indentationSize = maxIndentValue;
            }
        }
    }

    private void _findIndentationSizeForChildren(Element parent, ElementLocator parentLocator, int[] frequencies) {
        this._findIndentationSizeForChildrenHelper(parent, parentLocator, frequencies, 0);
    }

    private void _findIndentationSizeForChildrenHelper(Element parent, ElementLocator parentLocator, int[] frequencies, int depth) {
        if (depth >= 8) {
            return;
        }
        if (parentLocator == null) {
            return;
        }
        SimpleLocator parentStartLocator = parentLocator.getStartTagLocator();
        int childIndex = 0;
        Node child = parent.getFirstChild();
        while (child != null && childIndex < 10) {
            Locator childLocator = this._getLocatorDirectly(child);
            if (childLocator != null) {
                int childIndent;
                if (DomUtils.isElement((Node)child)) {
                    Element childElem = (Element)child;
                    ElementLocator childElemLocator = (ElementLocator)childLocator;
                    childIndent = this._getIndentationBetweenLocators(parentStartLocator, childElemLocator.getStartTagLocator());
                    this._findIndentationSizeForChildrenHelper(childElem, childElemLocator, frequencies, depth + 1);
                } else {
                    childIndent = this._getIndentationBetweenLocators(parentStartLocator, childLocator);
                }
                if (childIndent > 0 && childIndent <= 8) {
                    int n = childIndent - 1;
                    frequencies[n] = frequencies[n] + 1;
                }
            }
            child = child.getNextSibling();
            ++childIndex;
        }
    }

    private int _getIndentationBetweenLocators(Locator parent, Locator child) {
        if (parent.getStartLineNumber() == child.getStartLineNumber()) {
            return 0;
        }
        return child.getStartColumnNumber() - parent.getStartColumnNumber();
    }

    private void _doWfCheck() {
        List wfErrors = Collections.EMPTY_LIST;
        try {
            try {
                wfErrors = this._parserConfiguration.doWellFormednessCheck(this, this.getTextBuffer());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                this.getContext().getLogger().log(Level.WARNING, "Exception in well-formedness check!", t);
            }
        }
        finally {
            this._wfErrors = wfErrors;
        }
    }

    private void _removeUnspecifiedAttributes(Node node) {
        Node walk;
        NodeIterator itor = ((DocumentTraversal)((Object)DomUtils.getOwnerDocument((Node)node))).createNodeIterator(node, 1, null, false);
        ArrayList<Attr> attrsToRemove = new ArrayList<Attr>(5);
        while ((walk = itor.nextNode()) != null) {
            NamedNodeMap attrs = walk.getAttributes();
            if (attrs == null) continue;
            int i = 0;
            while (i < attrs.getLength()) {
                Attr attr = (Attr)attrs.item(i);
                if (this.isUnspecifiedAttribute(attr)) {
                    attrsToRemove.add(attr);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < attrsToRemove.size()) {
            Attr attr = (Attr)attrsToRemove.get(i);
            attr.getOwnerElement().removeAttributeNode(attr);
            ++i;
        }
        itor.detach();
    }

    private static boolean _assertLocatorStateAfterReparse(Document document, XmlDeclarationInfo xmlDecl, LocatorManager manager, Map locatorMap) {
        if (!$assertionsDisabled && document == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && manager == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && locatorMap == null) {
            throw new AssertionError();
        }
        BufferDomModel._assertLocatorStateForNode(document, manager, locatorMap);
        if (xmlDecl != null) {
            BufferDomModel._assertLocatorOK(BufferDomDocumentParser.DECLARATION_LOCATOR_KEY, locatorMap, manager);
        }
        return true;
    }

    private static void _assertLocatorStateForNode(Node node, LocatorManager manager, Map locatorMap) {
        BufferDomModel._assertLocatorOK(node, locatorMap, manager);
        if (node.getNodeType() != 2) {
            Node child = node.getFirstChild();
            while (child != null) {
                BufferDomModel._assertLocatorStateForNode(child, manager, locatorMap);
                child = child.getNextSibling();
            }
            NamedNodeMap attrs = node.getAttributes();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    BufferDomModel._assertLocatorStateForNode(attrs.item(i), manager, locatorMap);
                    ++i;
                }
            }
        }
    }

    private static void _assertLocatorOK(Object key, Map locatorMap, LocatorManager manager) {
        if (key instanceof DocumentType) {
            key = BufferDomDocumentParser.DOCUMENT_TYPE_LOCATOR_KEY;
        } else if (key instanceof Document) {
            return;
        }
        Object loc = locatorMap.get(key);
        if (!$assertionsDisabled && loc == null) {
            throw new AssertionError((Object)("locator null for key " + key));
        }
        if (!$assertionsDisabled && !(loc instanceof Locator)) {
            throw new AssertionError((Object)("locator has wrong type for key " + key));
        }
    }

    private void $init$() {
        this._bufferDomPluginRef = new WeakReference<BufferDomModel>(this);
        this._currentTask = null;
        this._forceParse = true;
        this._textSyncInProgress = false;
        this._immediateParseInProgress = false;
        this._documentChangeInProgress = false;
        this._reparseAfterDocumentChange = false;
        this._indentationSize = 2;
        this._xmlDeclarationInfo = null;
        this._recomputeIndentSize = true;
        this._inSetUnspecifiedAttribute = false;
        this._reformatPC = null;
        this._textSync = new BufferDomTextSync(this);
        this._nodeComparatorByLocator = new NodeComparatorByLocator(null);
        this._textBufferListener = new TextBufferChangeListener(null);
    }

    static boolean ra$_textSyncInProgress(BufferDomModel bufferDomModel) {
        return bufferDomModel._textSyncInProgress;
    }

    static UpdateTimerTask ra$_currentTask(BufferDomModel bufferDomModel) {
        return bufferDomModel._currentTask;
    }

    static void wa$_currentTask(BufferDomModel bufferDomModel, UpdateTimerTask updateTimerTask) {
        bufferDomModel._currentTask = updateTimerTask;
    }

    static Timer ra$_updateTimer() {
        return _updateTimer;
    }

    static Locator mav$_getLocatorDirectly(BufferDomModel bufferDomModel, Node node) {
        return bufferDomModel._getLocatorDirectly(node);
    }

    static void mav$_ensureSynchronizedThreaded(BufferDomModel bufferDomModel) {
        bufferDomModel._ensureSynchronizedThreaded();
    }

    static void wa$_textSyncInProgress(BufferDomModel bufferDomModel, boolean bl) {
        bufferDomModel._textSyncInProgress = bl;
    }

    static void mav$_ensureSynchronizedImmediate(BufferDomModel bufferDomModel) {
        bufferDomModel._ensureSynchronizedImmediate();
    }

    private class TextBufferChangeListener
    implements TextBufferListener {
        public void insertUpdate(TextBuffer buffer, int startOffset, int length, char[] chars) {
            this._onTextBufferModification();
        }

        public void removeUpdate(TextBuffer buffer, int startOffset, int length, char[] chars) {
            this._onTextBufferModification();
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
            if (attribute == 2) {
                BufferDomModel.this.getContext().handleReadOnlyStatusChange();
            }
        }

        private void _onTextBufferModification() {
            if (!BufferDomModel.ra$_textSyncInProgress(BufferDomModel.this)) {
                if (BufferDomModel.ra$_currentTask(BufferDomModel.this) != null) {
                    BufferDomModel.ra$_currentTask(BufferDomModel.this).cancel();
                }
                BufferDomModel.wa$_currentTask(BufferDomModel.this, new UpdateTimerTask(BufferDomModel.this));
                BufferDomModel.ra$_updateTimer().schedule((TimerTask)BufferDomModel.ra$_currentTask(BufferDomModel.this), 750L);
            }
        }

        private TextBufferChangeListener() {
        }

        TextBufferChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeComparatorByLocator
    implements Comparator {
        public int compare(Object a, Object b) {
            if (a == b) {
                return 0;
            }
            return this._compare((Node)a, (Node)b);
        }

        private int _compare(Node a, Node b) {
            Locator aLoc = BufferDomModel.mav$_getLocatorDirectly(BufferDomModel.this, a);
            Locator bLoc = BufferDomModel.mav$_getLocatorDirectly(BufferDomModel.this, b);
            if (aLoc == null) {
                return -1;
            }
            if (bLoc == null) {
                return 1;
            }
            int startDiff = aLoc.getStartOffset() - bLoc.getStartOffset();
            if (startDiff == 0) {
                return aLoc.getEndOffset() - bLoc.getEndOffset();
            }
            return startDiff;
        }

        private NodeComparatorByLocator() {
        }

        NodeComparatorByLocator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class UpdateTimerTask
    extends TimerTask {
        private final Reference _pluginRef;

        public UpdateTimerTask(BufferDomModel bufferDomPlugin) {
            this._pluginRef = bufferDomPlugin.getBufferDomPluginReference();
        }

        public void run() {
            BufferDomModel bufferDomPlugin = (BufferDomModel)this._pluginRef.get();
            if (bufferDomPlugin != null) {
                BufferDomModel.mav$_ensureSynchronizedThreaded(bufferDomPlugin);
            }
        }
    }

    private static class ForceReparseUndoableEditWrapper
    extends UndoableEditWrapper {
        private final UndoableEdit _textEdit;
        private final Reference _pluginRef;

        public ForceReparseUndoableEditWrapper(BufferDomModel plugin, UndoableEdit textEdit) {
            this._textEdit = textEdit;
            this._pluginRef = plugin.getBufferDomPluginReference();
        }

        protected UndoableEdit getBaseEdit() {
            return this._textEdit;
        }

        public void redo() throws CannotRedoException {
            BufferDomModel plugin = (BufferDomModel)this._pluginRef.get();
            if (plugin == null) {
                super.redo();
            } else {
                BufferDomModel.wa$_textSyncInProgress(plugin, true);
                try {
                    super.redo();
                }
                finally {
                    BufferDomModel.wa$_textSyncInProgress(plugin, false);
                }
                BufferDomModel.mav$_ensureSynchronizedImmediate(plugin);
            }
        }

        public void undo() throws CannotUndoException {
            BufferDomModel plugin = (BufferDomModel)this._pluginRef.get();
            if (plugin == null) {
                super.undo();
            } else {
                BufferDomModel.wa$_textSyncInProgress(plugin, true);
                try {
                    super.undo();
                }
                finally {
                    BufferDomModel.wa$_textSyncInProgress(plugin, false);
                }
                BufferDomModel.mav$_ensureSynchronizedImmediate(plugin);
            }
        }
    }

    private static class ParseCancelListener
    implements WriteLockRequestListener {
        private final BufferDomDocumentParser _parser;
        private volatile boolean _isCancelled;

        public ParseCancelListener(BufferDomDocumentParser parser) {
            this.$init$();
            this._parser = parser;
        }

        public void writeRequested(ReadWriteLock lock) {
            this._isCancelled = true;
            this._parser.cancelParse();
        }

        public boolean isCancelled() {
            return this._isCancelled;
        }

        private void $init$() {
            this._isCancelled = false;
        }
    }
}

