/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.logging.Logger;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.BufferDomRelatedChange;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.ref.NodeRef;
import org.w3c.dom.Node;

class MapNodeLocatorChange
extends BufferDomRelatedChange {
    private final NodeRef _nodeRef;
    private final Locator _oldLocator;
    private final Locator _newLocator;
    private static final Logger _LOGGER = Logger.getLogger(MapNodeLocatorChange.class.getName());

    public MapNodeLocatorChange(NodeRef nodeRef, Locator oldLocator, Locator newLocator) {
        this._nodeRef = nodeRef;
        this._oldLocator = oldLocator;
        this._newLocator = newLocator;
    }

    protected void preUndoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (this._oldLocator == null) {
            Node node = TextSyncUtils.getNode(model, this._nodeRef);
            Locator curLocator = plugin.getLocator(node);
            if (curLocator != null) {
                plugin.nodeSubtreeRemoved(node);
            }
            plugin.mapNodeToLocator(node, Locator.getCopy(this._oldLocator));
        }
    }

    protected void postUndoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (this._oldLocator != null) {
            Node node = TextSyncUtils.getNode(model, this._nodeRef);
            Locator curLocator = plugin.getLocator(node);
            if (curLocator != null) {
                plugin.nodeSubtreeRemoved(node);
            }
            plugin.mapNodeToLocator(node, Locator.getCopy(this._oldLocator));
            plugin.nodeSubtreeInserted(node);
        }
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
    }

    protected void preRedoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (this._newLocator == null) {
            Node node = TextSyncUtils.getNode(model, this._nodeRef);
            Locator curLocator = plugin.getLocator(node);
            if (curLocator != null) {
                plugin.nodeSubtreeRemoved(node);
            }
            plugin.mapNodeToLocator(node, Locator.getCopy(this._newLocator));
        }
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
    }

    protected void postRedoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
        if (this._newLocator != null) {
            Node node = TextSyncUtils.getNode(model, this._nodeRef);
            Locator curLocator = plugin.getLocator(node);
            if (curLocator != null) {
                plugin.nodeSubtreeRemoved(node);
            }
            plugin.mapNodeToLocator(node, Locator.getCopy(this._newLocator));
            plugin.nodeSubtreeInserted(node);
        }
        TextSyncUtils.debugRootLocator(model, plugin, _LOGGER);
    }
}

