/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.HashSet;
import java.util.Set;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.ParserConfigurationDecorator;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptions;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptionsDecorator;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class ReformatPCWrapper
extends ParserConfigurationDecorator {
    private final Set _singleQuoteAttributes;
    private final Set _elementsWithEndTags;
    private final TextSyncOptions _tso;

    public ReformatPCWrapper(ParserConfiguration base, BufferDomModel model, Node reformatRoot, Object options) {
        super(base);
        this.$init$();
        this._tso = "rule5".equals(options) ? new Rule5TSO(null) : new ReformatTSO(null);
        this._gatherInformation(model, reformatRoot);
    }

    public TextSyncOptions getTextSyncOptions() {
        return this._tso;
    }

    private void _gatherInformation(BufferDomModel model, Node node) {
        this._findSingleQuoteAttrs(model, node);
        this._checkForNonMinimizedElement(model, node);
        Node child = node.getFirstChild();
        while (child != null) {
            this._gatherInformation(model, child);
            child = child.getNextSibling();
        }
    }

    private void _checkForNonMinimizedElement(BufferDomModel model, Node node) {
        ElementLocator loc;
        if (DomUtils.isElement((Node)node) && (loc = (ElementLocator)model.getLocator(node)).getEndTagLocator() != null) {
            this._elementsWithEndTags.add(node);
        }
    }

    private void _findSingleQuoteAttrs(BufferDomModel model, Node node) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                AttributeLocator attrLoc;
                Node attr = attrs.item(i);
                Locator loc = model.getLocator(attr);
                if (loc instanceof AttributeLocator && (attrLoc = (AttributeLocator)loc).getQuoteStyle() == 0) {
                    this._singleQuoteAttributes.add(attr);
                }
                ++i;
            }
        }
    }

    private void $init$() {
        this._singleQuoteAttributes = new HashSet(27);
        this._elementsWithEndTags = new HashSet(27);
    }

    static Set ra$_elementsWithEndTags(ReformatPCWrapper reformatPCWrapper) {
        return reformatPCWrapper._elementsWithEndTags;
    }

    static Set ra$_singleQuoteAttributes(ReformatPCWrapper reformatPCWrapper) {
        return reformatPCWrapper._singleQuoteAttributes;
    }

    static TextSyncOptions mas$getTextSyncOptions(ReformatPCWrapper reformatPCWrapper) {
        return super.getTextSyncOptions();
    }

    private class ReformatTSO
    extends TextSyncOptionsDecorator {
        protected final TextSyncOptions getBaseTextSyncOptions() {
            return ReformatPCWrapper.mas$getTextSyncOptions(ReformatPCWrapper.this);
        }

        public boolean isDefaultQuoteStyleDouble(Attr attr) {
            if (ReformatPCWrapper.ra$_singleQuoteAttributes(ReformatPCWrapper.this).contains(attr)) {
                return false;
            }
            return super.isDefaultQuoteStyleDouble(attr);
        }

        public boolean useMinimizedForm(Element element) {
            if (ReformatPCWrapper.ra$_elementsWithEndTags(ReformatPCWrapper.this).contains(element)) {
                return false;
            }
            return super.useMinimizedForm(element);
        }

        public boolean prefersWhitespaceInside(Element element) {
            Node firstChild = element.getFirstChild();
            if (DomUtils.isText((Node)firstChild) && firstChild == element.getLastChild()) {
                return false;
            }
            return super.prefersWhitespaceInside(element);
        }

        private ReformatTSO() {
        }

        ReformatTSO(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Rule5TSO
    extends ReformatTSO {
        public TextSyncOptions.AttributeWrapMode getAttributeWrapMode(Element ownerElement) {
            return TextSyncOptions.ATTR_WRAP_ALWAYS_JUST_INDENTED;
        }

        public boolean prefersWhitespaceInside(Element parent) {
            return true;
        }

        public boolean useMinimizedForm(Element element) {
            return false;
        }

        public boolean wrapBeforeEndOfStartTag(Element element) {
            return true;
        }

        public boolean prefersWhitespaceInsideWhenEmpty(Element parent) {
            return true;
        }

        private Rule5TSO() {
            super(null);
        }

        Rule5TSO(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

