/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.BufferDomRelatedChange;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SlashAndCompleteLocatorChange
extends BufferDomRelatedChange {
    private final NodeRef _ref;
    private final SimpleLocator _oldSlashLocator;
    private final SimpleLocator _newSlashLocator;
    private final boolean _oldComplete;
    private final boolean _newComplete;

    public SlashAndCompleteLocatorChange(Element element, SimpleLocator oldSlashLocator, SimpleLocator newSlashLocator, boolean oldComplete, boolean newComplete) {
        this._ref = NodeRefFactory.getNodeRef((Node)element);
        this._oldSlashLocator = oldSlashLocator;
        this._newSlashLocator = newSlashLocator;
        this._oldComplete = oldComplete;
        this._newComplete = newComplete;
    }

    protected void postUndoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        this._setState(model, plugin, this._oldSlashLocator, this._oldComplete);
    }

    protected void postRedoImpl(DomModel model, BufferDomModel plugin, DomChange domChange) {
        this._setState(model, plugin, this._newSlashLocator, this._newComplete);
    }

    private void _setState(DomModel model, BufferDomModel plugin, SimpleLocator slashLoc, boolean complete) {
        Element elem = (Element)this._ref.getCorrespondingNode(model.getDocument());
        ElementLocator elemLoc = (ElementLocator)plugin.getLocator(elem);
        LocatorManager manager = plugin.getLocatorManager();
        if (elemLoc.getSlashLocator() != null) {
            manager.detach(elemLoc.getSlashLocator());
        }
        elemLoc.setStartTagComplete(complete);
        elemLoc.setSlashLocator(slashLoc);
        if (slashLoc != null) {
            manager.attach(slashLoc);
        }
    }
}

