/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.DetachAttachEndTagLocatorsChange;
import oracle.bali.xml.dom.buffer.MapSubtreeLocatorChange;
import oracle.bali.xml.dom.buffer.TextSyncConfiguration;
import oracle.bali.xml.dom.buffer.TextSyncContext;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.AbstractAttrChange;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.share.string.StringChange;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class SyncToTextDomChangeHandler
implements DomChangeHandler {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final TextSyncContext _context;
    private int _curInsertOffset;
    private final StringBuffer _insertBuffer;
    private static final Logger _LOGGER;
    private static final Character _DOUBLE_QUOTE;
    private static final Character _SINGLE_QUOTE;

    public SyncToTextDomChangeHandler(TextSyncContext context) {
        this.$init$();
        this._context = context;
    }

    public void handleAttrAddedChange(AttrAddedChange change) {
        Element owner = this._getOwnerElement(change);
        this._context.requireNonNullAndInDocument(owner, "attribute owner element");
        Attr attr = this._context.getEventAttr();
        this._context.requireNonNullAndInDocument(attr, "added attribute");
        if (!this._allowsAttributes(owner)) {
            this._context.getLogger().log(Level.SEVERE, "Attrs unexpectedly added to {0}, which does not allow attributes. Attr={1}", new Object[]{owner.getNodeName(), attr.getNodeName()});
            this._context.setBufferChangeNoOp();
            return;
        }
        this._addAttr(change, owner, attr);
    }

    public void handleAttrRemovedChange(AttrRemovedChange change) {
        Element owner = this._getOwnerElement(change);
        this._context.requireNonNullAndInDocument(owner, "attribute owner element");
        Attr removedAttr = this._context.getEventAttr();
        this._context.requireNonNullAndInDocument(removedAttr, "removed attribute");
        this._removeAttr(owner, removedAttr, false);
    }

    public void handleAttrValueChange(AttrValueChange change) {
        Attr attr = this._context.getEventAttr();
        this._context.requireNonNullAndInDocument(attr, "attr whose value changed");
        boolean nullValue = this._checkAndWarnNullValuedAttr(attr) ^ true;
        if (nullValue) {
            this._removeAttr(attr.getOwnerElement(), attr, true);
        } else {
            AttributeLocator loc = (AttributeLocator)this._context.getLocatorRequired(attr);
            if (loc.isSpecified()) {
                this._changeAttr(change, attr);
            } else {
                this._addAttr(change, attr.getOwnerElement(), attr);
            }
        }
    }

    public void handleNodeInsertedChange(NodeInsertedChange change) {
        Node node = this._context.getEventTargetNode();
        this._context.requireNonNullAndInDocument(node, "inserted node");
        Node parent = node.getParentNode();
        this._context.requireNonNullAndInDocument(parent, "inserted node's parent");
        short parentType = parent.getNodeType();
        switch (parentType) {
            case 1: {
                this._insertSubtreeIntoElement((Element)parent, node);
                break;
            }
            case 9: {
                this._insertSubtreeIntoDocument((Document)parent, node);
                break;
            }
            default: {
                this._context.logAssertFailure("Parent of inserted node {0} had type {1}! parent={2}", new Object[]{node, String.valueOf(parent.getNodeType()), parent});
                throw new IllegalStateException("messages logged");
            }
        }
    }

    public void handleNodeRemovedChange(NodeRemovedChange change) {
        boolean wasOnlyChild;
        Node removedNode = this._context.getEventTargetNode();
        this._context.requireNonNullAndInDocument(removedNode, "removed node");
        NodeRef removedNodeRef = NodeRefFactory.getNodeRef((Node)removedNode);
        Node parent = removedNode.getParentNode();
        this._context.requireNonNullAndInDocument(parent, "parent of removed node");
        boolean bl = wasOnlyChild = parent.getFirstChild() == removedNode && parent.getLastChild() == removedNode;
        if (wasOnlyChild && parent.getNodeType() == 1 && this._usesMinimizedForm((Element)parent)) {
            this._removeSubtreeCollapsingElement((Element)parent, removedNode, removedNodeRef);
        } else {
            this._removeSubtree(removedNode, removedNodeRef);
        }
    }

    public void handleNodeValueChange(NodeValueChange change) {
        Node node = change.getNodeRef().getCorrespondingNode(this._context.getDocument());
        this._context.requireNonNullAndInDocument(node, "node whose value changed");
        String oldValue = change.getPrevValue();
        String newValue = change.getNewValue();
        if (newValue.equals(oldValue)) {
            this._context.setBufferChangeNoOp();
        } else {
            Locator locator = this._context.getLocatorRequired(node);
            if (locator instanceof SimpleLocator) {
                this._changeSimpleNodeValue(node, newValue, (SimpleLocator)locator);
            } else if (locator instanceof TextLocator) {
                this._changeTextNodeValue((Text)node, (TextLocator)locator, change.getStringChange(), oldValue, newValue);
            } else {
                throw new IllegalStateException("invalid locator type: " + locator);
            }
        }
    }

    private void _addAttr(AbstractAttrChange change, Element owner, Attr attr) {
        ElementLocator ownerLocator = this._context.getElementLocatorRequired(owner);
        this._context.checkElementLocatorParts(ownerLocator, owner, true, true, false);
        SimpleLocator startTagLocator = ownerLocator.getStartTagLocator();
        SimpleLocator slashLoc = ownerLocator.getSlashLocator();
        int endOfStartTag = slashLoc != null ? ((Locator)slashLoc).getStartOffset() : (ownerLocator.isStartTagComplete() ? ((Locator)startTagLocator).getEndOffset() - this._config().getStartTagEnd(owner).length() : ((Locator)startTagLocator).getEndOffset());
        if (!this._checkAndWarnNullValuedAttr(attr) || this._context.getPlugin().__isInSetUnspecifiedAttribute()) {
            AttributeLocator loc = this._context.createZeroLengthAttrLocator(endOfStartTag);
            this._context.mapNodeToLocator((Node)attr, loc, null);
            this._context.setBufferChangeNoOp();
            return;
        }
        Locator prevLocator = this._context.getLastAttributeOrNameLocator(owner, ownerLocator, true);
        boolean needsWhitespace = prevLocator.getEndOffset() == endOfStartTag;
        Locator oldAttrLocatorCopy = Locator.getCopy(this._context.getLocator(attr));
        String whitespace = "";
        if (needsWhitespace) {
            whitespace = " ";
        }
        int attrInsertOffset = endOfStartTag;
        this._context.noteCharactersAdded(attrInsertOffset, whitespace.length());
        MapSubtreeLocatorChange lc = new MapSubtreeLocatorChange(attr, true);
        change.addRelatedChange(lc);
        String text = this._createAttrTextAndLocator(lc, attr, attrInsertOffset + whitespace.length(), oldAttrLocatorCopy);
        lc.doneAddingNodes();
        this._context.getPlugin().nodeSubtreeInserted(attr);
        this._context.setBufferChangeInsert(attrInsertOffset, whitespace + text);
    }

    private void _removeAttr(Element owner, Attr attr, boolean shouldLeaveZeroLengthLocator) {
        AttributeLocator newLocator;
        Locator locator = this._context.getLocatorRequired(attr);
        int start = locator.getStartOffset();
        int length = locator.getLength();
        SortedSet sortedAttrs = this._context.getPlugin().getSortedAttributesSet(owner);
        SortedSet<Attr> earlierAttrs = sortedAttrs.headSet(attr);
        Locator precedingLocator = earlierAttrs.isEmpty() ? this._context.getElementLocatorRequired(owner).getNameLocator() : this._context.getLocatorRequired(earlierAttrs.last());
        int precedingEnd = precedingLocator.getEndOffset();
        int whitespaceBeforeRemovedAttr = start - precedingEnd;
        this._context.getPlugin().nodeSubtreeRemoved(attr);
        if (shouldLeaveZeroLengthLocator) {
            newLocator = this._context.createZeroLengthAttrLocator(precedingEnd);
            this._context.attachLocator(newLocator);
        } else {
            newLocator = null;
        }
        this._context.mapAttrToLocator(owner, attr, newLocator);
        if (whitespaceBeforeRemovedAttr > 0) {
            start = precedingEnd;
            length += whitespaceBeforeRemovedAttr;
            this._context.noteCharactersRemoved(precedingEnd, whitespaceBeforeRemovedAttr);
        }
        if (length > 0) {
            this._context.setBufferChangeRemoval(start, length);
        } else {
            this._context.setBufferChangeNoOp();
        }
    }

    private void _changeAttr(AttrValueChange change, Attr attr) {
        int insertionStart;
        int oldValueLength;
        StringBuffer buf = new StringBuffer();
        AttributeLocator attrLocator = (AttributeLocator)this._context.getLocatorRequired(attr);
        short newQuoteStyle = this._getDefaultQuoteStyle(attr);
        SimpleLocator newEqualsLocator = null;
        TextLocator oldValueLocator = attrLocator.getValueLocator();
        if (oldValueLocator == null) {
            oldValueLength = 0;
            insertionStart = attrLocator.getEndOffset();
            SimpleLocator oldEqualsLocator = attrLocator.getEqualsLocator();
            if (oldEqualsLocator == null) {
                buf.append('=');
                newEqualsLocator = this._context.createSimpleLocator(attrLocator.getEndOffset(), 1);
            }
        } else {
            insertionStart = ((Locator)oldValueLocator).getStartOffset();
            oldValueLength = oldValueLocator.getLength();
            short oldStyle = attrLocator.getQuoteStyle();
            if (oldStyle != 2) {
                newQuoteStyle = oldStyle;
            }
            this._context.detachLocator(oldValueLocator);
        }
        TextLocator newValueLoc = this._createTextAndTextLocator(buf, attr, change.getNewValue(), newQuoteStyle, insertionStart + buf.length());
        String text = buf.toString();
        this._context.getPlugin().nodeSubtreeRemoved(attr);
        Locator oldLocator = attrLocator.getCopy();
        attrLocator.setValueLocator(newValueLoc);
        if (newEqualsLocator != null) {
            attrLocator.setEqualsLocator(newEqualsLocator);
        }
        this._context.mapNodeToLocator(attr, NodeRefFactory.getNodeRef((Node)attr), attrLocator, oldLocator);
        this._context.getPlugin().nodeSubtreeInserted(attr);
        this._context.setBufferChangeReplace(insertionStart, oldValueLength, text);
    }

    private void _insertSubtreeIntoElement(Element parent, Node node) {
        ElementLocator parentLocator = this._context.getElementLocatorRequired(parent);
        this._context.checkElementLocatorParts(parentLocator, parent, true, true, false);
        if (parentLocator.getEndTagLocator() == null) {
            this._insertSubtreeIntoEmptyElement(parent, parentLocator, node);
        } else {
            this._insertSubtreeIntoNonEmptyElement(parent, node);
        }
    }

    static {
        $assertionsDisabled = SyncToTextDomChangeHandler.class.desiredAssertionStatus() ^ true;
        _LOGGER = Logger.getLogger(SyncToTextDomChangeHandler.class.getName());
        _DOUBLE_QUOTE = new Character('\"');
        _SINGLE_QUOTE = new Character('\'');
    }

    private void _insertSubtreeIntoEmptyElement(Element parent, ElementLocator parentLocator, Node node) {
        int startOffset;
        if (!($assertionsDisabled || node == parent.getFirstChild() && node == parent.getLastChild())) {
            throw new AssertionError();
        }
        Locator savedParentLocator = parentLocator.getCopy();
        SimpleLocator startTagLocator = parentLocator.getStartTagLocator();
        String newParentEndTag = this._isFakeElementLocator(parentLocator) ? "" : this._config().getEndTag(parent);
        if (!$assertionsDisabled && newParentEndTag == null) {
            throw new AssertionError();
        }
        SimpleLocator slashLoc = parentLocator.getSlashLocator();
        if (slashLoc == null) {
            int accountForGT = parentLocator.isStartTagComplete() && !this._isFakeElementLocator(parentLocator) ? this._config().getStartTagEnd(parent).length() : 0;
            startOffset = ((Locator)startTagLocator).getEndOffset() - accountForGT;
        } else {
            this._context.noteCharactersRemoved(((Locator)slashLoc).getStartOffset(), slashLoc.getLength());
            startOffset = ((Locator)slashLoc).getStartOffset();
            this._curInsertOffset = startOffset + slashLoc.getLength();
        }
        this._insertHelper(startOffset, node);
        int parentIndent = this._getIndentationSize(DomPositionFactory.inside((Node)parent));
        this._addWhitespaceAndUpdateLocators(parentIndent);
        SimpleLocator newParentEndLocator = this._context.createSimpleLocator(this._curInsertOffset, newParentEndTag.length());
        this._context.setSlashAndComplete(parent, ((ElementLocator)savedParentLocator).getSlashLocator(), null, true);
        this._context.addEndTagLocator(parent, newParentEndLocator);
        this._insertBuffer.append(newParentEndTag);
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Changed parent locator from {0} to {1}", new Object[]{savedParentLocator, parentLocator});
        }
        this._context.setBufferChangeReplace(startOffset, 2, ">" + this._insertBuffer.toString());
    }

    private void _insertSubtreeIntoNonEmptyElement(Element parent, Node node) {
        LinkedList<NodeRef> noderefsToDetachAttach = null;
        Node walk = node.getPreviousSibling();
        while (DomUtils.isElement((Node)walk)) {
            ElementLocator loc = this._context.getElementLocatorRequired((Element)walk);
            SimpleLocator endTag = loc.getEndTagLocator();
            if (endTag != null && endTag.getLength() == 0) {
                if (noderefsToDetachAttach == null) {
                    noderefsToDetachAttach = new LinkedList<NodeRef>();
                }
                noderefsToDetachAttach.add(NodeRefFactory.getNodeRef((Node)walk));
            }
            walk = walk.getLastChild();
        }
        DetachAttachEndTagLocatorsChange detachAttachEndTags = null;
        if (noderefsToDetachAttach != null) {
            detachAttachEndTags = new DetachAttachEndTagLocatorsChange(noderefsToDetachAttach);
            detachAttachEndTags.apply(this._context.getDocument(), this._context.getPlugin(), false);
        }
        Locator before = this._getPreceedingLocator(node, parent);
        Locator after = this._getSucceedingLocator(node, parent);
        if (!$assertionsDisabled && before == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && after == null) {
            throw new AssertionError();
        }
        int startOffset = before.getEndOffset();
        int removeChars = after.getStartOffset() - startOffset;
        if (removeChars < 0) {
            _LOGGER.log(Level.WARNING, "Negative whitespace to remove before insertion! parent={0} inserted={1} preceedingLocator={2} succeedingLocator={3} model={4}", new Object[]{parent, node, before, after, this._context.getPlugin()});
            removeChars = 0;
        }
        this._context.noteCharactersRemoved(startOffset, removeChars);
        this._curInsertOffset = startOffset;
        boolean addedWS = this._insertHelper(startOffset, node);
        if (addedWS && this._spaceOnEnd(node.getPreviousSibling(), false)) {
            --startOffset;
            ++removeChars;
            this._insertBuffer.insert(0, " ");
        }
        DomPosition postPos = parent.getLastChild() == node ? DomPositionFactory.inside((Node)parent) : DomPositionFactory.after((Node)node);
        int postIndent = this._getIndentationSize(postPos);
        this._addWhitespaceAndUpdateLocators(postIndent);
        if (detachAttachEndTags != null) {
            detachAttachEndTags.apply(this._context.getDocument(), this._context.getPlugin(), true);
            this._context.addRelatedChange(detachAttachEndTags);
        }
        this._context.setBufferChangeReplace(startOffset, removeChars, this._insertBuffer.toString());
    }

    private void _insertSubtreeIntoDocument(Document parent, Node node) {
        DeclarationLocator xmlDeclLocator;
        Node firstChild = parent.getFirstChild();
        int startOffset = node == firstChild ? ((xmlDeclLocator = this._context.getPlugin().getXMLDeclarationLocator()) != null ? ((Locator)xmlDeclLocator).getEndOffset() : 0) : this._getStartOffsetAfterPreviousSibling(node);
        this._curInsertOffset = startOffset;
        this._insertHelper(startOffset, node);
        if (startOffset == 0) {
            int crOffset = startOffset + this._insertBuffer.length();
            this._context.noteCharactersAdded(crOffset, 1);
            this._insertBuffer.append('\n');
        }
        this._context.setBufferChangeInsert(startOffset, this._insertBuffer.toString());
    }

    private boolean _insertHelper(int startOffset, Node node) {
        int whitespaceSize;
        boolean ret = false;
        if (startOffset != 0 && (whitespaceSize = this._getIndentationSize(DomPositionFactory.before((Node)node))) >= 0) {
            ret = true;
            this._addWhitespaceAndUpdateLocators(whitespaceSize);
        }
        MapSubtreeLocatorChange lc = new MapSubtreeLocatorChange(node, true);
        this._createTextAndLocatorForSubtree(lc, node, true);
        this._context.addRelatedChange(lc);
        this._context.getPlugin().nodeSubtreeInserted(node);
        lc.doneAddingNodes();
        return ret;
    }

    private int _getStartOffsetAfterPreviousSibling(Node node) {
        Node priorSibling = node.getPreviousSibling();
        this._context.requireNonNullAndInDocument(priorSibling, "previous sibling of inserted node");
        int startOffset = this._context.getLocatorRequired(priorSibling).getEndOffset();
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Putting new node {0} after sibling {1}, which had end offset {2}", new Object[]{node, priorSibling, new Integer(startOffset)});
        }
        return startOffset;
    }

    private void _removeSubtreeCollapsingElement(Element parentElem, Node removedNode, NodeRef removedNodeRef) {
        ElementLocator parentLoc = this._context.getElementLocatorRequired(parentElem);
        this._context.checkElementLocatorParts(parentLoc, parentElem, true, true, true);
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "Collapsing parent {0}: before={1}", new Object[]{parentElem, parentLoc});
            TextSyncUtils.debugRootLocator(this._context.getDocument(), this._context.getPlugin(), _LOGGER);
        }
        SimpleLocator parentEndLoc = parentLoc.getEndTagLocator();
        boolean wasStartTagComplete = parentLoc.isStartTagComplete();
        int start = parentLoc.getStartTagLocator().getEndOffset();
        if (wasStartTagComplete) {
            --start;
        }
        int end = parentEndLoc.getEndOffset();
        this._context.getPlugin().nodeSubtreeRemoved(removedNode);
        TextSyncUtils.debugRootLocator(this._context.getDocument(), this._context.getPlugin(), _LOGGER);
        MapSubtreeLocatorChange lc = new MapSubtreeLocatorChange(removedNodeRef, false);
        this._context.unmapSubtreeLocators(removedNode, removedNodeRef, lc);
        this._context.addRelatedChange(lc);
        int startTagEnd = parentLoc.getStartTagLocator().getEndOffset();
        int trappedWhitespace = parentEndLoc.getStartOffset() - startTagEnd;
        if (trappedWhitespace > 0) {
            this._context.noteCharactersRemoved(startTagEnd, trappedWhitespace);
        }
        if (wasStartTagComplete) {
            this._context.noteCharactersAdded(start, 1);
        } else {
            this._context.noteCharactersAdded(start - 1, 2);
        }
        this._context.removeEndTagLocator(parentElem);
        TextSyncUtils.debugRootLocator(this._context.getDocument(), this._context.getPlugin(), _LOGGER);
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Collapsing parent {0}: after={1}", new Object[]{parentElem, parentLoc});
        }
        this._context.setSlashAndComplete(parentElem, parentLoc.getSlashLocator(), this._context.createSimpleLocator(start, 1), true);
        TextSyncUtils.debugRootLocator(this._context.getDocument(), this._context.getPlugin(), _LOGGER);
        this._context.setBufferChangeReplace(start, end - start, "/>");
    }

    private void _removeSubtree(Node node, NodeRef ref) {
        Locator locator = this._context.getLocator(node);
        Node parent = node.getParentNode();
        int preceedingWhitespaceSize = 0;
        Locator preceedingLocator = this._getPreceedingLocator(node, parent);
        if (preceedingLocator != null) {
            int preceedingEnd = preceedingLocator.getEndOffset();
            int removedStart = locator.getStartOffset();
            preceedingWhitespaceSize = removedStart - preceedingEnd;
        }
        int start = locator.getStartOffset();
        int length = locator.getEndOffset() - start;
        this._context.getPlugin().nodeSubtreeRemoved(node);
        MapSubtreeLocatorChange lc = new MapSubtreeLocatorChange(ref, false);
        this._context.unmapSubtreeLocators(node, ref, lc);
        this._context.addRelatedChange(lc);
        if (preceedingWhitespaceSize < 0) {
            this._context.logAssertFailure("Negative preceeding whitespace {0} when removing {1} at {2}", new Object[]{new Integer(preceedingWhitespaceSize), node, ref});
        } else if (preceedingWhitespaceSize > 0) {
            length += preceedingWhitespaceSize;
            this._context.noteCharactersRemoved(start -= preceedingWhitespaceSize, preceedingWhitespaceSize);
        }
        this._context.setBufferChangeRemoval(start, length);
    }

    private Locator _getPreceedingLocator(Node node, Node parent) {
        Node previousSibling = node.getPreviousSibling();
        if (previousSibling != null) {
            return this._context.getLocator(previousSibling);
        }
        if (parent == null) {
            return null;
        }
        switch (parent.getNodeType()) {
            case 9: {
                return this._context.getPlugin().getXMLDeclarationLocator();
            }
            case 1: {
                return this._context.getElementLocator(parent).getStartTagLocator();
            }
        }
        return this._context.getLocator(parent);
    }

    private Locator _getSucceedingLocator(Node node, Node parent) {
        Node nextSibling = node.getNextSibling();
        if (nextSibling != null) {
            return this._context.getLocator(nextSibling);
        }
        if (parent == null) {
            return null;
        }
        switch (parent.getNodeType()) {
            case 9: {
                return null;
            }
            case 1: {
                return this._context.getElementLocator(parent).getEndTagLocator();
            }
        }
        return null;
    }

    private void _changeSimpleNodeValue(Node node, String newValue, SimpleLocator locator) {
        int start = locator.getStartOffset();
        int oldLength = locator.getLength();
        if (!$assertionsDisabled && node.getNodeType() == 3) {
            throw new AssertionError();
        }
        String nodeText = this._getNodeText(node, newValue);
        this._context.changeLocatorLength(node, locator, nodeText.length());
        this._context.setBufferChangeReplace(start, oldLength, nodeText);
    }

    private void _changeTextNodeValue(Text node, TextLocator oldLocator, StringChange change, String oldValue, String newValue) {
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "TextChange: |{0}| to |{1}|; change={2}", new Object[]{oldValue, newValue, change});
        }
        if (change.getRemovalCount() < oldValue.length()) {
            try {
                this._doSubTextNodeUpdate(node, oldLocator, change);
                return;
            }
            catch (BreakOut bo) {
                LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"Error doing sub-node update of text node from {0} to {1}", (Object[])new Object[]{oldValue, newValue}, (Throwable)bo);
            }
        }
        this._doEntireTextNoteReplacement(node, oldLocator, newValue);
    }

    private void _doSubTextNodeUpdate(Node node, TextLocator oldLocator, StringChange change) throws BreakOut {
        String insertedText;
        int[] splitOffsets;
        int bufferRemovalLength;
        int start = oldLocator.getContentTextOffset(change.getOffset());
        if (change.getRemovalCount() > 0) {
            int endOldIdx = change.getOffset() + change.getRemovalCount();
            int end = oldLocator.getContentTextOffset(endOldIdx);
            bufferRemovalLength = end - start;
            splitOffsets = new int[]{start, end};
        } else {
            bufferRemovalLength = 0;
            splitOffsets = new int[]{start};
        }
        List newContentLocs = TextLocator.copyLocatorList(oldLocator.getContentLocators());
        List newWSLocs = TextLocator.copyLocatorList(oldLocator.getWhitespaceLocators());
        boolean ok = TextSyncUtils.splitLocatorList(newContentLocs, splitOffsets);
        if (!ok) {
            throw new BreakOut(null);
        }
        ok = TextSyncUtils.updateWhitespaceLocatorsForRemoval(newWSLocs, start, bufferRemovalLength);
        if (!ok) {
            throw new BreakOut(null);
        }
        if (bufferRemovalLength > 0) {
            int removalEnd = start + bufferRemovalLength;
            Iterator deletionItor = newContentLocs.iterator();
            while (deletionItor.hasNext()) {
                SimpleLocator loc = (SimpleLocator)deletionItor.next();
                int locStart = loc.getStartOffset();
                if (locStart >= start && locStart < removalEnd) {
                    deletionItor.remove();
                    continue;
                }
                if (locStart < removalEnd) continue;
                loc.move(-bufferRemovalLength);
            }
        }
        if (change.getInsertedChars() != null) {
            String domInsertedChars = change.getInsertedChars();
            StringBuffer insertedTextBuf = new StringBuffer();
            List insertionLocs = this._createTextAndContentLocators(insertedTextBuf, node, domInsertedChars, (short)-1, start);
            int insertionBufferSize = insertedTextBuf.length();
            ListIterator contentItor = newContentLocs.listIterator();
            boolean hasAddedLocatorsYet = false;
            while (contentItor.hasNext()) {
                SimpleLocator loc = (SimpleLocator)contentItor.next();
                if (loc.getStartOffset() < start) continue;
                if (!hasAddedLocatorsYet) {
                    contentItor.previous();
                    this._addAll(contentItor, insertionLocs);
                    hasAddedLocatorsYet = true;
                    contentItor.next();
                }
                loc.move(insertionBufferSize);
            }
            if (!hasAddedLocatorsYet) {
                newContentLocs.addAll(insertionLocs);
                hasAddedLocatorsYet = true;
            }
            TextSyncUtils.adjustLocatorsForAddition(newWSLocs, start, insertionBufferSize);
            insertedText = insertedTextBuf.toString();
        } else {
            insertedText = "";
        }
        TextSyncUtils.minimizeNumberOfLocators(newContentLocs);
        TextLocator newLocator = this._context.createTextLocator(newContentLocs, newWSLocs);
        this._context.getPlugin().nodeSubtreeRemoved(node);
        this._context.mapNodeToLocator(node, newLocator, (Locator)oldLocator);
        this._context.getPlugin().nodeSubtreeInserted(node);
        this._context.setBufferChangeReplace(start, bufferRemovalLength, insertedText);
    }

    private String _checkAndWarnNullValuedText(Text text) {
        String textString = text.getData();
        if (textString == null) {
            LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"A Text node was set to a null value. The DOM specification is unclear on this, but it makes no sense set the value of a Text node to null. Removing the Text node or setting it to an empty string are both valid options.  The Text node will be treated as having empty string as a value . owning element={0}", (Object[])new Object[]{text.getParentNode()}, (Throwable)new Throwable("stack trace -- caller set value of Text node to null"));
            textString = "";
        }
        return textString;
    }

    private boolean _checkAndWarnNullValuedAttr(Attr attr) {
        boolean ok;
        boolean bl = ok = attr.getValue() != null;
        if (!ok) {
            LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"An Attr was set to a null value. The DOM specification is unclear on this, but it makes no sense to set an attr to null value. Removing the attr or setting it to \"\" are both valid options. Attr will be treated as unset. attr={0} owning element={1}", (Object[])new Object[]{attr.getNodeName(), attr.getOwnerElement().getNodeName()}, (Throwable)new Throwable("stack trace -- caller set attr to null value"));
        }
        return ok;
    }

    private void _addAll(ListIterator out, Collection in) {
        Iterator inItor = in.iterator();
        while (inItor.hasNext()) {
            out.add(inItor.next());
        }
    }

    private void _doEntireTextNoteReplacement(Node node, TextLocator oldLocator, String newValue) {
        int start = oldLocator.getStartOffset();
        int oldLength = oldLocator.getLength();
        this._context.getPlugin().nodeSubtreeRemoved(node);
        StringBuffer buf = new StringBuffer();
        TextLocator newLocator = this._createTextAndTextLocator(buf, node, newValue, (short)-1, start);
        this._context.mapNodeToLocator(node, newLocator, (Locator)oldLocator);
        this._context.getPlugin().nodeSubtreeInserted(node);
        this._context.setBufferChangeReplace(start, oldLength, buf.toString());
    }

    private boolean _usesMinimizedForm(Element element) {
        return this._context.getConfig().allowsMinimizedForm(element) && this._context.getOptions().useMinimizedForm(element);
    }

    private TextSyncConfiguration _config() {
        return this._context.getConfig();
    }

    private String _getNodeText(Node node) {
        return this._getNodeText(node, node.getNodeValue());
    }

    private String _getNodeText(Node node, String value) {
        short type = node.getNodeType();
        switch (type) {
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                return "<?" + pi.getTarget() + " " + value + "?>";
            }
            case 4: {
                return "<![CDATA[" + value + "]]>";
            }
            case 8: {
                Comment comment = (Comment)node;
                return this._config().getCommentStart(comment) + value + this._config().getCommentEnd(comment);
            }
        }
        throw new IllegalStateException("Don't know how to get value for type " + type + "; val=" + value);
    }

    private Element _getOwnerElement(AbstractAttrChange change) {
        return change.getOwnerElement(this._context.getDocument());
    }

    private void _createTextAndLocatorForSubtree(MapSubtreeLocatorChange lc, Node node, boolean isInsertionRoot) {
        short nodeType = node.getNodeType();
        if (!isInsertionRoot && nodeType != 2) {
            int whitespaceSize = this._getIndentationSize(DomPositionFactory.before((Node)node));
            this._addIndentationWhitespace(whitespaceSize);
        }
        switch (nodeType) {
            case 2: {
                String attrText = this._createAttrTextAndLocator(lc, (Attr)node, this._curInsertOffset, null);
                this._insertBuffer.append(attrText);
                this._curInsertOffset += attrText.length();
                break;
            }
            case 3: {
                Text text = (Text)node;
                TextLocator textLoc = this._createTextAndTextLocator(this._insertBuffer, text, this._checkAndWarnNullValuedText(text), (short)-1, this._curInsertOffset);
                this._context.getPlugin().mapNodeToLocator(text, textLoc);
                lc.addNode(text, null, Locator.getCopy(textLoc));
                this._curInsertOffset += textLoc.getLength();
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                String nodeText = this._getNodeText(node);
                this._insertBuffer.append(nodeText);
                SimpleLocator locator = this._context.createSimpleLocator(this._curInsertOffset, nodeText.length());
                this._context.getPlugin().mapNodeToLocator(node, locator);
                lc.addNode(node, null, Locator.getCopy(locator));
                this._curInsertOffset += nodeText.length();
                break;
            }
            case 1: {
                this._createElementTextAndLocator(lc, (Element)node);
                break;
            }
            default: {
                throw new IllegalStateException("Don't know how to make text for node type " + node.getNodeType());
            }
        }
    }

    private TextLocator _createTextAndTextLocator(StringBuffer out, Node node, String nodeValue, short quoteStyleForAttr, int startOffset) {
        List contentLocators = this._createTextAndContentLocators(out, node, nodeValue, quoteStyleForAttr, startOffset);
        return this._context.createTextLocator(contentLocators);
    }

    private List _createTextAndContentLocators(StringBuffer out, Node node, String nodeValue, short quoteStyleForAttr, int startOffset) {
        if (nodeValue.indexOf(13) >= 0) {
            StringBuffer dbg = new StringBuffer(5 * nodeValue.length());
            int i = 0;
            while (i < nodeValue.length()) {
                if (i != 0) {
                    dbg.append(" ");
                }
                dbg.append(Integer.toHexString(nodeValue.charAt(i)));
                ++i;
            }
            LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"\\r characters found in text! This is not a good idea, since they stripped by the TextBuffer. Caller should be fixed to not insert the \\r's. Treating \\r as a space to continue.\nnode={0} nodeValue={1} nodeValue chars in hex={2}", (Object[])new Object[]{node, nodeValue, dbg}, (Throwable)new Throwable("stack trace"));
            nodeValue = nodeValue.replaceAll("\r", " ");
        }
        LinkedList<SimpleLocator> contentLocators = new LinkedList<SimpleLocator>();
        Character quoteChar = SyncToTextDomChangeHandler._getQuoteChar(quoteStyleForAttr);
        if (quoteChar == null && quoteStyleForAttr != -1) {
            throw new IllegalStateException("invalid quote style: " + quoteStyleForAttr);
        }
        int currentRunStart = startOffset;
        int currentRunLength = 0;
        if (quoteChar != null) {
            out.append(quoteChar);
            ++currentRunLength;
        }
        int i = 0;
        while (i < nodeValue.length()) {
            String entFromConfig;
            char c = nodeValue.charAt(i);
            String entityIfNeeded = quoteChar != null && c == quoteChar.charValue() ? ((entFromConfig = this._config().getEntityToOutput(node, c)) != null ? entFromConfig : (c == '\"' ? "&quot;" : "&apos;")) : this._config().getEntityToOutput(node, c);
            if (entityIfNeeded == null) {
                out.append(c);
                ++currentRunLength;
            } else {
                out.append(entityIfNeeded);
                if (currentRunLength > 0) {
                    SimpleLocator prevRunLoc = this._context.createSimpleLocator(currentRunStart, currentRunLength);
                    contentLocators.add(prevRunLoc);
                    currentRunStart += currentRunLength;
                    currentRunLength = 0;
                }
                int entityEnd = currentRunStart + entityIfNeeded.length();
                EntityRefLocator erl = this._context.createEntityRefLocator(currentRunStart, entityEnd, entityIfNeeded, String.valueOf(c));
                contentLocators.add(erl);
                currentRunStart = entityEnd;
            }
            ++i;
        }
        if (quoteChar != null) {
            out.append(quoteChar);
            ++currentRunLength;
        }
        if (currentRunLength > 0 || contentLocators.isEmpty()) {
            SimpleLocator lastRunLoc = this._context.createSimpleLocator(currentRunStart, currentRunLength);
            contentLocators.add(lastRunLoc);
        }
        return contentLocators;
    }

    private static Character _getQuoteChar(short quoteStyle) {
        switch (quoteStyle) {
            case 1: {
                return _DOUBLE_QUOTE;
            }
            case 0: {
                return _SINGLE_QUOTE;
            }
        }
        return null;
    }

    private void _createElementTextAndLocator(MapSubtreeLocatorChange lc, Element element) {
        SimpleLocator startTagLocator;
        SimpleLocator slashLocator;
        SimpleLocator endTagLocator;
        Node child;
        boolean hasAnyChildren;
        int startTagStart = this._curInsertOffset;
        String preNameText = this._config().getStartTagBeginning(element);
        this._insertBuffer.append(preNameText);
        this._curInsertOffset += preNameText.length();
        String nameText = this._config().getStartTagName(element);
        this._insertBuffer.append(nameText);
        SimpleLocator nameLocator = this._context.createSimpleLocator(this._curInsertOffset, nameText.length());
        this._curInsertOffset += nameText.length();
        NamedNodeMap attrs = element.getAttributes();
        if (this._allowsAttributes(element)) {
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    Attr attr = (Attr)attrs.item(i);
                    boolean attrOK = this._checkAndWarnNullValuedAttr(attr);
                    if (attrOK) {
                        this._insertBuffer.append(" ");
                        ++this._curInsertOffset;
                        this._createTextAndLocatorForSubtree(lc, attrs.item(i), false);
                    } else {
                        AttributeLocator zeroLoc = this._context.createZeroLengthAttrLocator(this._curInsertOffset);
                        this._context.getPlugin().mapNodeToLocator(attr, zeroLoc);
                        lc.addNode(attr, null, Locator.getCopy(zeroLoc));
                    }
                    ++i;
                }
            }
        } else if (attrs != null && attrs.getLength() > 0) {
            this._context.getLogger().log(Level.SEVERE, "Attrs unexpectedly found on {0}, which does not allow attributes. Ignoring.", element.getNodeName());
        }
        boolean bl = hasAnyChildren = (child = element.getFirstChild()) != null;
        if (!hasAnyChildren && this._usesMinimizedForm(element)) {
            endTagLocator = null;
            String end = "/>";
            int slashStart = this._curInsertOffset;
            slashLocator = this._context.createSimpleLocator(slashStart, 1);
            this._insertBuffer.append(end);
            this._curInsertOffset += end.length();
            startTagLocator = this._context.createSimpleLocator(startTagStart, this._curInsertOffset - startTagStart);
        } else {
            String closeStart = this._config().getStartTagEnd(element);
            this._insertBuffer.append(closeStart);
            this._curInsertOffset += closeStart.length();
            slashLocator = null;
            startTagLocator = this._context.createSimpleLocator(startTagStart, this._curInsertOffset - startTagStart);
            while (child != null) {
                this._createTextAndLocatorForSubtree(lc, child, false);
                child = child.getNextSibling();
            }
            if (hasAnyChildren || this._context.getOptions().prefersWhitespaceInsideWhenEmpty(element)) {
                int whitespaceSize = this._getIndentationSize(DomPositionFactory.inside((Node)element));
                this._addIndentationWhitespace(whitespaceSize);
            }
            String endTagText = this._config().getEndTag(element);
            int endTagLength = endTagText.length();
            this._insertBuffer.append(endTagText);
            endTagLocator = this._context.createSimpleLocator(this._curInsertOffset, endTagLength);
            this._curInsertOffset += endTagLength;
        }
        ElementLocator loc = this._context.createElementLocator(startTagLocator, nameLocator, endTagLocator, slashLocator);
        this._context.getPlugin().mapNodeToLocator(element, loc);
        lc.addNode(element, null, Locator.getCopy(loc));
    }

    private String _createAttrTextAndLocator(MapSubtreeLocatorChange lc, Attr attr, int attrInsertOffset, Locator oldLocatorCopy) {
        short quoteStyle;
        String qnameToOutput;
        StringBuffer text = new StringBuffer();
        String attrValue = attr.getValue();
        if (this._config().omitAttributeName(attr)) {
            qnameToOutput = "";
            quoteStyle = -1;
        } else {
            qnameToOutput = attr.getNodeName();
            quoteStyle = this._changeQuoteStyleForValue(this._getDefaultQuoteStyle(attr), attrValue);
        }
        int nameStart = attrInsertOffset;
        if (qnameToOutput.length() > 0) {
            text.append(qnameToOutput);
            text.append("=");
        }
        TextLocator valueLoc = this._createTextAndTextLocator(text, attr, attrValue, quoteStyle, attrInsertOffset + text.length());
        short quoteStyleForLocator = quoteStyle == -1 ? (short)2 : quoteStyle;
        AttributeLocator locator = this._context.createAttributeLocator(nameStart, qnameToOutput.length(), valueLoc, quoteStyleForLocator);
        this._context.getPlugin().mapNodeToLocator(attr, locator);
        lc.addNode(attr, oldLocatorCopy, Locator.getCopy(locator));
        return text.toString();
    }

    private short _getDefaultQuoteStyle(Attr attr) {
        if (this._context.getOptions().isDefaultQuoteStyleDouble(attr)) {
            return 1;
        }
        return 0;
    }

    private short _changeQuoteStyleForValue(short origStyle, String attrValue) {
        if (this._containsQuoteChar(origStyle, attrValue)) {
            short oppositeStyle;
            short s = oppositeStyle = origStyle == 1 ? (short)0 : 1;
            if (!this._containsQuoteChar(oppositeStyle, attrValue)) {
                return oppositeStyle;
            }
        }
        return origStyle;
    }

    private boolean _containsQuoteChar(short quoteStyle, String attrValue) {
        char quoteChar = SyncToTextDomChangeHandler._getQuoteChar(quoteStyle).charValue();
        return attrValue.indexOf(quoteChar) != -1;
    }

    private boolean _allowsExtraWhitespace(DomPosition pos) {
        Node container = pos.getContainerNode();
        Element containerElem = DomUtils.asElement((Node)container);
        if (containerElem == null) {
            return true;
        }
        if (!this._context.getOptions().prefersWhitespaceInside(containerElem)) {
            return false;
        }
        WhitespaceMode mode = this._context.getElementContentWhitespaceMode((Element)container);
        Boolean ok = mode.allowsAddingExtraWhitespace(pos);
        if (ok == null) {
            return this._hasSpaceAlready(pos);
        }
        return ok;
    }

    private boolean _hasSpaceAlready(DomPosition pos) {
        Node target = pos.getTargetNode();
        if (pos.isBefore()) {
            if (this._spaceOnEnd(target, true)) {
                return true;
            }
            if (this._spaceOnEnd(target.getPreviousSibling(), false)) {
                return true;
            }
        } else if (pos.isAfter()) {
            if (this._spaceOnEnd(target, false)) {
                return true;
            }
            if (this._spaceOnEnd(target.getNextSibling(), true)) {
                return true;
            }
        }
        return false;
    }

    private boolean _spaceOnEnd(Node node, boolean start) {
        if (node != null && node.getNodeType() == 3) {
            String value = node.getNodeValue();
            if (start) {
                return value.startsWith(" ");
            }
            return value.endsWith(" ");
        }
        return false;
    }

    private int _getIndentationSize(DomPosition pos) {
        boolean whitespaceOK = this._allowsExtraWhitespace(pos);
        if (whitespaceOK) {
            int indentLevel = 0;
            Node parent = pos.getContainerNode();
            if (pos.isInside()) {
                --indentLevel;
            }
            while (parent.getNodeType() == 1) {
                ElementLocator parentLoc = this._context.getElementLocator(parent);
                if (!this._isFakeElementLocator(parentLoc)) {
                    ++indentLevel;
                }
                parent = parent.getParentNode();
            }
            return indentLevel * this._context.getPlugin().getIndentSize();
        }
        return -1;
    }

    private void _addWhitespaceAndUpdateLocators(int chars) {
        this._addWhitespaceAndUpdateLocators(this._curInsertOffset, chars);
    }

    private void _addWhitespaceAndUpdateLocators(int location, int chars) {
        if (chars >= 0) {
            this._context.noteCharactersAdded(location, chars + 1);
            this._addIndentationWhitespace(chars);
        }
    }

    private void _addIndentationWhitespace(int chars) {
        if (chars >= 0) {
            this._curInsertOffset += chars + 1;
            this._insertBuffer.append('\n');
            int i = 0;
            while (i < chars) {
                this._insertBuffer.append(' ');
                ++i;
            }
        }
    }

    private boolean _allowsAttributes(Element element) {
        ElementLocator loc = this._context.getElementLocator(element);
        return (loc == null || !this._isFakeElementLocator(loc)) && this._config().allowsAttributes(element);
    }

    private boolean _isFakeElementLocator(ElementLocator loc) {
        return loc != null && loc.getStartTagLocator().getLength() == 0;
    }

    private void $init$() {
        this._insertBuffer = new StringBuffer();
    }

    private class BreakOut
    extends Exception {
        private BreakOut() {
        }

        BreakOut(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

