/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.AddOrRemoveEndTagLocatorChange;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.CharsLocatorChange;
import oracle.bali.xml.dom.buffer.MapNodeLocatorChange;
import oracle.bali.xml.dom.buffer.MapSubtreeLocatorChange;
import oracle.bali.xml.dom.buffer.SimpleMapNodeToLocatorChange;
import oracle.bali.xml.dom.buffer.SlashAndCompleteLocatorChange;
import oracle.bali.xml.dom.buffer.TextSyncConfiguration;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.textsync.BufferChange;
import oracle.bali.xml.dom.buffer.textsync.InsertBufferChange;
import oracle.bali.xml.dom.buffer.textsync.NoOpBufferChange;
import oracle.bali.xml.dom.buffer.textsync.RemoveBufferChange;
import oracle.bali.xml.dom.buffer.textsync.ReplaceBufferChange;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptions;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.RelatedChange;
import oracle.bali.xml.dom.impl.DomModelPluginContext;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class TextSyncContext {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final BufferDomModel _plugin;
    private final MutationEvent _event;
    private final DomChange _change;
    private final TextSyncOptions _options;
    private BufferChange _retBufferChange;
    private static final Logger _LOGGER;

    TextSyncContext(BufferDomModel plugin, MutationEvent event, DomChange change) {
        this.$init$();
        this._plugin = plugin;
        this._event = event;
        this._change = change;
    }

    public BufferDomModel getPlugin() {
        return this._plugin;
    }

    public DomModelPluginContext getPluginContext() {
        return this._plugin.getContext();
    }

    public Logger getLogger() {
        return this.getPluginContext().getLogger();
    }

    public Document getDocument() {
        return this.getPluginContext().getDocument();
    }

    public Node getEventTargetNode() {
        return (Node)((Object)this._event.getTarget());
    }

    public void setBufferChangeNoOp() {
        this._setRetBufferChange(new NoOpBufferChange(this._change));
    }

    static {
        $assertionsDisabled = TextSyncContext.class.desiredAssertionStatus() ^ true;
        _LOGGER = Logger.getLogger(TextSyncContext.class.getName());
    }

    public void setBufferChangeInsert(int location, String text) {
        this._checkOffsetNonNegative(location);
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && text.length() <= 0) {
            throw new AssertionError();
        }
        this._setRetBufferChange(new InsertBufferChange(this._change, location, text));
    }

    public void setBufferChangeRemoval(int start, int length) {
        this._checkOffsetLengthNonNegative(start, length);
        if (!$assertionsDisabled && length <= 0) {
            throw new AssertionError();
        }
        this._setRetBufferChange(new RemoveBufferChange(this._change, start, length));
    }

    public void setBufferChangeReplace(int start, int length, String text) {
        this._checkOffsetLengthNonNegative(start, length);
        if (length == 0) {
            this.setBufferChangeInsert(start, text);
        } else if (text == null || "".equals(text)) {
            this.setBufferChangeRemoval(start, length);
        } else {
            this._setRetBufferChange(new ReplaceBufferChange(this._change, start, length, text));
        }
    }

    private void _setRetBufferChange(BufferChange change) {
        if (!$assertionsDisabled && this._retBufferChange != null) {
            throw new AssertionError();
        }
        this._retBufferChange = change;
    }

    public BufferChange getBufferChange() {
        if (this._retBufferChange == null) {
            throw new IllegalStateException("No return buffer change! domChange=" + this._change);
        }
        return this._retBufferChange;
    }

    public void changeLocatorLength(Node node, SimpleLocator locator, int length) {
        Locator saved = Locator.getCopy(locator);
        this._manager().locatorLengthChanged(locator, length);
        this.mapNodeToLocator(node, NodeRefFactory.getNodeRef((Node)node), locator, saved);
    }

    public void mapAttrToLocator(Node parent, Attr attr, Locator newLocator) {
        this.mapNodeToLocator((Node)attr, NodeRefFactory.getAttrRef((Node)parent, (Attr)attr), newLocator);
    }

    public void mapNodeToLocatorDirectly(Node node, Locator locator) {
        this._plugin.mapNodeToLocator(node, locator);
    }

    public void mapNodeToLocator(Node node, Locator newLocator, Locator oldLocator) {
        this.mapNodeToLocator(node, NodeRefFactory.getNodeRef((Node)node), newLocator, oldLocator);
    }

    public void mapNodeToLocator(Node node, NodeRef ref, Locator newLocator) {
        this.mapNodeToLocator(node, ref, newLocator, this._plugin.getLocator(node));
    }

    public void mapNodeToLocator(Node node, NodeRef ref, Locator newLocator, Locator oldLocator) {
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "MapNode: {0} from {1} to {2}", new Object[]{ref, oldLocator, newLocator});
        }
        this.mapNodeToLocatorDirectly(node, newLocator);
        this.addRelatedChange(new MapNodeLocatorChange(ref, Locator.getCopy(oldLocator), Locator.getCopy(newLocator)));
    }

    public void simpleMapNodeToLocator(Node node, Locator newLoc, Locator oldLoc) {
        this.mapNodeToLocatorDirectly(node, newLoc);
        this.addRelatedChange(new SimpleMapNodeToLocatorChange(NodeRefFactory.getNodeRef((Node)node), newLoc, oldLoc));
    }

    public void requireNonNullAndInDocument(Node node, Object desc) {
        if (node == null) {
            this.logAssertFailure("Node was null when handling change {0}! Node info: {1}", new Object[]{this._change, desc});
        } else if (DomUtils.getOwnerDocument((Node)node) != this.getDocument()) {
            this.logAssertFailure("Node was not in model's document when handling change {0}! Node info: {1} {2}  Node doc: {3}  Model doc: {4}", new Object[]{this._change, node.getNodeName(), desc, String.valueOf(node.getOwnerDocument()), String.valueOf(this.getDocument())});
        }
    }

    public void checkElementLocatorParts(ElementLocator loc, Element elem, boolean requiresName, boolean requiresStart, boolean requiresEnd) {
        if (requiresName && loc.getNameLocator() == null) {
            this.logAssertFailure("ElementLocator for {0} has null name locator! locator={1}", elem.getNodeName(), loc);
        }
        if (requiresStart && loc.getStartTagLocator() == null) {
            this.logAssertFailure("ElementLocator for {0} has null start tag locator! locator={1}", elem.getNodeName(), loc);
        }
        if (requiresEnd && loc.getEndTagLocator() == null) {
            this.logAssertFailure("ElementLocator for {0} has null end tag locator! locator={1}", elem.getNodeName(), loc);
        }
    }

    public ElementLocator getElementLocatorRequired(Element elem) {
        Locator loc = this.getLocatorRequired(elem);
        if (!(loc instanceof ElementLocator)) {
            this.logAssertFailure("Locator for {0} was not an ElementLocator! locator={1}", elem.getNodeName(), loc);
        }
        return (ElementLocator)loc;
    }

    public Locator getLocatorRequired(Node node) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        Locator loc = this.getLocator(node);
        if (loc == null) {
            this.logAssertFailure("Locator for {0} was null!", node.getNodeName());
        }
        return loc;
    }

    public Locator getLocator(Node node) {
        return this.getPlugin().getLocator(node);
    }

    public ElementLocator getElementLocator(Node node) {
        return (ElementLocator)this.getLocator(node);
    }

    public Attr getEventAttr() {
        return (Attr)this._event.getRelatedNode();
    }

    public void logAssertFailure(String msg, Object param1, Object param2) {
        this.logAssertFailure(msg, new Object[]{param1, param2});
    }

    public void logAssertFailure(String msg, Object param) {
        this.logAssertFailure(msg, new Object[]{param});
    }

    public void logAssertFailure(String msg, Object[] params) {
        LogUtils.log((Logger)_LOGGER, (Level)Level.SEVERE, (String)msg, (Object[])params, (Throwable)new RuntimeException("stack trace"));
        this._logBuffer(Level.SEVERE, "when previously logged error occurred");
        throw new RuntimeException("Assertion failure; detail messages logged.");
    }

    public void unmapSubtreeLocators(Node node, NodeRef ref, MapSubtreeLocatorChange lc) {
        lc.addNode(ref, Locator.getCopy(this.getPlugin().getLocator(node)), null);
        this.getPlugin().mapNodeToLocator(node, null);
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                Attr attr = (Attr)attrs.item(i);
                NodeRef attrRef = NodeRefFactory.getAttrRef((NodeRef)ref, (Attr)attr);
                lc.addNode(attrRef, Locator.getCopy(this.getPlugin().getLocator(attr)), null);
                this.getPlugin().mapNodeToLocator(attr, null);
                ++i;
            }
        }
        if (node.getNodeType() != 2) {
            Node child = node.getFirstChild();
            while (child != null) {
                NodeRef childRef = ref.getChildNodeRef(child);
                this.unmapSubtreeLocators(child, childRef, lc);
                child = child.getNextSibling();
            }
        }
    }

    public void noteCharactersAdded(int offset, int length) {
        this._checkOffsetLengthNonNegative(offset, length);
        if (length != 0) {
            if (_LOGGER.isLoggable(Level.FINEST)) {
                _LOGGER.log(Level.FINEST, "CharactersAdded: {0} at {1}", new Object[]{String.valueOf(length), String.valueOf(offset)});
            }
            this._manager().charactersAdded(offset, length);
            this.addRelatedChange(new CharsLocatorChange(offset, length));
        }
    }

    public void addRelatedChange(RelatedChange related) {
        this._change.addRelatedChange(related);
    }

    public void noteCharactersRemoved(int offset, int length) {
        this._checkOffsetLengthNonNegative(offset, length);
        if (length > 0) {
            if (_LOGGER.isLoggable(Level.FINEST)) {
                _LOGGER.log(Level.FINEST, "CharactersRemoved: {0} at {1}", new Object[]{String.valueOf(length), String.valueOf(offset)});
            }
            this._manager().charactersRemoved(offset, length);
            this.addRelatedChange(new CharsLocatorChange(offset, -length));
        }
    }

    public void setSlashAndComplete(Element elem, SimpleLocator oldSlashLocator, SimpleLocator newSlashLocator, boolean newComplete) {
        ElementLocator elemLocator = this.getElementLocatorRequired(elem);
        boolean oldComplete = elemLocator.isStartTagComplete();
        if (oldComplete != newComplete || !this._same(oldSlashLocator, newSlashLocator)) {
            this.addRelatedChange(new SlashAndCompleteLocatorChange(elem, (SimpleLocator)Locator.getCopy(oldSlashLocator), (SimpleLocator)Locator.getCopy(newSlashLocator), oldComplete, newComplete));
            if (oldSlashLocator != null) {
                this._manager().detach(oldSlashLocator);
            }
            if (newSlashLocator != null) {
                this._manager().attach(newSlashLocator);
            }
            elemLocator.setSlashLocator(newSlashLocator);
            elemLocator.setStartTagComplete(newComplete);
        }
    }

    public void addEndTagLocator(Element element, SimpleLocator newEndTagLocator) {
        ElementLocator elemLocator = this.getElementLocatorRequired(element);
        this._manager().addEndTagAtLocator(elemLocator, newEndTagLocator);
        this.addRelatedChange(new AddOrRemoveEndTagLocatorChange(element, (SimpleLocator)Locator.getCopy(newEndTagLocator), true));
    }

    public void removeEndTagLocator(Element element) {
        ElementLocator elemLocator = this.getElementLocatorRequired(element);
        SimpleLocator oldEndTagLocator = elemLocator.getEndTagLocator();
        if (!$assertionsDisabled && oldEndTagLocator == null) {
            throw new AssertionError();
        }
        this._manager().removeEndTagAtLocator(elemLocator);
        this._manager().detach(oldEndTagLocator);
        this.addRelatedChange(new AddOrRemoveEndTagLocatorChange(element, oldEndTagLocator, false));
    }

    public SimpleLocator createSimpleLocator(int start, int length) {
        return this._manager().createSimpleLocator(start, start + length, false);
    }

    public AttributeLocator createAttributeLocator(int nameStart, int nameLength, TextLocator valueLocator, short quoteStyle) {
        SimpleLocator nameLocator = this.createSimpleLocator(nameStart, nameLength);
        int nameEnd = nameLocator.getEndOffset();
        SimpleLocator equalsLocator = this._manager().createSimpleLocator(nameEnd, valueLocator.getStartOffset(), false);
        AttributeLocator attrLocator = this._manager().createAttributeLocator(nameLocator, equalsLocator, valueLocator, quoteStyle, (short)0);
        return attrLocator;
    }

    public ElementLocator createElementLocator(SimpleLocator startTagLocator, SimpleLocator nameLocator, SimpleLocator endTagLocator, SimpleLocator slashLocator) {
        ElementLocator loc = this._manager().createElementLocator(startTagLocator, nameLocator, endTagLocator);
        loc.setSlashLocator(slashLocator);
        return loc;
    }

    public EntityRefLocator createEntityRefLocator(int startOffset, int endOffset, String entityRefText, String replacementText) {
        EntityRefLocator erl = this._manager().createEntityRefLocator(startOffset, endOffset, entityRefText, replacementText, false);
        return erl;
    }

    public TextLocator createTextLocator(List contentLocators) {
        return this._manager().createTextLocator(contentLocators);
    }

    public TextLocator createTextLocator(List contentLocators, List wsLocators) {
        return this._manager().createTextLocator(contentLocators, wsLocators);
    }

    public AttributeLocator createZeroLengthAttrLocator(int offset) {
        return this._manager().createUnspecifiedAttributeLocator(offset);
    }

    public void attachLocators(Collection locs) {
        for (Locator loc : locs) {
            this.attachLocator(loc);
        }
    }

    public void detachLocators(Collection locs) {
        for (Locator loc : locs) {
            this.detachLocator(loc);
        }
    }

    public void attachLocator(Locator locator) {
        Locator.attach(this._manager(), true, locator);
    }

    public void detachLocator(Locator locator) {
        Locator.attach(this._manager(), false, locator);
    }

    public SortedMap getSortedNodeToLocatorMap(Collection nodes) {
        TreeMap<Node, Locator> map = new TreeMap<Node, Locator>(this._plugin.getNodeByLocatorComparator());
        for (Node node : nodes) {
            Locator loc = this.getLocator(node);
            if (loc == null) continue;
            map.put(node, loc);
        }
        return map;
    }

    public SortedSet getSortedAttributesSet(Node node) {
        return this.getPlugin().getSortedAttributesSet(node);
    }

    public TextSyncOptions getOptions() {
        return this._options;
    }

    public TextSyncConfiguration getConfig() {
        return this._plugin.getParserConfiguration().getTextSyncConfiguration();
    }

    public WhitespaceMode getElementContentWhitespaceMode(Element element) {
        WhitespaceHandler whitespaceHandler = this.getPluginContext().getWhitespaceHandler();
        return whitespaceHandler.getElementContentWhitespaceMode(null, element);
    }

    public boolean isPastRightMargin(int column) {
        return column > this.getOptions().getRightMargin();
    }

    public boolean isPastRightMargin(Node node, Locator locator) {
        return this.isPastRightMargin(this.getEndColumnForWrapping(node, locator));
    }

    public int getEndColumnForWrapping(Node node, Locator locator) {
        Element owner;
        Attr lastAttr;
        if (DomUtils.isAttribute((Node)node) && (lastAttr = (Attr)this.getSortedAttributesSet(owner = ((Attr)node).getOwnerElement()).last()) == node) {
            node = owner;
            locator = this.getElementLocatorRequired(owner).getStartTagLocator();
        }
        return locator.getEndColumnNumber() - 1;
    }

    public Locator getLastAttributeOrNameLocator(Element elem, ElementLocator elemLocator, boolean ignoreSingleAttribute) {
        int numAttrs = DomUtils.getAttributeCount((Node)elem);
        if (numAttrs == 0 || ignoreSingleAttribute && numAttrs == 1) {
            return elemLocator.getNameLocator();
        }
        SortedSet sortedAttrs = this.getSortedAttributesSet(elem);
        return this.getLocatorRequired((Attr)sortedAttrs.last());
    }

    private void _checkOffsetLengthNonNegative(int offset, int length) {
        if (offset < 0 || length < 0) {
            this.logAssertFailure("Negative offset or length! offset={0} length={1}", new Integer(offset), new Integer(length));
        }
    }

    private void _checkOffsetNonNegative(int offset) {
        if (offset < 0) {
            this.logAssertFailure("Negative offset! offset={0}", new Integer(offset));
        }
    }

    private boolean _same(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private void _logBuffer(Level level, String label) {
        if (_LOGGER.isLoggable(level)) {
            _LOGGER.log(level, "--- buffer {0} below ---\n{1}\n--- buffer {0} above ---", new Object[]{label, this._buffer().getString(0, this._buffer().getLength())});
        }
    }

    private LocatorManager _manager() {
        return this._plugin.getLocatorManager();
    }

    private TextBuffer _buffer() {
        return this._plugin.getTextBuffer();
    }

    private void $init$() {
        this._options = new TolerantTextSyncOptions(null);
    }

    static BufferDomModel ra$_plugin(TextSyncContext textSyncContext) {
        return textSyncContext._plugin;
    }

    static Logger ra$_LOGGER() {
        return _LOGGER;
    }

    private class TolerantTextSyncOptions
    implements TextSyncOptions {
        public TextSyncOptions.AttributeWrapMode getAttributeWrapMode(Element element) {
            try {
                TextSyncOptions.AttributeWrapMode attributeWrapMode = this._real().getAttributeWrapMode(element);
                return attributeWrapMode;
            }
            catch (Throwable t) {
                this._log(element, t);
                TextSyncOptions.AttributeWrapMode attributeWrapMode = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.getAttributeWrapMode(element);
                return attributeWrapMode;
            }
        }

        public int getRightMargin() {
            try {
                int n = this._real().getRightMargin();
                return n;
            }
            catch (Throwable t) {
                this._log(t);
                int n = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.getRightMargin();
                return n;
            }
        }

        public boolean isDefaultQuoteStyleDouble(Attr attr) {
            try {
                boolean bl = this._real().isDefaultQuoteStyleDouble(attr);
                return bl;
            }
            catch (Throwable t) {
                this._log(attr, t);
                boolean bl = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.isDefaultQuoteStyleDouble(attr);
                return bl;
            }
        }

        public boolean prefersWhitespaceInside(Element element) {
            try {
                boolean bl = this._real().prefersWhitespaceInside(element);
                return bl;
            }
            catch (Throwable t) {
                this._log(element, t);
                boolean bl = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.prefersWhitespaceInside(element);
                return bl;
            }
        }

        public boolean prefersWhitespaceInsideWhenEmpty(Element element) {
            try {
                boolean bl = this._real().prefersWhitespaceInsideWhenEmpty(element);
                return bl;
            }
            catch (Throwable t) {
                this._log(element, t);
                boolean bl = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.prefersWhitespaceInsideWhenEmpty(element);
                return bl;
            }
        }

        public boolean useMinimizedForm(Element element) {
            try {
                boolean bl = this._real().useMinimizedForm(element);
                return bl;
            }
            catch (Throwable t) {
                this._log(element, t);
                boolean bl = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.useMinimizedForm(element);
                return bl;
            }
        }

        public boolean wrapBeforeEndOfStartTag(Element element) {
            try {
                boolean bl = this._real().wrapBeforeEndOfStartTag(element);
                return bl;
            }
            catch (Throwable t) {
                this._log(element, t);
                boolean bl = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS.wrapBeforeEndOfStartTag(element);
                return bl;
            }
        }

        public String toString() {
            return super.toString() + "-" + this._real();
        }

        private void _log(Node param, Throwable t) {
            LogUtils.log((Logger)TextSyncContext.ra$_LOGGER(), (Level)Level.WARNING, (String)"Exception calling text sync options {0} with param {1}!", (Object[])new Object[]{this._real(), param == null ? "null" : param.getNodeName()}, (Throwable)t);
        }

        private void _log(Throwable t) {
            LogUtils.log((Logger)TextSyncContext.ra$_LOGGER(), (Level)Level.WARNING, (String)"Exception calling text sync options {0}!", (Object)this._real(), (Throwable)t);
        }

        private TextSyncOptions _real() {
            return TextSyncContext.ra$_plugin(TextSyncContext.this).getParserConfiguration().getTextSyncOptions();
        }

        private TolerantTextSyncOptions() {
        }

        TolerantTextSyncOptions(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

