/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.locator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.util.CollectionUtils;
import oracle.javatools.buffer.LineMap;

public class TextLocator
extends Locator {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final List _whitespaceLocators;
    private List _contentLocators;
    private SimpleLocator _firstLocator;
    private SimpleLocator _lastLocator;

    public static List copyLocatorList(List in) {
        if (in.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Locator> out = new ArrayList<Locator>(in.size());
        for (Locator loc : in) {
            out.add(loc.getCopy());
        }
        return out;
    }

    public Locator getCopy() {
        List cCopy = TextLocator.copyLocatorList(this._contentLocators);
        List wCopy = TextLocator.copyLocatorList(this._whitespaceLocators);
        TextLocator copy = new TextLocator(this.getLineMap(), cCopy, wCopy);
        return copy;
    }

    public int getStartOffset() {
        return this._firstLocator.getStartOffset();
    }

    public int getEndOffset() {
        return this._lastLocator.getEndOffset();
    }

    public List getContentLocators() {
        return this._contentLocators;
    }

    public List getWhitespaceLocators() {
        return this._whitespaceLocators;
    }

    public void attach(LocatorManager manager, boolean attach) {
        this._attachAll(manager, this._contentLocators, attach);
        this._attachAll(manager, this._whitespaceLocators, attach);
    }

    public int getContentTextOffset(int contentIndex) {
        if (contentIndex < 0) {
            throw new IllegalArgumentException("negative content index: " + contentIndex);
        }
        Iterator contentLocatorItor = this._contentLocators.iterator();
        while (contentLocatorItor.hasNext()) {
            SimpleLocator loc = (SimpleLocator)contentLocatorItor.next();
            int locLength = loc.getDomLength();
            if (locLength > contentIndex) {
                if (loc instanceof EntityRefLocator) {
                    EntityRefLocator erloc = (EntityRefLocator)loc;
                    return erloc.getStartOffset();
                }
                return loc.getStartOffset() + contentIndex;
            }
            if (locLength == contentIndex && !contentLocatorItor.hasNext()) {
                return this.getEndOffset();
            }
            contentIndex -= locLength;
        }
        throw new IllegalArgumentException("index not found: " + contentIndex);
    }

    static {
        $assertionsDisabled = TextLocator.class.desiredAssertionStatus() ^ true;
    }

    public void removeFirstCharFromContent() {
        this._firstLocator.setStartOffset(this._firstLocator.getStartOffset() + 1);
        if (this._firstLocator.getLength() == 0) {
            if (!$assertionsDisabled && this._contentLocators.size() <= 1) {
                throw new AssertionError();
            }
            this._makeContentLocatorModifiable();
            this._contentLocators.remove(0);
            this._firstLocator = (SimpleLocator)this._contentLocators.get(0);
        }
    }

    public void removeLastCharFromContent() {
        this._lastLocator.setEndOffset(this._lastLocator.getEndOffset() - 1);
        if (this._lastLocator.getLength() == 0) {
            if (!$assertionsDisabled && this._contentLocators.size() <= 1) {
                throw new AssertionError();
            }
            int lastIdx = this._contentLocators.size() - 1;
            this._makeContentLocatorModifiable();
            this._contentLocators.remove(lastIdx);
            this._lastLocator = (SimpleLocator)this._contentLocators.get(lastIdx - 1);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("TextLocator{");
        buf.append("content=");
        buf.append(this._contentLocators);
        buf.append(" ws=");
        buf.append(this._whitespaceLocators);
        buf.append("}");
        return buf.toString();
    }

    protected TextLocator(LineMap map, List contentLocators, List whitespaceLocators) {
        super(map);
        if (contentLocators.isEmpty()) {
            throw new IllegalArgumentException("need at least one content locator");
        }
        this._contentLocators = contentLocators;
        this._whitespaceLocators = whitespaceLocators;
        this._sort(this._contentLocators);
        SimpleLocator first = (SimpleLocator)this._contentLocators.get(0);
        SimpleLocator last = (SimpleLocator)this._contentLocators.get(this._contentLocators.size() - 1);
        if (!this._whitespaceLocators.isEmpty()) {
            this._sort(this._whitespaceLocators);
            SimpleLocator temp = (SimpleLocator)this._whitespaceLocators.get(0);
            if (temp.compareTo(first) < 0) {
                first = temp;
            }
            if ((temp = (SimpleLocator)this._whitespaceLocators.get(this._whitespaceLocators.size() - 1)).compareTo(last) > 0) {
                last = temp;
            }
        }
        this._firstLocator = first;
        this._lastLocator = last;
    }

    private void _attachAll(LocatorManager manager, List list, boolean attach) {
        for (Locator loc : list) {
            loc.attach(manager, attach);
        }
    }

    private void _sort(List list) {
        if (list.size() > 1) {
            Collections.sort(list);
        }
    }

    private void _makeContentLocatorModifiable() {
        if (CollectionUtils.isUnmodifiableList(this._contentLocators, 0)) {
            this._contentLocators = new ArrayList(this._contentLocators);
        }
    }
}

