/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.parser;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bali.xml.util.XmlNameUtils;

public class NamespaceDeclaration {
    private String _namespace;
    private String _prefix;
    private boolean _default;
    private int _scope;
    private static Map<String, Boolean> _namespaceValidityMap = new ConcurrentHashMap<String, Boolean>(33, 0.75f, 5);

    public NamespaceDeclaration(String defaultNamespace, int scope) {
        this.$init$();
        this._namespace = NamespaceDeclaration.checkForInvalidNamespace(defaultNamespace);
        this._scope = scope;
        this._default = true;
    }

    public NamespaceDeclaration(String namespace, String prefix, int scope) {
        this.$init$();
        this._namespace = NamespaceDeclaration.checkForInvalidNamespace(namespace);
        this._prefix = prefix;
        this._scope = scope;
        this._default = false;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public boolean isDefault() {
        return this._default;
    }

    public int getScope() {
        return this._scope;
    }

    public static String checkForInvalidNamespace(String namespace) {
        if (namespace == null) {
            return null;
        }
        Boolean isValid = _namespaceValidityMap.get(namespace);
        if (isValid == null) {
            isValid = true;
            try {
                XmlNameUtils.validateNamespace((String)namespace);
            }
            catch (IllegalArgumentException e) {
                isValid = false;
            }
            _namespaceValidityMap.put(namespace, isValid);
        }
        if (!isValid.booleanValue()) {
            return "error:invalid-namespace";
        }
        return namespace;
    }

    private void $init$() {
        this._namespace = null;
        this._prefix = null;
        this._default = false;
        this._scope = 0;
    }
}

