/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;

public class NamespaceDeclarations {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    public static final NamespaceDeclaration XML_NAMESPACE_DECL = new NamespaceDeclaration("http://www.w3.org/XML/1998/namespace", "xml", -1);
    public static final NamespaceDeclaration XMLNS_NAMESPACE_DECL = new NamespaceDeclaration("http://www.w3.org/2000/xmlns/", "xmlns", -1);
    private int _currentScope;
    private String _defaultNamespace;
    private HashMap _prefixMap;
    private ArrayList _declarations;

    public NamespaceDeclarations() {
        this.$init$();
        this._declarations = new ArrayList(16);
        this._prefixMap = new HashMap();
    }

    public void addNamespaceDeclaration(NamespaceDeclaration declaration) {
        int scope = declaration.getScope();
        if (this._currentScope > scope) {
            throw new IllegalArgumentException("Cannot add a new NamespaceDeclaration with a scope less than the current scope");
        }
        this._declarations.add(declaration);
        this._currentScope = scope;
        if (declaration.isDefault()) {
            this._defaultNamespace = declaration.getNamespace();
        } else if (declaration.getNamespace() != null) {
            this._prefixMap.put(declaration.getPrefix(), declaration);
        } else {
            this._prefixMap.remove(declaration.getPrefix());
        }
    }

    public void removeNamespaceDeclarations(int scope) {
        if (scope < this._currentScope) {
            throw new IllegalArgumentException("Cannot remove NamespaceDeclarations with a scope less than the currentscope");
        }
        NamespaceDeclaration currentDecl = null;
        int i = this._declarations.size() - 1;
        while (i >= 0) {
            currentDecl = (NamespaceDeclaration)this._declarations.get(i);
            if (currentDecl.getScope() != scope) break;
            this._declarations.remove(i);
            --i;
        }
        this._currentScope = this._declarations.size() > 0 ? currentDecl.getScope() : -1;
        this._resetDefaultAndMap();
    }

    public String getNamespaceForPrefix(String prefix) {
        String namespace = null;
        NamespaceDeclaration decl = (NamespaceDeclaration)this._prefixMap.get(prefix);
        if (decl != null) {
            namespace = decl.getNamespace();
        }
        return namespace;
    }

    public String getDefaultNamespace() {
        return this._defaultNamespace;
    }

    public int getCurrentScope() {
        return this._currentScope;
    }

    public Collection getPrefixDeclarations() {
        Collection prefixDecls = this._prefixMap.values();
        return Collections.unmodifiableCollection(prefixDecls);
    }

    private void _resetDefaultAndMap() {
        this._defaultNamespace = null;
        this._prefixMap.clear();
        NamespaceDeclaration currentDecl = null;
        int numDecls = this._declarations.size();
        int i = 0;
        while (i < numDecls) {
            currentDecl = (NamespaceDeclaration)this._declarations.get(i);
            if (currentDecl.isDefault()) {
                this._defaultNamespace = currentDecl.getNamespace();
            } else if (currentDecl.getNamespace() != null) {
                this._prefixMap.put(currentDecl.getPrefix(), currentDecl);
            } else {
                this._prefixMap.remove(currentDecl.getPrefix());
            }
            ++i;
        }
    }

    private void $init$() {
        this._currentScope = -1;
        this._defaultNamespace = null;
        this._prefixMap = null;
        this._declarations = null;
    }
}

