/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.parser;

import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.util.XmlNameUtils;

public class ResolvedName {
    private String _rawName;
    private String _localName;
    private String _prefix;
    private String _namespace;
    private String _errorPrefix;

    public ResolvedName(String rawName, NamespaceDeclarations declarations) {
        this(rawName, declarations, false);
    }

    public ResolvedName(String rawName, NamespaceDeclarations declarations, boolean attributeName) {
        this.$init$();
        String prefix = null;
        String localName = null;
        int separatorIndex = -1;
        if (rawName != null) {
            separatorIndex = rawName.indexOf(58);
        }
        if (separatorIndex != -1) {
            if (separatorIndex != 0) {
                prefix = rawName.substring(0, separatorIndex);
            }
            localName = separatorIndex == rawName.length() - 1 ? null : rawName.substring(separatorIndex + 1);
        } else {
            localName = rawName;
        }
        prefix = this._removeIllegalCharacters(prefix);
        localName = this._removeIllegalCharacters(localName);
        this._resolveName(prefix, localName, declarations, attributeName);
    }

    public String getRawName() {
        return this._rawName;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public final boolean matches(ResolvedName test) {
        if (this == test) {
            return true;
        }
        boolean namespacesMatch = false;
        String thisNamespace = this.getNamespace();
        String testNamespace = test.getNamespace();
        if (thisNamespace != null) {
            if (thisNamespace.equals(testNamespace)) {
                namespacesMatch = true;
            }
        } else if (testNamespace == null) {
            namespacesMatch = true;
        }
        if (namespacesMatch) {
            String thisLocalName = this.getLocalName();
            String testLocalName = test.getLocalName();
            if (thisLocalName != null ? thisLocalName.equals(testLocalName) : testLocalName == null) {
                return true;
            }
        }
        return false;
    }

    protected String getErrorPrefix() {
        return this._errorPrefix;
    }

    protected void updateAttributeResolvedName(NamespaceDeclarations declarations) {
        String originalLocalName = this._localName;
        String originalPrefix = this._prefix;
        if (originalPrefix == null) {
            originalPrefix = this._errorPrefix;
        }
        if (originalPrefix != null) {
            this._rawName = null;
            this._localName = null;
            this._prefix = null;
            this._namespace = null;
            this._errorPrefix = null;
            this._resolveName(originalPrefix, originalLocalName, declarations, true);
        }
    }

    private void _resolveName(String prefix, String localName, NamespaceDeclarations declarations, boolean attributeName) {
        this._prefix = prefix;
        this._localName = localName;
        if (this._prefix != null) {
            this._namespace = declarations.getNamespaceForPrefix(this._prefix);
            if (this._namespace == null) {
                this._errorPrefix = this._prefix;
                this._prefix = null;
            }
        }
        if (this._prefix == null) {
            this._rawName = this._localName;
            this._namespace = attributeName ? ("xmlns".equals(this._localName) ? "http://www.w3.org/2000/xmlns/" : null) : declarations.getDefaultNamespace();
        } else {
            this._rawName = this._localName != null ? this._prefix + ':' + this._localName : this._prefix;
        }
    }

    private String _removeIllegalCharacters(String name) {
        if (name != null) {
            int length = name.length();
            int start = 0;
            StringBuffer buffer = new StringBuffer(length);
            buffer.append(name);
            while (start < length) {
                if (XmlNameUtils.isNameStartChar((char)buffer.charAt(start))) break;
                ++start;
            }
            buffer.delete(0, start);
            int i = (length -= start) - 1;
            while (i > 0) {
                if (!XmlNameUtils.isNameChar((char)buffer.charAt(i))) {
                    buffer.deleteCharAt(i);
                }
                --i;
            }
            name = buffer.length() > 0 ? buffer.toString() : null;
        }
        return name;
    }

    private void $init$() {
        this._rawName = null;
        this._localName = null;
        this._prefix = null;
        this._namespace = null;
        this._errorPrefix = null;
    }
}

