/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.parser;

import java.util.List;
import oracle.bali.xml.dom.buffer.lexer.XMLLexer;
import oracle.bali.xml.dom.buffer.lexer.XMLTagLexer;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.DocumentScanner;
import oracle.bali.xml.dom.buffer.parser.DocumentScannerScope;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public class XmlDocumentScanner
extends DocumentScanner {
    public XmlDocumentScanner() {
        super((Lexer)new XMLLexer(), (Lexer)new XMLTagLexer());
    }

    protected boolean parseDocumentToken(LexerToken documentToken, NamespaceDeclarations namespaceDecls, List scopeStack) {
        boolean handledToken = true;
        switch (documentToken.getToken()) {
            case 11: {
                this.parseElement(documentToken, namespaceDecls, scopeStack, true);
                break;
            }
            case 12: {
                this.parseElement(documentToken, namespaceDecls, scopeStack, false);
                break;
            }
            case 16: {
                this.parseText(documentToken);
                break;
            }
            case 13: {
                this.parseComment(documentToken);
                break;
            }
            case 17: {
                this.parseCDATASection(documentToken);
                break;
            }
            case 14: {
                this.parseDeclaration(documentToken);
                break;
            }
            case 18: {
                this.parseDocumentType(documentToken, namespaceDecls, scopeStack);
                break;
            }
            case 15: {
                this.parsePI(documentToken);
                break;
            }
            default: {
                handledToken = false;
                break;
            }
        }
        return handledToken;
    }

    protected boolean parseElementToken(LexerToken elementToken, ElementDeclaration elementDecl, NamespaceDeclarations namespaceDecls, DocumentScannerScope proposedScope, int startOffset, int endOffset) {
        boolean handledToken = true;
        switch (elementToken.getToken()) {
            case 21: {
                this.parseElementName(elementToken, elementDecl, namespaceDecls, proposedScope, startOffset, endOffset);
                break;
            }
            case 22: {
                this.parseAttributeName(elementToken, elementDecl, namespaceDecls, proposedScope, startOffset, endOffset);
                break;
            }
            case 23: {
                this.parseAttributeValue(elementToken, elementDecl, namespaceDecls, proposedScope, startOffset, endOffset);
                break;
            }
            case 24: {
                this.parseSymbol(elementToken, elementDecl, namespaceDecls, proposedScope, startOffset, endOffset);
                break;
            }
            default: {
                handledToken = false;
                break;
            }
        }
        return handledToken;
    }

    protected void addBuiltInNamespaceDeclarations(NamespaceDeclarations namespaceDecls) {
        namespaceDecls.addNamespaceDeclaration(NamespaceDeclarations.XML_NAMESPACE_DECL);
        namespaceDecls.addNamespaceDeclaration(NamespaceDeclarations.XMLNS_NAMESPACE_DECL);
    }

    protected int findNameOrValueTokenEnd(Lexer elementLexer) {
        int tokenEnd;
        try {
            tokenEnd = ((XMLTagLexer)elementLexer).skipNameOrValue(true);
        }
        catch (IndexOutOfBoundsException e) {
            tokenEnd = this.getBuffer().getLength();
        }
        return tokenEnd;
    }

    protected void postProcessAttribute(ResolvedName attributeName, String attributeValue, NamespaceDeclarations namespaceDecls, DocumentScannerScope scannerScope) {
        if (attributeValue != null && "http://www.w3.org/2000/xmlns/".equals(attributeName.getNamespace())) {
            String namespace = attributeValue;
            if (namespace.length() == 0) {
                namespace = null;
            }
            NamespaceDeclaration newNamespaceDecl = null;
            String localName = attributeName.getLocalName();
            newNamespaceDecl = "xmlns".equals(localName) ? new NamespaceDeclaration(namespace, scannerScope.getNamespaceScope()) : new NamespaceDeclaration(namespace, localName, scannerScope.getNamespaceScope());
            namespaceDecls.addNamespaceDeclaration(newNamespaceDecl);
        }
    }

    protected final void updateAttributeNames(ResolvedName elementName, ElementDeclaration elementDecl, NamespaceDeclarations namespaceDecls, DocumentScannerScope proposedScope) {
        if (namespaceDecls.getCurrentScope() == proposedScope.getNamespaceScope()) {
            AttributeDeclarations attributes = elementDecl.getAttributeDeclarations();
            int numAttributes = attributes.getLength();
            int i = 0;
            while (i < numAttributes) {
                ResolvedName attrName = attributes.getResolvedName(i);
                if (attrName != null) {
                    attrName.updateAttributeResolvedName(namespaceDecls);
                }
                ++i;
            }
        }
    }

    protected void parsePI(LexerToken documentToken) {
        int startOffset = documentToken.getStartOffset();
        int endOffset = documentToken.getEndOffset();
        ReadTextBuffer buffer = this.getBuffer();
        SimpleLocator locator = this.getManager().createSimpleLocator(startOffset, endOffset);
        if (endOffset - (startOffset += 2) >= 1 && buffer.getChar(endOffset - 1) == '>' && --endOffset - startOffset >= 1 && buffer.getChar(endOffset - 1) == '?') {
            --endOffset;
        }
        String target = null;
        int targetEndOffset = this.findTokenEnd(startOffset, endOffset);
        if (targetEndOffset - startOffset > 0) {
            target = this.getStringValue(startOffset, targetEndOffset);
        }
        String data = "";
        int dataStartOffset = this.findNextTokenStart(targetEndOffset, endOffset);
        if (dataStartOffset != -1 && endOffset - dataStartOffset > 0) {
            data = this.getStringValue(dataStartOffset, endOffset);
        }
        this.getHandler().handleProcessingInstruction(target, data, locator);
    }

    protected void parseDeclaration(LexerToken documentToken) {
        int startOffset = documentToken.getStartOffset();
        int endOffset = documentToken.getEndOffset();
        SimpleLocator locator = this.getManager().createSimpleLocator(startOffset, endOffset);
        DeclarationLocator declarationLocator = this.getManager().createDeclarationLocator(locator);
        String currentAttributeName = null;
        String currentAttributeValue = null;
        AttributeLocator currentAttributeLocator = null;
        Lexer elementLexer = this.getElementLexer();
        elementLexer.setPosition(startOffset);
        LexerToken elementToken = elementLexer.createLexerToken();
        elementLexer.lex(elementToken);
        int tokenStartOffset = 0;
        int tokenEndOffset = 0;
        int tokenValue = 0;
        String version = null;
        String encoding = null;
        String standalone = null;
        while (elementToken.getEndOffset() <= endOffset && elementToken.getToken() != 0) {
            tokenValue = elementToken.getToken();
            tokenStartOffset = elementToken.getStartOffset();
            tokenEndOffset = elementToken.getEndOffset();
            if (elementToken.getToken() == 22) {
                if (currentAttributeName != null) {
                    if ("version".equals(currentAttributeName)) {
                        version = currentAttributeValue;
                        declarationLocator.setVersionLocator(currentAttributeLocator);
                    } else if ("encoding".equals(currentAttributeName)) {
                        encoding = currentAttributeValue;
                        declarationLocator.setEncodingLocator(currentAttributeLocator);
                    } else if ("standalone".equals(currentAttributeName)) {
                        standalone = currentAttributeValue;
                        declarationLocator.setStandaloneLocator(currentAttributeLocator);
                    }
                }
                currentAttributeName = this.getStringValue(tokenStartOffset, tokenEndOffset);
                currentAttributeValue = null;
                SimpleLocator attrNameLocator = this.getManager().createSimpleLocator(tokenStartOffset, tokenEndOffset);
                currentAttributeLocator = this.getManager().createAttributeLocator(attrNameLocator);
            } else if (elementToken.getToken() == 23) {
                currentAttributeValue = this.parseAttributeValue(currentAttributeLocator, tokenStartOffset, tokenEndOffset);
            }
            elementLexer.lex(elementToken);
        }
        if (currentAttributeName != null) {
            if ("version".equals(currentAttributeName)) {
                version = currentAttributeValue;
                declarationLocator.setVersionLocator(currentAttributeLocator);
            } else if ("encoding".equals(currentAttributeName)) {
                encoding = currentAttributeValue;
                declarationLocator.setEncodingLocator(currentAttributeLocator);
            } else if ("standalone".equals(currentAttributeName)) {
                standalone = currentAttributeValue;
                declarationLocator.setStandaloneLocator(currentAttributeLocator);
            }
        }
        this.getHandler().handleXMLDeclaration(version, encoding, standalone, declarationLocator);
    }

    protected void parseCDATASection(LexerToken documentToken) {
        int startOffset = documentToken.getStartOffset();
        int endOffset = documentToken.getEndOffset();
        SimpleLocator locator = this.getManager().createSimpleLocator(startOffset, endOffset);
        ReadTextBuffer buffer = this.getBuffer();
        if (endOffset - (startOffset += 9) >= 3 && buffer.getChar(endOffset - 3) == ']' && buffer.getChar(endOffset - 2) == ']' && buffer.getChar(endOffset - 1) == '>') {
            endOffset -= 3;
        }
        String characters = this.getStringValue(startOffset, endOffset);
        this.getHandler().handleCDATASection(characters, locator);
    }
}

