/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.textsync;

import oracle.bali.xml.dom.buffer.TextSyncContext;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptions;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

abstract class AttributeWrapper {
    private static final AttributeWrapper _WRAPPER_NONE = new 1();
    private static final AttributeWrapper _WRAPPER_AT_MARGIN_JUST_INDENTED = new 2();
    private static final AttributeWrapper _WRAPPER_AT_MARGIN_UNDER_FIRST_ATTR = new 3();
    private static final AttributeWrapper _WRAPPER_ALWAYS_JUST_INDENTED = new 4();

    public static AttributeWrapper get(TextSyncContext context, Attr attr) {
        TextSyncOptions.AttributeWrapMode mode = context.getOptions().getAttributeWrapMode(attr.getOwnerElement());
        if (mode == TextSyncOptions.ATTR_WRAP_NONE) {
            return _WRAPPER_NONE;
        }
        if (mode == TextSyncOptions.ATTR_WRAP_AT_MARGIN_JUST_INDENTED) {
            return _WRAPPER_AT_MARGIN_JUST_INDENTED;
        }
        if (mode == TextSyncOptions.ATTR_WRAP_AT_MARGIN_UNDER_FIRST_ATTR) {
            return _WRAPPER_AT_MARGIN_UNDER_FIRST_ATTR;
        }
        if (mode == TextSyncOptions.ATTR_WRAP_ALWAYS_JUST_INDENTED) {
            return _WRAPPER_ALWAYS_JUST_INDENTED;
        }
        throw new IllegalArgumentException("unknown wrap mode for " + attr + ": " + mode);
    }

    public abstract int getWrapColumn(TextSyncContext var1, Attr var2, Locator var3);

    private AttributeWrapper() {
    }

    AttributeWrapper(4 var1_1) {
        this();
    }

    AttributeWrapper(1 var1_1) {
        this();
    }

    private static abstract class AtMarginWrapper
    extends AttributeWrapper {
        public final int getWrapColumn(TextSyncContext context, Attr attr, Locator locator) {
            ElementLocator ownerLoc;
            Element owner;
            int desiredColumn;
            if (context.isPastRightMargin(attr, locator) && (desiredColumn = this.calculateDesiredColumn(context, owner = attr.getOwnerElement(), ownerLoc = context.getElementLocatorRequired(owner), attr, locator)) < locator.getStartColumnNumber() - 1) {
                return desiredColumn;
            }
            return -1;
        }

        protected abstract int calculateDesiredColumn(TextSyncContext var1, Element var2, ElementLocator var3, Attr var4, Locator var5);

        private AtMarginWrapper() {
            super((4)null);
        }

        AtMarginWrapper(2 var1_1) {
            this();
        }

        AtMarginWrapper(3 var1_1) {
            this();
        }
    }

    static final class 1
    extends AttributeWrapper {
        public int getWrapColumn(TextSyncContext context, Attr attr, Locator locator) {
            return -1;
        }

        public 1() {
            super((1)null);
        }
    }

    static final class 2
    extends AtMarginWrapper {
        protected int calculateDesiredColumn(TextSyncContext context, Element owner, ElementLocator ownerLoc, Attr attr, Locator attrLocator) {
            return ownerLoc.getStartColumnNumber() + context.getPlugin().getIndentSize() - 1;
        }

        public 2() {
            super((2)null);
        }
    }

    static final class 3
    extends AtMarginWrapper {
        protected int calculateDesiredColumn(TextSyncContext context, Element owner, ElementLocator ownerLoc, Attr attr, Locator attrLocator) {
            return ownerLoc.getNameLocator().getEndColumnNumber();
        }

        public 3() {
            super((3)null);
        }
    }

    static final class 4
    extends AttributeWrapper {
        public final int getWrapColumn(TextSyncContext context, Attr attr, Locator locator) {
            Element owner = attr.getOwnerElement();
            ElementLocator ownerLoc = context.getElementLocatorRequired(owner);
            return ownerLoc.getStartColumnNumber() - 1 + context.getPlugin().getIndentSize();
        }

        public 4() {
            super((4)null);
        }
    }
}

