/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.textsync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.TextSyncContext;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.textsync.AttributeWrapper;
import oracle.bali.xml.dom.buffer.textsync.ReformatInfo;
import oracle.bali.xml.dom.buffer.textsync.ReformatInfoTracker;
import oracle.bali.xml.dom.buffer.textsync.TextSyncUtils;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;
import oracle.bali.xml.util.CollectionUtils;
import oracle.javatools.buffer.TextBuffer;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Reformatter {
    private final Map _changeToInfo;
    private static final Logger _LOGGER = Logger.getLogger(Reformatter.class.getName());

    public void trackChange(DomChange change, TextSyncContext context) {
        ReformatInfo info = ReformatInfoTracker.create(change, context);
        this._changeToInfo.put(change, info);
    }

    public void untrackChange(DomChange change) {
        this._changeToInfo.remove(change);
    }

    public void reset() {
        this._changeToInfo.clear();
    }

    public void doReformatting(TextSyncContext context, TextBuffer buffer) {
        block2: {
            try {
                this._wrapAttrs(context, buffer);
                this._wrapInsertedTextNodes(context, buffer);
                this._wrapEndOfStartTags(context, buffer);
            }
            catch (Throwable t) {
                _LOGGER.log(Level.WARNING, "Exception during post-textsync formatting adjustment. Trying to continue.", t);
                if (!(t instanceof ThreadDeath)) break block2;
                throw (ThreadDeath)t;
            }
        }
    }

    private void _wrapEndOfStartTags(TextSyncContext context, TextBuffer buffer) {
        for (ReformatInfo info : this._changeToInfo.values()) {
            this._wrapEndOfStartTags(context, buffer, info.elementsToWrapStartTag);
        }
    }

    private void _wrapEndOfStartTags(TextSyncContext context, TextBuffer buffer, Set elems) {
        if (!elems.isEmpty()) {
            for (Element elem : elems) {
                this._wrapEndOfStartTag(context, buffer, elem);
            }
        }
    }

    private void _wrapEndOfStartTag(TextSyncContext context, TextBuffer buffer, Element elem) {
        ElementLocator loc = context.getElementLocator(elem);
        if (loc != null && loc.isStartTagComplete()) {
            int spot = loc.getStartTagLocator().getEndOffset() - context.getConfig().getStartTagEnd(elem).length();
            int desiredColumn = loc.getStartColumnNumber() - 1 + context.getPlugin().getIndentSize();
            char[] toInsert = new char[desiredColumn + 1];
            toInsert[0] = 10;
            Arrays.fill(toInsert, 1, toInsert.length, ' ');
            buffer.insert(spot, toInsert);
            context.noteCharactersAdded(spot, toInsert.length);
        }
    }

    private void _wrapInsertedTextNodes(TextSyncContext context, TextBuffer buffer) {
        for (ReformatInfo info : this._changeToInfo.values()) {
            this._wrapInsertedTextNodes(context, buffer, info.insertedTextNodes);
        }
    }

    private void _wrapInsertedTextNodes(TextSyncContext context, TextBuffer buffer, Set nodes) {
        if (!nodes.isEmpty()) {
            for (Text text : nodes) {
                this._wrapSingleInsertedTextNode(context, buffer, text);
            }
        }
    }

    private void _wrapSingleInsertedTextNode(TextSyncContext context, TextBuffer buffer, Text node) {
        String text = node.getNodeValue();
        if (text == null) {
            return;
        }
        int textLen = text.length();
        TextLocator origLocator = (TextLocator)context.getLocator(node);
        if (origLocator == null || textLen < 3) {
            return;
        }
        WhitespaceMode mode = context.getElementContentWhitespaceMode((Element)node.getParentNode());
        int lastWsIndex = -1;
        TextLocator locator = origLocator;
        LinkedList<TNRData> instructions = new LinkedList<TNRData>();
        int i = 1;
        while (i < textLen - 1) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t') {
                lastWsIndex = i;
            } else if (lastWsIndex > -1) {
                int iOffset = locator.getContentTextOffset(i);
                int iColumn = Locator.getColumnNumber(buffer.getLineMap(), iOffset);
                if (iColumn >= 0 && context.isPastRightMargin(iColumn)) {
                    TNRData data;
                    DomPosition pos = DomPositionFactory.createTextPosition((CharacterData)node, (int)lastWsIndex);
                    Boolean allowed = mode.allowsAddingExtraWhitespace(pos);
                    if (!Boolean.FALSE.equals(allowed) && (data = this._doTextNodeWrap(context, buffer, locator, lastWsIndex)) != null) {
                        locator = data.newLocator;
                        instructions.add(data);
                    }
                    lastWsIndex = -1;
                }
            }
            ++i;
        }
        if (!instructions.isEmpty()) {
            context.detachLocator(origLocator);
            context.simpleMapNodeToLocator(node, null, origLocator);
            for (TNRData inst : instructions) {
                context.noteCharactersAdded(inst.wsBufferOffset, inst.indentationLevel);
            }
            context.attachLocator(locator);
            context.simpleMapNodeToLocator(node, locator, null);
        }
    }

    private TNRData _doTextNodeWrap(TextSyncContext context, TextBuffer buffer, TextLocator locator, int index) {
        int textStartColumn;
        int offset = locator.getContentTextOffset(index);
        int column = Locator.getColumnNumber(buffer.getLineMap(), offset);
        if (column <= (textStartColumn = locator.getStartColumnNumber())) {
            return null;
        }
        if (textStartColumn == 1) {
            buffer.remove(offset, 1);
            buffer.insert(offset, new char[]{'\n'});
            return new TNRData(offset, 0, locator);
        }
        List newContentLocators = TextLocator.copyLocatorList(locator.getContentLocators());
        ArrayList<SimpleLocator> newWhitespaceLocators = TextLocator.copyLocatorList(locator.getWhitespaceLocators());
        int splitOffset = offset + 1;
        boolean ok = TextSyncUtils.splitLocatorList(newContentLocators, new int[]{splitOffset});
        if (!ok) {
            return null;
        }
        if (buffer.getChar(offset) == ' ') {
            char[] wsChars = new char[textStartColumn - 1];
            wsChars[0] = 10;
            Arrays.fill(wsChars, 1, wsChars.length, ' ');
            buffer.insert(offset, wsChars);
        } else {
            char[] wsChars = new char[textStartColumn];
            wsChars[0] = 10;
            Arrays.fill(wsChars, 1, wsChars.length, ' ');
            buffer.insert(offset + 1, wsChars);
            buffer.remove(offset, 1);
        }
        int wsInsertionLocation = offset + 1;
        int wsInsertionLength = textStartColumn - 1;
        SimpleLocator wsLocator = context.createSimpleLocator(wsInsertionLocation, wsInsertionLength);
        TextSyncUtils.adjustLocatorsForAddition(newContentLocators, wsInsertionLocation, wsInsertionLength);
        TextSyncUtils.adjustLocatorsForAddition(newWhitespaceLocators, wsInsertionLocation, wsInsertionLength);
        if (CollectionUtils.isUnmodifiableList(newWhitespaceLocators, 0)) {
            ArrayList<SimpleLocator> newList = new ArrayList<SimpleLocator>(newWhitespaceLocators.size() + 1);
            newList.addAll(newWhitespaceLocators);
            newWhitespaceLocators = newList;
        }
        newWhitespaceLocators.add(wsLocator);
        TextLocator newTextLocator = context.createTextLocator(newContentLocators, newWhitespaceLocators);
        return new TNRData(wsInsertionLocation, wsInsertionLength, newTextLocator);
    }

    private void _wrapAttrs(TextSyncContext context, TextBuffer buffer) {
        SortedMap attrToLocator = this._getAttrToLocator(context);
        for (Map.Entry entry : attrToLocator.entrySet()) {
            this._wrapSingleAttr(context, buffer, (Attr)entry.getKey(), (Locator)entry.getValue());
        }
    }

    private void _wrapSingleAttr(TextSyncContext context, TextBuffer buffer, Attr attr, Locator locator) {
        int desiredColumn = AttributeWrapper.get(context, attr).getWrapColumn(context, attr, locator);
        if (desiredColumn > 0) {
            int oldStartOffset = locator.getStartOffset();
            int numCharsToRemove = this._getPrecedingSpaces(buffer, oldStartOffset - 1);
            int removeStart = oldStartOffset - numCharsToRemove;
            buffer.remove(removeStart, numCharsToRemove);
            int numCharsToAdd = desiredColumn + 1;
            char[] toAdd = new char[numCharsToAdd];
            toAdd[0] = 10;
            Arrays.fill(toAdd, 1, toAdd.length, ' ');
            buffer.insert(removeStart, toAdd);
            int delta = numCharsToAdd - numCharsToRemove;
            if (delta > 0) {
                context.noteCharactersAdded(removeStart, delta);
            } else {
                context.noteCharactersRemoved(removeStart, -delta);
            }
        }
    }

    private int _getPrecedingSpaces(TextBuffer buffer, int offset) {
        int spaces = 0;
        while (offset > 0) {
            char c = buffer.getChar(offset);
            if (!WhitespaceUtils.isXmlWhitespaceChar(c)) break;
            ++spaces;
            --offset;
        }
        return spaces;
    }

    private SortedMap _getAttrToLocator(TextSyncContext context) {
        HashSet addedAttrs = new HashSet();
        for (ReformatInfo info : this._changeToInfo.values()) {
            addedAttrs.addAll(info.addedAttrs);
        }
        return context.getSortedNodeToLocatorMap(addedAttrs);
    }

    private void $init$() {
        this._changeToInfo = new HashMap(23);
    }

    public Reformatter() {
        this.$init$();
    }

    private static class TNRData {
        public final int wsBufferOffset;
        public final int indentationLevel;
        public final TextLocator newLocator;

        public TNRData(int wsOffset, int indent, TextLocator newLoc) {
            this.wsBufferOffset = wsOffset;
            this.indentationLevel = indent;
            this.newLocator = newLoc;
        }
    }
}

