/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.textsync;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.ref.NodeRef;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextSyncUtils {
    public static void adjustLocatorsForAddition(List locators, int offset, int delta) {
        for (SimpleLocator loc : locators) {
            if (loc.getStartOffset() < offset) continue;
            loc.move(delta);
        }
    }

    public static boolean updateWhitespaceLocatorsForRemoval(List wsList, int start, int bufferRemovalLength) {
        if (bufferRemovalLength == 0) {
            return true;
        }
        int end = start + bufferRemovalLength;
        Iterator wsItor = wsList.iterator();
        while (wsItor.hasNext()) {
            SimpleLocator loc = (SimpleLocator)wsItor.next();
            int locStart = loc.getStartOffset();
            int locEnd = loc.getEndOffset();
            if (locEnd <= start) continue;
            if (locStart >= end) {
                loc.setStartOffset(locStart - bufferRemovalLength);
                loc.setEndOffset(locEnd - bufferRemovalLength);
                continue;
            }
            if (start <= locStart && end >= locEnd) {
                wsItor.remove();
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean splitLocatorList(List locators, int[] offsets) {
        ListIterator<SimpleLocator> itor = locators.listIterator();
        int totalOffsets = offsets.length;
        int nextOffsetToConsider = 0;
        while (itor.hasNext()) {
            SimpleLocator loc = (SimpleLocator)itor.next();
            int locStart = loc.getStartOffset();
            int locEnd = loc.getEndOffset();
            boolean isEntity = loc instanceof EntityRefLocator;
            int i = nextOffsetToConsider;
            while (i < totalOffsets) {
                int curOffset = offsets[i];
                if (loc.containsNotAtStart(curOffset)) {
                    if (isEntity) {
                        return false;
                    }
                    nextOffsetToConsider = i + 1;
                    SimpleLocator secondLoc = (SimpleLocator)loc.getCopy();
                    loc.setEndOffset(curOffset);
                    secondLoc.setStartOffset(curOffset);
                    itor.add(secondLoc);
                    loc = secondLoc;
                }
                ++i;
            }
        }
        return true;
    }

    public static void minimizeNumberOfLocators(List locators) {
        Iterator itor = locators.iterator();
        SimpleLocator possibleMerge = null;
        while (itor.hasNext()) {
            SimpleLocator loc = (SimpleLocator)itor.next();
            boolean isEntity = loc instanceof EntityRefLocator;
            if (isEntity) {
                possibleMerge = null;
                continue;
            }
            if (possibleMerge != null && possibleMerge.getEndOffset() == loc.getStartOffset()) {
                itor.remove();
                possibleMerge.setEndOffset(loc.getEndOffset());
                continue;
            }
            possibleMerge = loc;
        }
    }

    public static final void debugRootLocator(DomModel model, BufferDomModel plugin, Logger logger) {
        TextSyncUtils.debugRootLocator(model.getDocument(), plugin, logger);
    }

    public static void debugRootLocator(Document document, BufferDomModel plugin, Logger logger) {
        if (logger.isLoggable(Level.FINEST)) {
            Element root = document.getDocumentElement();
            String locText = root == null ? "null" : String.valueOf(plugin.getLocator(root));
            logger.log(Level.FINEST, "Root node {0} has locator {1}", new Object[]{root, locText});
        }
    }

    public static final Node getNode(DomModel model, NodeRef ref) {
        return TextSyncUtils.getNode(model.getDocument(), ref);
    }

    public static Node getNode(Document document, NodeRef ref) {
        Node ret = ref.getCorrespondingNode(document);
        if (ret == null) {
            throw new IllegalStateException("null node for ref " + ref);
        }
        return ret;
    }

    private TextSyncUtils() {
    }
}

