/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.changes;

import oracle.bali.xml.dom.changes.AbstractAttrChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AttrValueChange
extends AbstractAttrChange {
    private final String _prevValue;
    private final String _newValue;

    public AttrValueChange(Attr attr, String prevValue, String newValue) {
        super(attr, attr.getOwnerElement());
        this._prevValue = prevValue;
        this._newValue = newValue;
    }

    private AttrValueChange(Attr attr, NodeRef ownerElementRef, String prevValue, String newValue) {
        super(attr, ownerElementRef);
        this._prevValue = prevValue;
        this._newValue = newValue;
    }

    public void process(DomChangeHandler handler) {
        handler.handleAttrValueChange(this);
    }

    public DomChange getOppositeChange() {
        return new AttrValueChange(this.getAffectedAttrClone(), this.getOwnerElementRef(), this._newValue, this._prevValue);
    }

    public Attr getChangedAttr(Document doc) {
        Attr attrCopy = this.getAffectedAttrClone();
        return this.getOwnerElement(doc).getAttributeNodeNS(attrCopy.getNamespaceURI(), DomUtils.getLocalName((Node)attrCopy));
    }

    public String getPrevValue() {
        return this._prevValue;
    }

    public String getNewValue() {
        return this._newValue;
    }

    public Attr getChangedAttrClone() {
        return this.getAffectedAttrClone();
    }
}

