/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.changes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.RelatedChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.share.ReverseListIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DomChange {
    public static final int PRE_UNDO_INDEX = 0;
    public static final int POST_UNDO_INDEX = 1;
    public static final int PRE_REDO_INDEX = 2;
    public static final int POST_REDO_INDEX = 3;
    private List _relatedChanges;

    private static Iterator _getIterator(List list, boolean forwardOrder) {
        if (forwardOrder) {
            return list.iterator();
        }
        return new ReverseListIterator(list);
    }

    public final void deliverRelatedChanges(DomModel model, int changeType) {
        DomChange.deliverRelatedChanges(this._getRelatedChangesNonNull(), this, model, changeType);
    }

    public static void deliverRelatedChanges(List relatedChanges, DomChange domChange, DomModel model, int changeType) {
        boolean forward = changeType == 2 || changeType == 3;
        Iterator related = DomChange._getIterator(relatedChanges, forward);
        while (related.hasNext()) {
            RelatedChange currRelatedChange = (RelatedChange)related.next();
            if (currRelatedChange == null) continue;
            switch (changeType) {
                case 0: {
                    currRelatedChange.preUndo(model, domChange);
                    break;
                }
                case 1: {
                    currRelatedChange.postUndo(model, domChange);
                    break;
                }
                case 2: {
                    currRelatedChange.preRedo(model, domChange);
                    break;
                }
                case 3: {
                    currRelatedChange.postRedo(model, domChange);
                    break;
                }
            }
        }
    }

    public final void addRelatedChange(RelatedChange change) {
        this.addRelatedChanges(Collections.singletonList(change));
    }

    public final void addRelatedChanges(List changes) {
        if (this._relatedChanges == null) {
            this._relatedChanges = new ArrayList();
        }
        this._relatedChanges.addAll(changes);
    }

    public final void addRelatedChanges(DomChange copyFrom) {
        this.addRelatedChanges(copyFrom._getRelatedChangesNonNull());
    }

    public abstract void process(DomChangeHandler var1);

    public abstract DomChange getOppositeChange();

    public abstract NodeRef getNodeRef();

    public boolean canMergeWith(DomChange other) {
        return false;
    }

    public String toString() {
        String fullName = this.getClass().getName();
        int lastDot = fullName.lastIndexOf(46);
        String shortName = lastDot == -1 ? fullName : fullName.substring(lastDot + 1);
        return shortName + ": " + this.getNodeRef();
    }

    protected static Node cloneNode(Node node) {
        Document scratchDocument = DomUtils.getScratchDocument();
        return scratchDocument.importNode(node, true);
    }

    protected final boolean sameNodeRef(DomChange other) {
        return this.getNodeRef().equals((Object)other.getNodeRef());
    }

    private List _getRelatedChangesNonNull() {
        List relatedChanges = this._relatedChanges != null ? this._relatedChanges : Collections.EMPTY_LIST;
        return relatedChanges;
    }

    private void $init$() {
        this._relatedChanges = null;
    }

    public DomChange() {
        this.$init$();
    }
}

