/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.changes;

import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DomChangeApplier
implements DomChangeHandler {
    protected abstract Document getDocument();

    public void handleAttrAddedChange(AttrAddedChange change) {
        this.preHook(change);
        DomUtils.addAttr((Element)change.getOwnerElement(this.getDocument()), (Attr)change.getAddedAttributeClone());
        this.postHook(change);
    }

    public void handleAttrRemovedChange(AttrRemovedChange change) {
        this.preHook(change);
        DomUtils.removeAttr((Element)change.getOwnerElement(this.getDocument()), (Attr)change.getRemovedAttributeClone());
        this.postHook(change);
    }

    public void handleAttrValueChange(AttrValueChange change) {
        this.preHook(change);
        Attr attr = change.getChangedAttr(this.getDocument());
        attr.setValue(change.getNewValue());
        this.postHook(change);
    }

    public void handleNodeInsertedChange(NodeInsertedChange change) {
        this.preHook(change);
        DomUtils.addChild((Document)this.getDocument(), (NodeRef)change.getNodeRef(), (Node)change.getInsertedNodeClone());
        this.postHook(change);
    }

    public void handleNodeRemovedChange(NodeRemovedChange change) {
        this.preHook(change);
        DomUtils.removeChild((Document)this.getDocument(), (NodeRef)change.getNodeRef());
        this.postHook(change);
    }

    public void handleNodeValueChange(NodeValueChange change) {
        this.preHook(change);
        Node node = change.getNodeRef().getCorrespondingNode(this.getDocument());
        node.setNodeValue(change.getNewValue());
        this.postHook(change);
    }

    protected void preHook(DomChange change) {
    }

    protected void postHook(DomChange change) {
    }
}

