/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.changes;

import oracle.bali.xml.dom.changes.AbstractNodeChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.share.string.StringChange;
import oracle.bali.xml.share.string.StringChangeUtils;
import org.w3c.dom.Node;

public class NodeValueChange
extends AbstractNodeChange {
    private final String _prevValue;
    private final String _newValue;
    private final StringChange _stringChange;

    public NodeValueChange(Node node, String prevValue, String newValue) {
        super(node);
        this._prevValue = prevValue;
        this._newValue = newValue;
        this._stringChange = this._computeStringChange();
    }

    private NodeValueChange(NodeRef ref, Node nodeClone, String prevValue, String newValue) {
        super(ref, nodeClone);
        this._prevValue = prevValue;
        this._newValue = newValue;
        this._stringChange = this._computeStringChange();
    }

    public void process(DomChangeHandler handler) {
        handler.handleNodeValueChange(this);
    }

    public DomChange getOppositeChange() {
        return new NodeValueChange(this.getNodeRef(), this.getAffectedNodeClone(), this.getNewValue(), this.getPrevValue());
    }

    public String getPrevValue() {
        return this._prevValue;
    }

    public String getNewValue() {
        return this._newValue;
    }

    public StringChange getStringChange() {
        return this._stringChange;
    }

    public boolean canMergeWith(DomChange other) {
        if (this.sameNodeRef(other)) {
            if (other.getClass() == this.getClass()) {
                NodeValueChange otherNVC = (NodeValueChange)other;
                if (this._eq(this._newValue, otherNVC._prevValue)) {
                    int otherSpot;
                    StringChange ourChange = this.getStringChange();
                    StringChange otherChange = otherNVC.getStringChange();
                    int ourSpot = ourChange.getOffset() + ourChange.getInsertionCount();
                    return ourSpot == (otherSpot = otherChange.getOffset() + otherChange.getRemovalCount());
                }
            } else if (other.getClass() == NodeRemovedChange.class) {
                return true;
            }
        }
        return false;
    }

    private boolean _eq(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private StringChange _computeStringChange() {
        return StringChangeUtils.computeStringChange(this._prevValue, this._newValue);
    }
}

