/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.impl;

import java.lang.ref.Reference;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelHolder;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.bali.xml.dom.impl.ChangeRecord;
import oracle.bali.xml.dom.impl.DomModelImpl;
import oracle.javatools.logging.LogUtils;

class DomChangesUndoableEditImpl
extends DomChangesUndoableEdit
implements DomModelHolder {
    private boolean _allowAddEdit;
    private final Reference _modelRef;
    private final String _description;

    public DomChangesUndoableEditImpl(DomModelImpl model, String description, List changeInfos) {
        this(DomChangesUndoableEditImpl.flattenDomChangeListToArray(changeInfos), model, description);
    }

    public DomChangesUndoableEditImpl(DomModelImpl model, DomChange outOfTransactionChange) {
        this(new DomChange[]{outOfTransactionChange}, model, DomChangesUndoableEditImpl._createDescription(model, outOfTransactionChange));
    }

    private DomChangesUndoableEditImpl(DomChange[] changeInfos, DomModelImpl model, String description) {
        super(changeInfos);
        this._description = description;
        this._allowAddEdit = model.__getCurrentUndoableEditMergable() && this._allChangesCanMergeTogether();
        this._modelRef = model.getDomModelReference();
    }

    public DomModel getDomModel() {
        return this._getModel();
    }

    public void undo() throws CannotUndoException {
        DomModelImpl model = this._getModel();
        if (model != null) {
            model.handleUndoOccuredPreHook(this);
        }
        super.undo();
        if (model != null) {
            model.startUndoTransaction();
            try {
                this.processChangesInReverse(model.__getUndoHandler());
                model.handleUndoOccuredPostHook(this);
                model.commitTransaction();
            }
            catch (Throwable t) {
                this._catchInUndoRedo(t, "undo", model);
            }
        }
        this._allowAddEdit = false;
    }

    public void redo() throws CannotRedoException {
        DomModelImpl model = this._getModel();
        if (model != null) {
            model.handleRedoOccuredPreHook(this);
        }
        super.redo();
        if (model != null) {
            model.startRedoTransaction();
            try {
                this.processChanges(model.__getRedoHandler());
                model.handleRedoOccuredPostHook(this);
                model.commitTransaction();
            }
            catch (Throwable t) {
                this._catchInUndoRedo(t, "redo", model);
            }
        }
    }

    public String getPresentationName() {
        return this._description;
    }

    public static DomChange[] flattenDomChangeListToArray(List l) {
        int size = DomChangesUndoableEditImpl._countItems(l);
        DomChange[] changes = new DomChange[size];
        int nextIdx = 0;
        DomChangesUndoableEditImpl._addItems(l, changes, nextIdx);
        return changes;
    }

    protected boolean canAddEdit(DomChangesUndoableEdit other) {
        DomChangesUndoableEditImpl o = (DomChangesUndoableEditImpl)other;
        if (!this._allowAddEdit || !o._allowAddEdit) {
            return false;
        }
        DomModelImpl model = this._getModel();
        DomModelImpl oModel = o._getModel();
        if (model == null || model != oModel) {
            return false;
        }
        return super.canAddEdit(other);
    }

    private DomModelImpl _getModel() {
        return (DomModelImpl)this._modelRef.get();
    }

    private static int _addItems(List l, DomChange[] changes, int nextIdx) {
        for (Object next : l) {
            if (next instanceof List) {
                nextIdx = DomChangesUndoableEditImpl._addItems((List)next, changes, nextIdx);
                continue;
            }
            changes[nextIdx] = ((ChangeRecord)next).getChange();
            ++nextIdx;
        }
        return nextIdx;
    }

    private static int _countItems(List l) {
        int size = 0;
        for (Object next : l) {
            if (next instanceof List) {
                size += DomChangesUndoableEditImpl._countItems((List)next);
                continue;
            }
            ++size;
        }
        return size;
    }

    private void _catchInUndoRedo(Throwable t, String which, DomModelImpl model) {
        LogUtils.log((Logger)model.getLogger(), (Level)Level.SEVERE, (String)"Exception in {0} of transaction {1} on {2}", (Object[])new Object[]{which, this.getPresentationName(), model}, (Throwable)t);
        model.rollbackTransaction();
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
    }

    private boolean _allChangesCanMergeTogether() {
        int count = this.getChangeCount();
        if (count == 0) {
            return false;
        }
        if (count > 1) {
            DomChange prior = this.getChange(0);
            int i = 1;
            while (i < count) {
                DomChange now = this.getChange(i);
                if (!prior.canMergeWith(now)) {
                    return false;
                }
                prior = now;
                ++i;
            }
        }
        return true;
    }

    private static String _createDescription(DomModelImpl model, DomChange change) {
        return model.getContext().getTranslatedString("DOM_MODEL.OUT_OF_TRANSACTION_CHANGE");
    }
}

