/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomCommitException;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.DomModelListener;
import oracle.bali.xml.dom.DomMutationListener;
import oracle.bali.xml.dom.NodeCustomizationDetails;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.bali.xml.dom.impl.DomModelPlugin;
import oracle.bali.xml.dom.impl.DomModelPluginContext;
import oracle.bali.xml.dom.impl.DomModelPluginFactory;
import oracle.bali.xml.dom.impl.DomModelTransaction;
import oracle.bali.xml.dom.impl.RedoHandler;
import oracle.bali.xml.dom.impl.RootDomModelTransaction;
import oracle.bali.xml.dom.impl.UndoHandler;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.tracking.TrackingEventHandler;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.logging.LogUtils;
import oracle.javatools.util.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public final class DomModelImpl
extends DomModel
implements DomModelPluginContext {
    private static final Log LOG;
    static final /* synthetic */ boolean $assertionsDisabled;
    private final DocumentChangeListener _DOM_LISTENER;
    private final SafeListenerManager _undoListeners;
    private final SafeListenerManager _mutationListeners;
    private final DomChangeHandler _undoHandler;
    private final DomChangeHandler _redoHandler;
    private final DomModelPluginFactory _pluginFactory;
    private volatile RootDomModelTransaction _rootTransaction;
    private volatile transient DomModelTransaction _currTransaction;
    private transient boolean _currentEditMergable;
    private DomModelPlugin _domModelPlugin;
    private Document _document;
    private boolean _sendReadOnlyPropChangeASAP;
    private volatile boolean _inUndoRedoTxn;
    private volatile int _inStaleLockCount;
    private volatile boolean _disposed;

    protected DomModelImpl(DomModelContext context, DomModelPluginFactory pluginFactory, WhitespaceHandler whitespaceHandler) {
        super(context, whitespaceHandler);
        this.$init$();
        this._pluginFactory = pluginFactory;
    }

    public DOMImplementation getDOMImplementation() {
        return this.getDomModelPlugin().getDOMImplementation();
    }

    public Document getDocument() {
        this.verifyLock();
        if (this._inStaleLockCount <= 0) {
            this.getDomModelPlugin().ensureDocumentAvailable();
        }
        return this.getDocumentInternal();
    }

    public void destroyDocument() {
        this.acquireWriteLock();
        try {
            if (this.getDocumentInternal() != null) {
                this.replaceDocument(null);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public boolean isReadOnly() {
        return this.getDomModelPlugin().isReadOnly();
    }

    public boolean isImmutable(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("isImmutable passed null Node");
        }
        if (this.isReadOnly()) {
            return true;
        }
        this.verifyLock();
        return this.getDomModelPlugin().isImmutable(node);
    }

    public boolean isDeletable(Node node) {
        if (node == null) {
            return false;
        }
        this.verifyLock();
        return this.getDomModelPlugin().isDeletable(node);
    }

    public boolean canAddChild(DomPosition position) {
        if (position == null) {
            return false;
        }
        this.verifyLock();
        return this.getDomModelPlugin().canAddChild(position);
    }

    public boolean canAddAttribute(Element parent, String attributeNamespace, String attributeLocalName) {
        if (parent == null || attributeLocalName == null) {
            return false;
        }
        this.verifyLock();
        return this.getDomModelPlugin().canAddAttribute(parent, attributeNamespace, attributeLocalName);
    }

    public boolean isValueModifiable(Node node) {
        if (node == null) {
            return false;
        }
        this.verifyLock();
        return this.getDomModelPlugin().isValueModifiable(node);
    }

    public NodeCustomizationDetails getCustomizationDetails(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("getCustomizationDetails passed null Node");
        }
        this.verifyLock();
        return this.getDomModelPlugin().getCustomizationDetails(node);
    }

    public boolean prefersSmallestPossibleChangeRoot() {
        return this.getDomModelPlugin().prefersSmallestPossibleChangeRoot();
    }

    public boolean needsReparse() {
        return this.getDomModelPlugin().needsReparse();
    }

    public void forceReparse() {
        DomModelPlugin plugin = this.getDomModelPlugin();
        plugin.acquireWriteLockDirectly();
        try {
            this.refreshModel(true);
        }
        finally {
            plugin.releaseWriteLockDirectly();
        }
    }

    public void startTransaction(String description) {
        this.acquireWriteLock();
        this.getLogger().log(Level.FINER, "startTransaction: {0}", description);
        this._currTransaction = this._currTransaction.startNestedTransaction(description);
        if (this.isInTopLevelTransaction()) {
            this._currentEditMergable = false;
        }
    }

    public DomCommitException precommitTransaction() {
        this.getLogger().finer("precommitTransaction");
        this.verifyWriteLock();
        return this._currTransaction.precommit();
    }

    public void commitTransaction() {
        this.getLogger().finer("commitTransaction");
        try {
            this._currTransaction = this._currTransaction.commit();
        }
        finally {
            this._finishCommitOrRollback();
        }
        this._inUndoRedoTxn = false;
    }

    public void rollbackTransaction() {
        this.getLogger().finer("rollbackTransaction");
        try {
            this._currTransaction = this._currTransaction.rollback();
        }
        finally {
            this._finishCommitOrRollback();
        }
        this._inUndoRedoTxn = false;
    }

    public int getLockStatus() {
        return this.getDomModelPlugin().getLockStatus();
    }

    public void acquireReadLock() {
        boolean needsReparse;
        DomModelPlugin plugin = this.getDomModelPlugin();
        plugin.acquireReadLockDirectly();
        try {
            needsReparse = this.needsReparse();
        }
        catch (ExpiredTextBufferException e) {
            LOG.trace("handled expiration in DomModelImpl.acquireReadLock: {0}", (Object)e);
            return;
        }
        if (needsReparse) {
            plugin.releaseReadLockDirectly();
            plugin.acquireWriteLockDirectly();
            try {
                this.refreshModel(false);
                plugin.acquireReadLockDirectly();
            }
            finally {
                plugin.releaseWriteLockDirectly();
            }
        }
    }

    public void releaseReadLock() {
        this.getDomModelPlugin().releaseReadLockDirectly();
    }

    public void acquireWriteLock() {
        this.getDomModelPlugin().acquireWriteLockDirectly();
        try {
            this.refreshModel(false);
        }
        catch (Throwable t) {
            this.getDomModelPlugin().releaseWriteLockDirectly();
            String message = "Unexpected exception encountered during DomModelImpl.acquireWriteLock";
            this.getLogger().log(Level.SEVERE, message, t);
            throw new IllegalStateException(message, t);
        }
    }

    public void releaseWriteLock() {
        this.getDomModelPlugin().releaseWriteLockDirectly();
    }

    public void acquireStaleDataLock() {
        this.getDomModelPlugin().acquireReadLockDirectly();
        ++this._inStaleLockCount;
    }

    public void releaseStaleDataLock() {
        --this._inStaleLockCount;
        this.getDomModelPlugin().releaseReadLockDirectly();
    }

    public void verifyLock() {
        switch (this.getLockStatus()) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.handleMissingLock(new IllegalStateException());
                break;
            }
        }
    }

    public void verifyWriteLock() {
        if (this.getLockStatus() != 2) {
            this.handleMissingWriteLock(new IllegalStateException());
        }
    }

    public void markCurrentUndoableEditMergable() {
        this.verifyWriteLock();
        if (this._notInTransaction()) {
            throw new IllegalStateException("must be in transaction!");
        }
        this._currentEditMergable = true;
    }

    public Node getChangeTarget() {
        this.verifyLock();
        return this._currTransaction.getCommittedChangeTarget();
    }

    public String getTransactionDescription() {
        this.verifyLock();
        return this._currTransaction.getDescription();
    }

    public boolean isInTransaction() {
        this.verifyLock();
        return this._notInTransaction() ^ true;
    }

    public boolean isInTopLevelTransaction() {
        this.verifyLock();
        return this._currTransaction.getParent() == this._rootTransaction;
    }

    public int getTextOffset(DomPosition pos) {
        this.verifyLock();
        if (this._rootTransaction.hasModifications()) {
            return -1;
        }
        return this.getDomModelPlugin().getTextOffset(pos);
    }

    static {
        $assertionsDisabled = DomModelImpl.class.desiredAssertionStatus() ^ true;
        LOG = new Log("expiration");
    }

    public void getTextOffsets(Node node, int[] results) {
        if (!$assertionsDisabled && results == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && results.length != 2) {
            throw new AssertionError();
        }
        if (node == null) {
            throw new IllegalArgumentException("null node");
        }
        this.getDomModelPlugin().getTextOffsets(node, results);
    }

    public Node getNodeAtOffset(int offset) {
        this.verifyLock();
        if (this._rootTransaction.hasModifications()) {
            return null;
        }
        return this.getDomModelPlugin().getNodeAtOffset(offset);
    }

    public DomPosition getDomPosition(int caretPosition, boolean considerAttrs) {
        this.verifyLock();
        if (this._rootTransaction.hasModifications()) {
            return null;
        }
        return this.getDomModelPlugin().getDomPosition(caretPosition, considerAttrs);
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this._undoListeners.addListener(l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this._undoListeners.removeListener(l);
    }

    public void addDomChangeListener(DomModelListener listener) {
        this._currTransaction.addDomChangeListener(listener);
    }

    public void removeDomChangeListener(DomModelListener listener) {
        this._currTransaction.removeDomChangeListener(listener);
    }

    public void addDomMutationListener(DomMutationListener listener) {
        this._mutationListeners.addListener(listener);
    }

    public void removeDomMutationListener(DomMutationListener listener) {
        this._mutationListeners.removeListener(listener);
    }

    public int getDocChangeCount() {
        this.acquireReadLock();
        try {
            int n = this._rootTransaction.getChangeCount();
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public List getCurrentDomParseProblems() {
        this.verifyLock();
        return this.getDomModelPlugin().getCurrentDomParseProblems();
    }

    public void setDocType(String qualifiedName, String publicId, String systemId) {
        if (qualifiedName == null || qualifiedName.length() == 0) {
            throw new IllegalArgumentException("invalid qname: " + qualifiedName);
        }
        if ("".equals(publicId)) {
            publicId = null;
        }
        this._verifyNotInTransaction();
        this.acquireWriteLock();
        try {
            UndoableEdit edit = this.getDomModelPlugin().setDocType(qualifiedName, publicId, systemId);
            if (edit != null) {
                this.__addEdit(edit);
                this.flushContextPendingEvents();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void removeDocType() {
        this._verifyNotInTransaction();
        this.acquireWriteLock();
        try {
            UndoableEdit edit = this.getDomModelPlugin().removeDocType();
            if (edit != null) {
                this.__addEdit(edit);
                this.flushContextPendingEvents();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public XmlDeclarationInfo getXmlDeclarationInfo() {
        this.verifyLock();
        return this.getDomModelPlugin().getXmlDeclarationInfo();
    }

    public void setXmlDeclarationInfo(XmlDeclarationInfo info) {
        this._verifyNotInTransaction();
        this.acquireWriteLock();
        try {
            UndoableEdit edit = this.getDomModelPlugin().setXmlDeclarationInfo(info);
            if (edit != null) {
                this.__addEdit(edit);
                this.flushContextPendingEvents();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public DomModel.FragmentParseResult parseFragment(Node contextNode, Map predefinedPrefixes, String text) {
        DomModel.FragmentParseResult result = null;
        this.acquireReadLock();
        try {
            result = this.getDomModelPlugin().parseFragment(this.getDocument(), contextNode, predefinedPrefixes, text);
        }
        finally {
            this.releaseReadLock();
        }
        return result;
    }

    public void reformatSubtree(String undoLabel, Node parent, Object options) {
        this._verifyNotInTransaction();
        this.acquireReadLock();
        try {
            Document doc = this.getDocument();
            if (doc == null || doc.getFirstChild() == null) {
                return;
            }
            if (parent == null) {
                parent = doc;
            } else if (doc != DomUtils.getOwnerDocument((Node)parent) || !DomUtils.isInDocumentHierarchy((Node)parent)) {
                throw new IllegalArgumentException("node passed to reformatSubtree not in document!");
            }
        }
        finally {
            this.releaseReadLock();
        }
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        this.getDomModelPlugin().reformatSubtree(undoLabel, parent, options);
        this.flushContextPendingEvents();
    }

    public boolean isUnspecifiedAttribute(Attr attr) {
        this.verifyLock();
        return this.getDomModelPlugin().isUnspecifiedAttribute(attr);
    }

    public Attr setUnspecifiedAttribute(Element owner, String namespaceURI, String qname, String value) {
        this.verifyWriteLock();
        if (owner == null) {
            throw new IllegalArgumentException("null owner");
        }
        int colonIdx = qname.indexOf(58);
        String localName = colonIdx < 0 ? qname : qname.substring(colonIdx + 1);
        Attr old = owner.getAttributeNodeNS(namespaceURI, localName);
        if (old != null) {
            throw new IllegalArgumentException("attr already set! ns=" + namespaceURI + " localname=" + localName);
        }
        return this.getDomModelPlugin().setUnspecifiedAttribute(owner, namespaceURI, qname, value);
    }

    public void mergeTextNodes(Text first, Text second) {
        this.verifyWriteLock();
        if (first == null || second == null) {
            throw new IllegalArgumentException("null parameter not allowed");
        }
        if (first.getNextSibling() != second) {
            throw new IllegalArgumentException("second must be next sibling of first");
        }
        this.getDomModelPlugin().mergeTextNodes(first, second);
    }

    public Text splitTextNode(Text orig, int offset) {
        this.verifyWriteLock();
        if (offset <= 0 || offset >= orig.getLength()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
        return this.getDomModelPlugin().splitTextNode(orig, offset);
    }

    protected void disposeImpl() {
        this._disposed = true;
        this.getDomModelPlugin().dispose();
    }

    protected void refreshModel(boolean force) {
        this.getDomModelPlugin().refreshModel(force);
    }

    public String toString() {
        return super.toString() + ", context=" + this.getContext() + ", plugin=" + this.getDomModelPlugin();
    }

    public DomModelContext getDomModelContext() {
        return this.getContext();
    }

    public void handleLockUpgradeAttempt(IllegalStateException e) {
        LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)"Attempt to upgrade read lock to write lock. This leads to deadlocks. Model={0}", (Object)this, (Throwable)e);
        this._nagToLogWindow(e, "upgrade attempt");
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChange propertyChange = new PropertyChange(propertyName, oldValue, newValue);
        this._rootTransaction.fireSubtreeChanged(null, 0, Collections.EMPTY_LIST, Collections.singletonMap(propertyName, propertyChange), null, false);
    }

    public void replaceDocument(Document newDocument) {
        Document oldDocument = null;
        this.verifyWriteLock();
        oldDocument = this._document;
        if (newDocument == oldDocument) {
            return;
        }
        try {
            this.__removeDocListeners();
        }
        catch (ThreadDeath th) {
            throw th;
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "unexpected throwable", t);
        }
        this._document = newDocument;
        if (this._currTransaction != this._rootTransaction) {
            throw new IllegalStateException("in transaction during replaceDocument!");
        }
        this._rootTransaction = new RootDomModelTransaction(this, this._rootTransaction);
        this._currTransaction = this._rootTransaction;
        this.__addDocListeners();
        this.fireDomMutationEvent(null, null);
        this._rootTransaction.fireEntireDocumentChangedEvent(Collections.singletonMap("documentChanged", new PropertyChange("documentChanged", oldDocument, newDocument)));
        this.getDomModelPlugin().postReplaceDocument(newDocument);
    }

    public void handleReadOnlyStatusChange() {
        if (this._notInTransaction()) {
            this._queueDeliveryOfReadOnlyPropertyChange();
        } else {
            this._sendReadOnlyPropChangeASAP = true;
        }
    }

    public int getLockStatus(ReadWriteLock lock) {
        if (lock.isWriteLockHeld()) {
            return 2;
        }
        if (lock.isReadLockHeld()) {
            return 1;
        }
        return 0;
    }

    protected DomModelPlugin getDomModelPlugin() {
        if (this._domModelPlugin == null) {
            this._domModelPlugin = this._pluginFactory.createDomModelPlugin(this);
        }
        return this._domModelPlugin;
    }

    protected Document getDocumentInternal() {
        return this._document;
    }

    protected void startUndoTransaction() {
        if (this._currTransaction != this._rootTransaction) {
            throw new IllegalStateException("Nested Transaction Open");
        }
        this.getLogger().finer("startUndoTransaction");
        this.acquireWriteLock();
        this._currTransaction = this._rootTransaction.startUndoTransaction();
        this._inUndoRedoTxn = true;
    }

    protected void startRedoTransaction() {
        if (this._currTransaction != this._rootTransaction) {
            throw new IllegalStateException("Nested Transaction Open");
        }
        this.getLogger().finer("startRedoTransaction");
        this.acquireWriteLock();
        this._currTransaction = this._rootTransaction.startRedoTransaction();
        this._inUndoRedoTxn = true;
    }

    protected void handleUncommittedMutationEventHook(DomChange domChange, MutationEvent mEvent, boolean modifiesUndoStack) {
        this.fireDomMutationEvent(domChange, mEvent);
        this.getDomModelPlugin().handleUncommittedMutationEventHook(domChange, mEvent, modifiesUndoStack);
    }

    protected void handleChangeRollbackPreHook(DomChange change) {
        this.getDomModelPlugin().handleChangeRollbackPreHook(change);
    }

    protected void handleChangeRollbackPostHook(DomChange change) {
        this.getDomModelPlugin().handleChangeRollbackPostHook(change);
    }

    protected void handleUndoOccuredPreHook(DomChangesUndoableEdit edit) {
        this.getDomModelPlugin().handleUndoOccuredPreHook(edit);
    }

    protected void handleUndoOccuredPostHook(DomChangesUndoableEdit edit) {
        this.getDomModelPlugin().handleUndoOccuredPostHook(edit);
    }

    protected void handleRedoOccuredPreHook(DomChangesUndoableEdit edit) {
        this.getDomModelPlugin().handleRedoOccuredPreHook(edit);
    }

    protected void handleRedoOccuredPostHook(DomChangesUndoableEdit edit) {
        this.getDomModelPlugin().handleRedoOccuredPostHook(edit);
    }

    protected Map getExtraPropertyChanges(Node changeTarget, int changeFlags, boolean isNestedTransaction) {
        return this.getDomModelPlugin().getExtraPropertyChanges(changeTarget, changeFlags, isNestedTransaction, this._inUndoRedoTxn);
    }

    protected void handleMissingLock(IllegalStateException e) {
        LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)"Read lock required, but not held. Model={0}", (Object)this, (Throwable)e);
        this._nagToLogWindow(e, "missing read lock");
    }

    protected void handleMissingWriteLock(IllegalStateException e) {
        LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)"Write lock required, but not held. Model={0}", (Object)this, (Throwable)e);
        this._nagToLogWindow(e, "missing write lock");
    }

    protected void fireDomMutationEvent(DomChange domChange, MutationEvent mEvent) {
        if (!this._mutationListeners.isEmpty()) {
            Iterator mutationListeners = this._mutationListeners.iterator();
            while (mutationListeners.hasNext()) {
                try {
                    DomMutationListener currListener = (DomMutationListener)mutationListeners.next();
                    currListener.domMutated(this, domChange, mEvent);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Unexpected exception in Mutation Listener:", e);
                }
            }
        }
    }

    DomCommitException __precommitDomChanges(DomChange[] domChanges) {
        if (domChanges.length > 0) {
            return this.getDomModelPlugin().precommitDomChanges(domChanges);
        }
        return null;
    }

    void __addEdit(UndoableEdit edit) {
        if (edit instanceof DomChangesUndoableEdit) {
            DomChangesUndoableEdit domChanges = (DomChangesUndoableEdit)edit;
            this.getDomModelPlugin().handleCommittedDomChanges(domChanges);
        }
        UndoableEditEvent undoEvent = new UndoableEditEvent(this, edit);
        Iterator itor = this._undoListeners.iterator();
        while (itor.hasNext()) {
            try {
                ((UndoableEditListener)itor.next()).undoableEditHappened(undoEvent);
            }
            catch (Throwable e) {
                this.getLogger().log(Level.SEVERE, "BaseDomModel.__addEdit", e);
            }
        }
    }

    void __removeDocListeners() {
        DomModelImpl.__removeDocListeners((EventTarget)((Object)this._document), this._DOM_LISTENER);
    }

    static void __removeDocListeners(EventTarget target, EventListener listener) {
        if (target != null) {
            target.removeEventListener("DOMNodeInserted", listener, false);
            target.removeEventListener("DOMNodeRemoved", listener, false);
            target.removeEventListener("DOMAttrModified", listener, false);
            target.removeEventListener("DOMCharacterDataModified", listener, false);
        }
    }

    void __addDocListeners() {
        DomModelImpl.__addDocListeners((EventTarget)((Object)this._document), this._DOM_LISTENER);
    }

    static void __addDocListeners(EventTarget target, EventListener listener) {
        if (target != null) {
            target.addEventListener("DOMNodeInserted", listener, false);
            target.addEventListener("DOMNodeRemoved", listener, false);
            target.addEventListener("DOMAttrModified", listener, false);
            target.addEventListener("DOMCharacterDataModified", listener, false);
        }
    }

    boolean __getCurrentUndoableEditMergable() {
        return this._currentEditMergable;
    }

    DomChangeHandler __getUndoHandler() {
        return this._undoHandler;
    }

    DomChangeHandler __getRedoHandler() {
        return this._redoHandler;
    }

    private void _finishCommitOrRollback() {
        boolean sendROChange = this._sendReadOnlyPropChangeASAP;
        this.releaseWriteLock();
        if (sendROChange && this._notInTransaction()) {
            this._deliverReadOnlyPropertyChange();
        }
    }

    private void _queueDeliveryOfReadOnlyPropertyChange() {
        1 t = new 1("read-only change delivery thread for " + this);
        t.setPriority(10);
        t.start();
    }

    private void _deliverReadOnlyPropertyChange() {
        if (!this._disposed) {
            this.acquireWriteLock();
            try {
                if (!this._disposed) {
                    this._verifyNotInTransaction();
                    this._sendReadOnlyPropChangeASAP = false;
                    Boolean nowIsRO = this.isReadOnly();
                    this.firePropertyChange("readOnly", null, nowIsRO);
                }
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }

    private void _verifyNotInTransaction() {
        if (!this._notInTransaction()) {
            throw new IllegalStateException("in transaction when not allowed! " + this);
        }
    }

    private boolean _notInTransaction() {
        return this._currTransaction == this._rootTransaction;
    }

    private void _nagToLogWindow(IllegalStateException e, String prefix) {
    }

    private void $init$() {
        this._DOM_LISTENER = new DocumentChangeListener(null);
        this._undoListeners = new SafeListenerManager();
        this._mutationListeners = new SafeListenerManager();
        this._undoHandler = new UndoHandler(this);
        this._redoHandler = new RedoHandler(this);
        this._rootTransaction = new RootDomModelTransaction(this);
        this._currTransaction = this._rootTransaction;
        this._currentEditMergable = false;
        this._sendReadOnlyPropChangeASAP = false;
        this._inUndoRedoTxn = false;
        this._inStaleLockCount = 0;
        this._disposed = false;
    }

    static DomModelTransaction ra$_currTransaction(DomModelImpl domModelImpl) {
        return domModelImpl._currTransaction;
    }

    static void mav$_deliverReadOnlyPropertyChange(DomModelImpl domModelImpl) {
        domModelImpl._deliverReadOnlyPropertyChange();
    }

    final class 1
    extends Thread {
        public void run() {
            DomModelImpl.mav$_deliverReadOnlyPropertyChange(DomModelImpl.this);
        }

        public 1(String string) {
            super(string);
        }
    }

    private class DocumentChangeListener
    implements EventListener {
        public void handleEvent(Event event) {
            DomModelImpl.this.verifyWriteLock();
            try {
                DomModelImpl.ra$_currTransaction(DomModelImpl.this).handleMutationEvent(event);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                DomModelImpl.this.getLogger().log(Level.SEVERE, "BaseDomModel$DocumentChangeListener", t);
            }
        }

        private DocumentChangeListener() {
        }

        DocumentChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class LockAssertingTrackingEventHandler
    extends TrackingEventHandler {
        public void handleWrite(Node n) {
            DomModelImpl.this.verifyWriteLock();
        }

        public void handleRead(Node n) {
            DomModelImpl.this.verifyLock();
        }

        private LockAssertingTrackingEventHandler() {
        }
    }
}

