/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.impl;

import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.impl.DomModelImpl;
import oracle.bali.xml.dom.impl.UndoHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class InTransactionChangeRollbackHandler
extends UndoHandler {
    private final Node _associatedNode;

    InTransactionChangeRollbackHandler(DomModelImpl model, Node node) {
        super(model);
        this._associatedNode = node;
    }

    public void handleAttrRemovedChange(AttrRemovedChange change) {
        if (this._associatedNode != null) {
            Element owner = change.getOwnerElement(this.getDocument());
            this.preHook(change);
            owner.setAttributeNodeNS((Attr)this._associatedNode);
            this.postHook(change);
        } else {
            super.handleAttrRemovedChange(change);
        }
    }

    public void handleNodeRemovedChange(NodeRemovedChange change) {
        if (this._associatedNode != null) {
            this.preHook(change);
            change.getNodeRef().putCorrespondingNode(this.getDocument(), this._associatedNode);
            this.postHook(change);
        } else {
            super.handleNodeRemovedChange(change);
        }
    }

    protected void preHook(DomChange change) {
        super.preHook(change);
        this.getModel().handleChangeRollbackPreHook(change);
    }

    protected void postHook(DomChange change) {
        super.postHook(change);
        this.getModel().handleChangeRollbackPostHook(change);
    }
}

