/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.impl.ChangeRecord;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class NCDImpl
extends NodeChangeDetails
implements DomChangeHandler {
    private final Set _added;
    private final Set _changed;
    private final Set _removed;
    private final Set _moved;
    private final Map _elemToPriorAttrMap;
    private final Map _nodeToPriorValue;
    private final Set _addedImm;
    private final Set _removedImm;
    private final Set _changedImm;
    private final Set _movedImm;
    static final /* synthetic */ boolean $assertionsDisabled;
    private transient Node _changedNodeTemp;

    NCDImpl() {
        this.$init$();
    }

    public Set getAddedNodes() {
        return this._addedImm;
    }

    public Set getRemovedNodes() {
        return this._removedImm;
    }

    public Set getChangedNodes() {
        return this._changedImm;
    }

    public Set getMovedNodes() {
        return this._movedImm;
    }

    public Map getPriorAttributeValues(Node node) {
        Map got = (Map)this._elemToPriorAttrMap.get(node);
        if (got == null || got.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(got);
    }

    public String getPriorNodeValue(Node node) {
        return (String)this._nodeToPriorValue.get(node);
    }

    public NodeChangeDetails addDetails(NodeChangeDetails other) {
        if (other == null) {
            return this;
        }
        NCDImpl copy = this._getCopyImpl();
        Iterator itor = other.getAddedNodes().iterator();
        while (itor.hasNext()) {
            copy._nodeInserted((Node)itor.next());
        }
        itor = other.getRemovedNodes().iterator();
        while (itor.hasNext()) {
            copy._nodeRemoved((Node)itor.next());
        }
        itor = other.getMovedNodes().iterator();
        while (itor.hasNext()) {
            copy._nodeMoved((Node)itor.next());
        }
        for (Node node : other.getChangedNodes()) {
            copy._nodeChanged(node, other.getPriorNodeValue(node));
            Map attrMap = other.getPriorAttributeValues(node);
            for (Map.Entry entry : attrMap.entrySet()) {
                copy._attrValueChangeImpl((Element)node, (QualifiedName)entry.getKey(), (String)entry.getValue());
            }
        }
        return copy;
    }

    public NodeChangeDetails getCopy() {
        return this._getCopyImpl();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append("{ ");
        this._s(buf, "added", this._added);
        this._s(buf, "removed", this._removed);
        this._s(buf, "changed", this._changed);
        this._s(buf, "moved", this._moved);
        for (Node changedNode : this._changed) {
            Map attrs = this._getPriorAttributeValuesImpl(changedNode);
            if (attrs.isEmpty()) continue;
            this._out(buf, "attrs for " + changedNode.getNodeName(), attrs);
        }
        buf.append("}");
        return buf.toString();
    }

    private void _nodeInserted(Node node) {
        if (this._moved.contains(node)) {
            return;
        }
        if (this._removed.remove(node)) {
            this._nodeMoved(node);
        } else if (!this._isDescendent(this._added, node, true)) {
            this._added.add(node);
        }
        this._updateChildrenInInsertedSubtree(node);
    }

    private void _nodeRemoved(Node node) {
        this._moved.remove(node);
        if (!this._added.remove(node) && !this._isDescendent(this._added, node, false)) {
            this._removed.add(node);
        }
        this._updateChildrenInRemovedSubtree(node);
    }

    private void _nodeChanged(Node node, String oldValue) {
        boolean ignore;
        boolean bl = ignore = this._isDescendent(this._added, node, true) && !this._isDescendent(this._moved, node, true);
        if (!ignore) {
            this._changed.add(node);
            this._providePriorNodeValueIfNeeded(node, oldValue);
        }
    }

    private void _providePriorNodeValueIfNeeded(Node node, String oldValue) {
        if (oldValue != null && !this._nodeToPriorValue.containsKey(node)) {
            this._nodeToPriorValue.put(node, oldValue);
        }
    }

    private void _nodeMoved(Node node) {
        this._moved.add(node);
        this._added.remove(node);
        this._removed.remove(node);
    }

    private void _attrValueChange(Attr attr, String from, String to) {
        Element owner = attr.getOwnerElement();
        this._nodeChanged(owner, null);
        this._attrValueChangeImpl(owner, DomUtils.getQualifiedName((Node)attr), from);
    }

    private NCDImpl _getCopyImpl() {
        NCDImpl copy = new NCDImpl();
        copy._added.addAll(this._added);
        copy._changed.addAll(this._changed);
        copy._removed.addAll(this._removed);
        copy._moved.addAll(this._moved);
        copy._nodeToPriorValue.putAll(this._nodeToPriorValue);
        for (Map.Entry entry : this._elemToPriorAttrMap.entrySet()) {
            copy._elemToPriorAttrMap.put(entry.getKey(), new HashMap((Map)entry.getValue()));
        }
        return copy;
    }

    private Map _getPriorAttributeValuesImpl(Node node) {
        Map got = (Map)this._elemToPriorAttrMap.get(node);
        if (got == null || got.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return got;
    }

    private void _s(StringBuffer buf, String desc, Set set) {
        if (!set.isEmpty()) {
            ArrayList<String> copy = new ArrayList<String>(set);
            int i = 0;
            while (i < copy.size()) {
                Node node = (Node)copy.get(i);
                copy.set(i, node.getNodeName());
                ++i;
            }
            this._out(buf, desc, copy);
        }
    }

    private void _out(StringBuffer buf, String desc, Object value) {
        buf.append(desc);
        buf.append(": ");
        buf.append(value);
        buf.append(" ");
    }

    private void _attrValueChangeImpl(Element owner, QualifiedName qname, String from) {
        TreeMap<QualifiedName, String> mapForOwner = (TreeMap<QualifiedName, String>)this._elemToPriorAttrMap.get(owner);
        if (mapForOwner == null) {
            mapForOwner = new TreeMap<QualifiedName, String>();
            this._elemToPriorAttrMap.put(owner, mapForOwner);
        }
        if (!mapForOwner.containsKey(qname)) {
            mapForOwner.put(qname, from);
        }
    }

    private boolean _isDescendent(Set set, Node node, boolean nodeOK) {
        for (Node parent : set) {
            if (nodeOK && parent == node) {
                return true;
            }
            if (!DomUtils.isDescendant((Node)node, (Node)parent)) continue;
            return true;
        }
        return false;
    }

    private void _updateChildrenInInsertedSubtree(Node node) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 4: 
            case 8: {
                this._providePriorNodeValueIfNeeded(node, NodeChangeDetails.UNSET_VALUE);
                break;
            }
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (this._removed.remove(child)) {
                this._moved.add(child);
            }
            this._updateChildrenInInsertedSubtree(child);
            child = child.getNextSibling();
        }
    }

    private void _updateChildrenInRemovedSubtree(Node node) {
        if (node == null) {
            return;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            this._moved.remove(child);
            this._changed.remove(child);
            this._added.remove(child);
            this._updateChildrenInRemovedSubtree(child);
            child = child.getNextSibling();
        }
    }

    private static Set _new() {
        return new HashSet(4);
    }

    private static Set _imm(Set s) {
        return Collections.unmodifiableSet(s);
    }

    private void $init$() {
        this._added = NCDImpl._new();
        this._changed = NCDImpl._new();
        this._removed = NCDImpl._new();
        this._moved = NCDImpl._new();
        this._elemToPriorAttrMap = new HashMap(4);
        this._nodeToPriorValue = new HashMap(4);
        this._addedImm = NCDImpl._imm(this._added);
        this._removedImm = NCDImpl._imm(this._removed);
        this._changedImm = NCDImpl._imm(this._changed);
        this._movedImm = NCDImpl._imm(this._moved);
    }

    static {
        $assertionsDisabled = NCDImpl.class.desiredAssertionStatus() ^ true;
    }

    void __processChange(ChangeRecord record) {
        if (!$assertionsDisabled && this._changedNodeTemp != null) {
            throw new AssertionError();
        }
        this._changedNodeTemp = record.getAssociatedNode();
        try {
            record.getChange().process(this);
        }
        finally {
            this._changedNodeTemp = null;
        }
    }

    public void handleAttrAddedChange(AttrAddedChange change) {
        this._attrValueChange((Attr)this._changedNodeTemp, NodeChangeDetails.UNSET_VALUE, change.getAddedAttributeClone().getValue());
    }

    public void handleAttrRemovedChange(AttrRemovedChange change) {
        this._attrValueChange((Attr)this._changedNodeTemp, change.getRemovedAttributeClone().getValue(), NodeChangeDetails.UNSET_VALUE);
    }

    public void handleAttrValueChange(AttrValueChange change) {
        this._attrValueChange((Attr)this._changedNodeTemp, change.getPrevValue(), change.getNewValue());
    }

    public void handleNodeInsertedChange(NodeInsertedChange change) {
        this._nodeInserted(this._changedNodeTemp);
    }

    public void handleNodeRemovedChange(NodeRemovedChange change) {
        this._nodeRemoved(this._changedNodeTemp);
    }

    public void handleNodeValueChange(NodeValueChange change) {
        this._nodeChanged(this._changedNodeTemp, change.getPrevValue());
    }
}

