/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.bali.xml.dom.impl.DomModelPlugin;
import oracle.bali.xml.dom.impl.DomModelPluginContext;
import oracle.bali.xml.dom.parser.TextSynchronizer;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.SimulateInsertingFragmentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;
import oracle.bali.xml.sax.StringCaptureXmlFilter;
import oracle.bali.xml.sax.TreeWalkerXmlReader;
import oracle.bali.xml.share.BaliXmlProvider;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ParserDomModel
extends DomModelPlugin {
    private volatile int _synchedChangeCount;
    private volatile boolean _forceSync;
    private volatile boolean _syncInProgress;
    private volatile boolean _needsInit;
    private TextSynchronizer _textSource;
    private final BaliXmlProvider _parser;
    private final ReadWriteLock _lock;

    public ParserDomModel(DomModelPluginContext context, BaliXmlProvider parser, TextSynchronizer textBuffer) {
        super(context);
        this.$init$();
        if (parser == null) {
            throw new IllegalArgumentException("No parser provided");
        }
        this._parser = parser;
        this._textSource = textBuffer;
    }

    public void setTextSynchronizer(TextSynchronizer textSynchronizer) {
        this._textSource = textSynchronizer;
        this._needsInit = true;
    }

    public DOMImplementation getDOMImplementation() {
        return this._parser.getDOMImplementation();
    }

    protected void handleCommittedDomChanges(DomChangesUndoableEdit domChanges) {
        this._syncToText();
    }

    protected void ensureDocumentAvailable() {
        if (this._needsInit) {
            this._needsInit = false;
            this._ensureDocUpToDate();
        }
    }

    public void postReplaceDocument(Document newDocument) {
        if (newDocument == null) {
            this._needsInit = true;
        }
    }

    public List getCurrentDomParseProblems() {
        return Collections.EMPTY_LIST;
    }

    public DomModel.FragmentParseResult parseFragment(Document document, Node contextNode, Map predefinedPrefixes, String text) {
        if (document != null) {
            StringBuffer buf = new StringBuffer(text.length() + 200);
            buf.append("<a");
            Map prefixes = NamespaceUtils.getPrefixesInScope(contextNode);
            prefixes.putAll(predefinedPrefixes);
            if (!prefixes.isEmpty()) {
                for (Map.Entry entry : prefixes.entrySet()) {
                    buf.append(" xmlns");
                    String key = (String)entry.getKey();
                    if (key.length() > 0) {
                        buf.append(':');
                        buf.append(key);
                    }
                    buf.append("=\"");
                    buf.append(entry.getValue());
                    buf.append("\"");
                }
            }
            buf.append(">");
            buf.append(text);
            buf.append("</a>");
            InputSource source = new InputSource(new StringReader(buf.toString()));
            try {
                Document tempDoc = this._parser.parseDocument(source);
                DocumentFragment fragment = document.createDocumentFragment();
                Node child = tempDoc.getDocumentElement().getFirstChild();
                while (child != null) {
                    Node imported = document.importNode(child, true);
                    fragment.appendChild(imported);
                    child = child.getNextSibling();
                }
                if (DomUtils.isElement((Node)contextNode)) {
                    SimulateInsertingFragmentTreeTraversal pretendTraversal = new SimulateInsertingFragmentTreeTraversal((Element)contextNode, fragment);
                    child = fragment.getFirstChild();
                    while (child != null) {
                        Node next = child.getNextSibling();
                        WhitespaceUtils.applyWhitespaceRulesToSubtree(this.getContext().getWhitespaceHandler(), (TreeTraversal)pretendTraversal, child);
                        child = next;
                    }
                }
                DomModel.FragmentParseResult fragmentParseResult = new DomModel.FragmentParseResult(fragment);
                return fragmentParseResult;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                LogUtils.log((Logger)this.getContext().getLogger(), (Level)Level.WARNING, (String)"Error parsing fragment:\n{0}\ncontext node: {1}", (Object[])new Object[]{text, contextNode}, (Throwable)t);
            }
        }
        return null;
    }

    protected UndoableEdit removeDocType() {
        throw new UnsupportedOperationException();
    }

    protected UndoableEdit setDocType(String qualifiedName, String publicId, String systemId) {
        throw new UnsupportedOperationException();
    }

    protected void refreshModel(boolean force) {
        if (force) {
            this._forceSync = true;
        }
        this._ensureDocUpToDate();
    }

    public boolean needsReparse() {
        return !this._syncInProgress && (this._forceSync || this._synchedChangeCount != this._textSource.getChangeId() || this._needsInit);
    }

    protected void acquireWriteLockDirectly() {
        this._lock.writeLock();
    }

    protected void releaseWriteLockDirectly() {
        this._lock.writeUnlock();
    }

    protected void acquireReadLockDirectly() {
        this._lock.readLock();
    }

    protected void releaseReadLockDirectly() {
        this._lock.readUnlock();
    }

    public int getLockStatus() {
        return this.getContext().getLockStatus(this._lock);
    }

    private void _ensureDocUpToDate() {
        if (this.needsReparse()) {
            this._forceSync = false;
            this._syncInProgress = true;
            this._synchedChangeCount = this._textSource.getChangeId();
            InputSource source = new InputSource();
            source.setSystemId(this._textSource.getSystemId());
            source.setCharacterStream(this._textSource.getReader());
            this.acquireWriteLockDirectly();
            try {
                try {
                    Document newDocument = this._parser.parseDocument(source);
                    WhitespaceUtils.applyWhitespaceRulesToSubtree(this.getContext().getWhitespaceHandler(), null, newDocument);
                    this.getContext().replaceDocument(newDocument);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.getContext().replaceDocument(null);
                }
            }
            finally {
                this._syncInProgress = false;
                this.releaseWriteLockDirectly();
            }
        }
    }

    public static Reader createXmlTextFromDocument(Document document, WhitespaceHandler wsHandler, String systemId, Logger logger) {
        String retString;
        TreeWalker treeWalker = DomUtils.createTreeWalker((Node)document, (int)-1, null, null);
        TreeWalkerXmlReader xmlReader = new TreeWalkerXmlReader(treeWalker);
        xmlReader.setNamespacePrefixesFeature(true);
        1 captureFilter = new 1((XMLReader)xmlReader, treeWalker, wsHandler);
        try {
            captureFilter.parse(systemId);
            retString = captureFilter.getXMLSource();
        }
        catch (Exception e) {
            retString = "<!-- Exception encountered producing text for Document: " + e + " -->";
            logger.log(Level.WARNING, "Exception encountered producing text for Document", e);
        }
        return new StringReader(retString);
    }

    private void _syncToText() {
        if (!this._syncInProgress) {
            this._syncInProgress = true;
            try {
                Reader newText = ParserDomModel.createXmlTextFromDocument(this.getContext().getDocument(), this.getContext().getWhitespaceHandler(), this._textSource.getSystemId(), this.getContext().getLogger());
                this._textSource.contentUpdated(newText, this._textSource.getSystemId());
            }
            finally {
                this._syncInProgress = false;
                this._synchedChangeCount = this._textSource.getChangeId();
            }
        }
    }

    private void $init$() {
        this._forceSync = true;
        this._syncInProgress = false;
        this._needsInit = true;
        this._lock = new ReadWriteLock();
    }

    static final class 1
    extends StringCaptureXmlFilter {
        private final /* synthetic */ TreeWalker v$treeWalker;
        private final /* synthetic */ WhitespaceHandler v$wsHandler;

        protected boolean putWhitespaceBeforeCurrent() {
            Node node = this.v$treeWalker.getCurrentNode();
            Node parent = node.getParentNode();
            if (DomUtils.isElement((Node)parent)) {
                WhitespaceMode mode = this.v$wsHandler.getElementContentWhitespaceMode(null, (Element)parent);
                return mode.allowsAddingExtraWhitespace(DomPositionFactory.before((Node)node));
            }
            return super.putWhitespaceBeforeCurrent();
        }

        protected boolean putWhitespaceInsideCurrent() {
            Element node = (Element)this.v$treeWalker.getCurrentNode();
            if (DomUtils.isElement((Node)node)) {
                WhitespaceMode mode = this.v$wsHandler.getElementContentWhitespaceMode(null, node);
                return Boolean.TRUE.equals(mode.allowsAddingExtraWhitespace(DomPositionFactory.inside((Node)node)));
            }
            return super.putWhitespaceInsideCurrent();
        }

        public 1(XMLReader xMLReader, TreeWalker treeWalker, WhitespaceHandler whitespaceHandler) {
            this.v$wsHandler = whitespaceHandler;
            this.v$treeWalker = treeWalker;
            super(xMLReader);
        }
    }
}

