/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.proxy;

import oracle.bali.xml.dom.util.DummyNode;
import oracle.bali.xml.dom.view.proxy.ViewNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ContainerViewNode
extends ViewNode {
    private Node _firstChild;
    private Node _lastChild;
    private int _childCount;
    private DeferredNodeList _nodeList;

    ContainerViewNode(Node proxiedNode) {
        super(proxiedNode);
        this.invalidateChildInfo();
    }

    protected void invalidateChildInfo() {
        this._firstChild = DummyNode.INSTANCE;
        this._lastChild = DummyNode.INSTANCE;
        this._childCount = -1;
        this._nodeList = null;
    }

    public NodeList getChildNodes() {
        if (this._nodeList == null) {
            this._nodeList = new DeferredNodeList(null);
        }
        return this._nodeList;
    }

    public Node getFirstChild() {
        if (this._firstChild == DummyNode.INSTANCE) {
            this._firstChild = this.getViewDocument().calculateFirstChild(this);
        }
        return this._firstChild;
    }

    public Node getLastChild() {
        if (this._lastChild == DummyNode.INSTANCE) {
            this._lastChild = this.getViewDocument().calculateLastChild(this);
        }
        return this._lastChild;
    }

    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    public Node cloneNode(boolean deep) {
        return this.getProxiedNode().cloneNode(deep);
    }

    private int _getChildCount() {
        if (this._childCount == -1) {
            int childCount = 0;
            Node currNode = this.getFirstChild();
            while (currNode != null) {
                ++childCount;
                currNode = currNode.getNextSibling();
            }
            this._childCount = childCount;
        }
        return this._childCount;
    }

    private Node _getChildAt(int index) {
        if (index < 0) {
            return null;
        }
        Node currNode = this.getFirstChild();
        while (currNode != null && index > 0) {
            currNode = currNode.getNextSibling();
            --index;
        }
        return currNode;
    }

    static int mav$_getChildCount(ContainerViewNode containerViewNode) {
        return containerViewNode._getChildCount();
    }

    static Node mav$_getChildAt(ContainerViewNode containerViewNode, int n) {
        return containerViewNode._getChildAt(n);
    }

    private class DeferredNodeList
    implements NodeList {
        public Node item(int index) {
            return ContainerViewNode.mav$_getChildAt(ContainerViewNode.this, index);
        }

        public int getLength() {
            return ContainerViewNode.mav$_getChildCount(ContainerViewNode.this);
        }

        private DeferredNodeList() {
        }

        DeferredNodeList(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

