/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.proxy;

import oracle.bali.xml.dom.view.proxy.ViewNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class ViewCharacterData
extends ViewNode
implements CharacterData {
    private static final String _UNSET_CHARACTER_DATA = new String("");
    private String _characterData;

    protected ViewCharacterData(Node proxiedNode) {
        super(proxiedNode);
        this.$init$();
    }

    public String getNodeValue() throws DOMException {
        if (this._characterData != _UNSET_CHARACTER_DATA) {
            return this._characterData;
        }
        CharacterData proxiedCharData = this.getProxiedCharacterData();
        if (proxiedCharData != null) {
            return proxiedCharData.getNodeValue();
        }
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this._characterData = nodeValue;
    }

    public final String getData() throws DOMException {
        return this.getNodeValue();
    }

    public void setData(String data) throws DOMException {
        throw new IllegalStateException();
    }

    public int getLength() {
        String data = this.getData();
        if (data != null) {
            return data.length();
        }
        return 0;
    }

    public String substringData(int offset, int count) throws DOMException {
        int stringLength;
        if (offset < 0) {
            throw new DOMException(1, "offset is negative");
        }
        if (count < 0) {
            throw new DOMException(1, "count is negative");
        }
        String data = this.getData();
        int n = stringLength = data != null ? data.length() : 0;
        if (offset > stringLength) {
            throw new DOMException(1, "offset exceeds length of string");
        }
        int endIndex = offset + count;
        if (endIndex > stringLength) {
            endIndex = stringLength;
        }
        if (data != null) {
            return data.substring(offset, endIndex);
        }
        return null;
    }

    public void appendData(String arg) throws DOMException {
        this._characterData = this.getData() + arg;
    }

    public void insertData(int offset, String arg) throws DOMException {
        throw this.getNoModificationException();
    }

    public void deleteData(int offset, int count) throws DOMException {
        throw this.getNoModificationException();
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        throw this.getNoModificationException();
    }

    protected CharacterData getProxiedCharacterData() {
        Node proxiedNode = this.getProxiedNode();
        if (proxiedNode instanceof CharacterData) {
            return (CharacterData)proxiedNode;
        }
        return null;
    }

    private void $init$() {
        this._characterData = _UNSET_CHARACTER_DATA;
    }
}

