/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.standalone;

import oracle.bali.xml.dom.util.DummyNode;
import oracle.bali.xml.dom.view.standalone.StandaloneNode;
import oracle.bali.xml.grammar.QualifiedName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class StandaloneContainerNode
extends StandaloneNode
implements NodeList {
    private QualifiedName _qName;
    private String _prefix;
    private Node _firstChild;
    private StandaloneNode _lastChild;
    private int _childCount;

    public StandaloneContainerNode(Document document, String namespaceURI, String prefix, String localName) {
        super(document);
        this.$init$();
        if (namespaceURI == null && prefix != null) {
            throw new IllegalArgumentException("No namespace provided for prefix:" + prefix);
        }
        if (localName == null) {
            throw new IllegalArgumentException("No local name specified");
        }
        this._qName = QualifiedName.getQualifiedName((String)namespaceURI, (String)localName);
        this._prefix = prefix;
    }

    public String getNodeName() {
        return this._qName.getQualifiedName();
    }

    public String getNamespaceURI() {
        return this._qName.getNamespace();
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String prefix) throws DOMException {
        if (prefix != null && this.getNamespaceURI() == null) {
            throw new IllegalArgumentException("No namespace provided for prefix:" + prefix);
        }
        this._prefix = prefix;
    }

    public String getLocalName() {
        return this._qName.getName();
    }

    public NodeList getChildNodes() {
        this.fireCreateChildren();
        return this;
    }

    public Node getFirstChild() {
        this.fireCreateChildren();
        return this._firstChild;
    }

    public Node getLastChild() {
        this.fireCreateChildren();
        return this._lastChild;
    }

    public Node item(int index) {
        if (index < 0) {
            return null;
        }
        int childCount = this.getLength();
        if (index >= childCount) {
            return null;
        }
        if (index > childCount / 2) {
            Node currChild = this._lastChild;
            index = childCount - index - 1;
            int i = 0;
            while (i < index) {
                currChild = currChild.getPreviousSibling();
                ++i;
            }
            return currChild;
        }
        Node currChild = this._firstChild;
        int i = 0;
        while (i < index) {
            currChild = currChild.getNextSibling();
            ++i;
        }
        return currChild;
    }

    public int getLength() {
        return this._childCount;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        StandaloneNode previousSibling;
        StandaloneNode refChildNode;
        if (refChild != null && this != refChild.getParentNode()) {
            throw new DOMException(3, refChild + " is not a child of " + this);
        }
        if (newChild.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DOMException(4, newChild + " is not in the same document as " + this);
        }
        if (refChild == null) {
            this.fireCreateChildren();
        }
        this._checkModifications();
        StandaloneNode childNode = (StandaloneNode)newChild;
        StandaloneContainerNode oldParent = childNode.getInternalParentNode();
        if (oldParent != null) {
            oldParent.removeChild(childNode);
        }
        if (this._firstChild == refChild) {
            this._firstChild = childNode;
        }
        if ((refChildNode = (StandaloneNode)refChild) != null) {
            previousSibling = refChildNode.getInternalPreviousSibling();
            refChildNode.setPreviousSibling(childNode);
        } else {
            previousSibling = this._lastChild;
            this._lastChild = childNode;
        }
        if (previousSibling != null) {
            previousSibling.setNextSibling(childNode);
        }
        childNode.setPreviousSibling(previousSibling);
        childNode.setNextSibling(refChildNode);
        childNode.setParentNode(this);
        ++this._childCount;
        return newChild;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (this != oldChild.getParentNode()) {
            throw new DOMException(8, oldChild + " is not a child of " + this);
        }
        this._checkModifications();
        StandaloneNode childNode = (StandaloneNode)oldChild;
        StandaloneNode previousSibling = childNode.getInternalPreviousSibling();
        StandaloneNode nextSibling = childNode.getInternalNextSibling();
        if (this._firstChild == childNode) {
            this._firstChild = nextSibling;
        }
        if (this._lastChild == childNode) {
            this._lastChild = previousSibling;
        }
        if (previousSibling != null) {
            previousSibling.setNextSibling(nextSibling);
        }
        if (nextSibling != null) {
            nextSibling.setPreviousSibling(previousSibling);
        }
        --this._childCount;
        childNode.reset();
        return childNode;
    }

    protected boolean allowsModification() {
        return true;
    }

    private void _checkModifications() {
        if (!this.allowsModification()) {
            throw new DOMException(7, "No modifications allowed to " + this);
        }
    }

    public String toString() {
        return super.toString() + ", qualifiedName " + this._qName + ", prefix " + this._prefix;
    }

    protected final void fireCreateChildren() {
        if (this._firstChild == DummyNode.INSTANCE) {
            this._firstChild = null;
            this.createChildren();
        }
    }

    protected void createChildren() {
    }

    private void $init$() {
        this._firstChild = DummyNode.INSTANCE;
        this._lastChild = null;
        this._childCount = 0;
    }
}

