/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.standalone;

import java.util.HashMap;
import oracle.bali.xml.dom.MapNamedNodeMap;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.view.standalone.StandaloneAttr;
import oracle.bali.xml.dom.view.standalone.StandaloneContainerNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class StandaloneElement
extends StandaloneContainerNode
implements Element {
    private NamedNodeMap _attrMap;

    public StandaloneElement(Document document, String namespaceURI, String prefix, String localName) {
        super(document, namespaceURI, prefix, localName);
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        if (nodeValue != null) {
            throw new DOMException(7, "Elements can not have node values");
        }
    }

    public short getNodeType() {
        return 1;
    }

    public final String getTagName() {
        return this.getNodeName();
    }

    public String getAttribute(String name) {
        Attr attributeNode = this.getAttributeNode(name);
        if (attributeNode != null) {
            return attributeNode.getNodeValue();
        }
        return "";
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.setAttributeNS(null, name, value);
    }

    public void removeAttribute(String name) throws DOMException {
        this.removeAttributeNS(null, name);
    }

    public Attr getAttributeNode(String name) {
        NamedNodeMap attributes = this.getAttributes();
        if (attributes != null) {
            return (Attr)attributes.getNamedItem(name);
        }
        return null;
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return this.setAttributeNodeNS(newAttr);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (oldAttr != null) {
            NamedNodeMap attributes = this.getAttributes();
            if (attributes == null) {
                throw new DOMException(8, oldAttr + " is not an attribute of " + this);
            }
            return (Attr)attributes.removeNamedItemNS(oldAttr.getNamespaceURI(), DomUtils.getLocalName((Node)oldAttr));
        }
        return null;
    }

    public NodeList getElementsByTagName(String name) {
        return this.getElementsByTagNameNS("*", name);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return "";
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        int separatorIndex = qualifiedName.indexOf(58);
        String prefix = null;
        String localName = qualifiedName;
        if (separatorIndex != -1 && separatorIndex != 0) {
            prefix = qualifiedName.substring(0, separatorIndex);
            if (namespaceURI == null) {
                throw new DOMException(14, "Can't set attribute prefix to " + prefix + " and have no namespace");
            }
            if (prefix.equals("xml") && !namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                throw new DOMException(14, "The 'xml' prefix must have the 'http://www.w3.org/XML/1998/namespace' namespace, not " + namespaceURI);
            }
            if (prefix.equals("xmlns") && !namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                throw new DOMException(14, "The 'xmlns' prefix must have the 'http://www.w3.org/2000/xmlns/' namespace, not " + namespaceURI);
            }
            localName = separatorIndex != qualifiedName.length() - 1 ? qualifiedName.substring(separatorIndex + 1) : "";
        }
        StandaloneAttr attr = new StandaloneAttr(this.getOwnerDocument(), namespaceURI, prefix, localName);
        attr.setParentNode(this);
        attr.setNodeValue(value);
        this.setAttributeNodeNS(attr);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attr removeAttr = this.getAttributeNodeNS(namespaceURI, localName);
        if (removeAttr != null) {
            this.removeAttributeNode(removeAttr);
        }
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        NamedNodeMap attributes = this.getAttributes();
        if (attributes != null) {
            return (Attr)attributes.getNamedItemNS(namespaceURI, localName);
        }
        return null;
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        NamedNodeMap attributes = this.getAttributes();
        return (Attr)attributes.setNamedItemNS(newAttr);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        this.fireCreateChildren();
        return null;
    }

    public boolean hasAttribute(String name) {
        return this.hasAttributeNS(null, name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        NamedNodeMap attributes = this.getAttributes();
        if (attributes != null) {
            return attributes.getNamedItemNS(namespaceURI, localName) != null;
        }
        return false;
    }

    public final NamedNodeMap getAttributes() {
        if (this._attrMap == null) {
            this._attrMap = this.createAttrMap();
        }
        return this._attrMap;
    }

    public boolean hasAttributes() {
        NamedNodeMap attributes = this.getAttributes();
        if (attributes != null) {
            return this.getAttributes().getLength() != 0;
        }
        return false;
    }

    protected NamedNodeMap createAttrMap() {
        return new MapNamedNodeMap(this, new HashMap(7));
    }

    public TypeInfo getSchemaTypeInfo() {
        this.__nyi();
        return null;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        this.__nyi();
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        this.__nyi();
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        this.__nyi();
    }
}

