/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.whitespace;

import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceResult;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;

public final class CollapseWhitespaceMode
extends WhitespaceMode {
    protected CollapseWhitespaceMode() {
        super("collapse");
    }

    public Boolean allowsAddingExtraWhitespace(DomPosition pos) {
        return Boolean.TRUE;
    }

    protected WhitespaceResult applyImpl(String input) {
        return CollapseWhitespaceMode.__doApply(input, true);
    }

    static WhitespaceResult __doApply(String input, boolean shouldTrimEnds) {
        WhitespaceResult result = new WhitespaceResult();
        boolean didAnything = false;
        int trimmedStart = WhitespaceUtils.getTrimmedStart(input);
        int i = 0;
        while (i < trimmedStart) {
            if (shouldTrimEnds || i < trimmedStart - 1) {
                didAnything = true;
                result.markSingleWhitespaceChar();
            } else {
                if (input.charAt(i) != ' ') {
                    didAnything = true;
                }
                result.appendToValue(' ');
            }
            ++i;
        }
        int trimmedEnd = shouldTrimEnds ? WhitespaceUtils.getTrimmedEnd(input, trimmedStart) : input.length();
        boolean lastWasWhitespace = false;
        int i2 = trimmedStart;
        while (i2 < trimmedEnd) {
            char c = input.charAt(i2);
            if (WhitespaceUtils.isXmlWhitespaceChar(c)) {
                if (lastWasWhitespace) {
                    didAnything = true;
                    result.markSingleWhitespaceChar();
                } else {
                    if (c != ' ') {
                        didAnything = true;
                    }
                    result.appendToValue(' ');
                }
                lastWasWhitespace = true;
            } else {
                result.appendToValue(c);
                lastWasWhitespace = false;
            }
            ++i2;
        }
        int i3 = trimmedEnd;
        while (i3 < input.length()) {
            result.markSingleWhitespaceChar();
            didAnything = true;
            ++i3;
        }
        if (didAnything) {
            return result;
        }
        return null;
    }
}

