/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.whitespace;

import java.util.BitSet;

public final class WhitespaceResult {
    private int _totalLength;
    private final BitSet _whitespaceBits;
    private final StringBuffer _valueBuf;

    public void appendToValue(char c) {
        this._valueBuf.append(c);
        this._appendToValue(1);
    }

    public void appendToValue(String s) {
        if (s.length() > 0) {
            this._valueBuf.append(s);
            this._appendToValue(s.length());
        }
    }

    public void markSingleWhitespaceChar() {
        this._whitespaceBits.set(this._totalLength);
        ++this._totalLength;
    }

    public BitSet getWhitespaceBitSet() {
        return this._whitespaceBits;
    }

    public int getTotalLength() {
        return this._totalLength;
    }

    public boolean hasNoWhitespace() {
        return this._whitespaceBits.isEmpty();
    }

    public boolean isEmpty() {
        return this._valueBuf.length() == 0;
    }

    public String getValue() {
        return this._valueBuf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        WhitespaceResult oResult = (WhitespaceResult)o;
        boolean valueOK = this.getValue().equals(oResult.getValue());
        boolean wsOK = this._whitespaceBits.equals(oResult._whitespaceBits);
        return valueOK && wsOK;
    }

    public String toString() {
        return "[" + this._valueBuf + "] ws=" + this._whitespaceBits;
    }

    private void _appendToValue(int size) {
        this._totalLength += size;
    }

    private void $init$() {
        this._totalLength = 0;
        this._whitespaceBits = new BitSet();
        this._valueBuf = new StringBuffer();
    }

    public WhitespaceResult() {
        this.$init$();
    }
}

