/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.whitespace;

import java.util.LinkedList;
import java.util.List;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhitespaceUtils {
    public static void applyWhitespaceRulesToSubtree(WhitespaceHandler handler, TreeTraversal traversal, Node node) {
        if (node == null) {
            return;
        }
        traversal = WhitespaceUtils._trav(traversal);
        Node child = traversal.getFirstChild(node);
        while (child != null) {
            Node next = traversal.getNextSibling(child);
            WhitespaceUtils.applyWhitespaceRulesToSubtree(handler, traversal, child);
            child = next;
        }
        switch (node.getNodeType()) {
            case 1: {
                WhitespaceUtils.applyWhitespaceRulesToAttributes(handler, traversal, (Element)node);
                break;
            }
            case 3: {
                Node parent = traversal.getParentNode(node);
                if (parent.getNodeType() != 1) break;
                WhitespaceUtils.applyWhitespaceRulesToTextNode(handler, traversal, (Element)parent, (Text)node);
                break;
            }
        }
    }

    public static void applyWhitespaceRulesToTextNode(WhitespaceHandler handler, TreeTraversal traversal, Element owningElement, Text node) {
        String origValue;
        WhitespaceMode mode = handler.getElementContentWhitespaceMode(traversal, owningElement);
        WhitespaceResult result = mode.apply(origValue = node.getNodeValue());
        if (result != null) {
            if (result.isEmpty()) {
                Node realParent = node.getParentNode();
                if (realParent != null) {
                    realParent.removeChild(node);
                }
            } else {
                node.setNodeValue(result.getValue());
            }
        }
    }

    public static void applyWhitespaceRulesToAttributes(WhitespaceHandler handler, TreeTraversal traversal, Element owningElement) {
        NamedNodeMap attrs = owningElement.getAttributes();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                WhitespaceUtils.applyWhitespaceRulesToAttribute(handler, traversal, owningElement, (Attr)attrs.item(i));
                ++i;
            }
        }
    }

    public static void applyWhitespaceRulesToAttribute(WhitespaceHandler handler, TreeTraversal traversal, Element owningElement, Attr attr) {
        String origValue;
        WhitespaceMode mode = handler.getAttributeContentWhitespaceMode(traversal, owningElement, attr);
        WhitespaceResult result = mode.apply(origValue = attr.getValue());
        if (result != null) {
            attr.setValue(result.getValue());
        }
    }

    public static boolean isXmlWhitespaceChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean nothingToCollapse(String input) {
        boolean lastWasWhitespace = false;
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == ' ') {
                if (lastWasWhitespace) {
                    return false;
                }
                lastWasWhitespace = true;
            } else {
                if (WhitespaceUtils.isXmlWhitespaceChar(c)) {
                    return false;
                }
                lastWasWhitespace = false;
            }
            ++i;
        }
        return true;
    }

    public static boolean hasAnyNonSpaceWhitespace(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static int getTrimmedStart(String characters) {
        int start = 0;
        int end = characters.length();
        while (start < end && WhitespaceUtils.isXmlWhitespaceChar(characters.charAt(start))) {
            ++start;
        }
        return start;
    }

    public static int getTrimmedEnd(String characters, int start) {
        int end = characters.length();
        while (start < end && WhitespaceUtils.isXmlWhitespaceChar(characters.charAt(end - 1))) {
            --end;
        }
        return end;
    }

    public static List<int[]> getTokenBoundaries(CharSequence tokens) {
        LinkedList<int[]> ret = new LinkedList<int[]>();
        int index = 0;
        int curStartIndex = 0;
        int length = tokens.length();
        while (index < length) {
            char c = tokens.charAt(index);
            if (WhitespaceUtils.isXmlWhitespaceChar(c)) {
                if (index > curStartIndex) {
                    ret.add(new int[]{curStartIndex, index});
                }
                curStartIndex = index + 1;
            }
            ++index;
        }
        if (index > curStartIndex) {
            ret.add(new int[]{curStartIndex, index});
        }
        return ret;
    }

    private static TreeTraversal _trav(TreeTraversal in) {
        if (in == null) {
            return DocumentTreeTraversal.INSTANCE;
        }
        return in;
    }

    private WhitespaceUtils() {
    }
}

