/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.explorer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DebugTreeModel
implements TreeModel,
TreeModelListener {
    private final TreeModel _base;
    private final List _recent;
    private static final int _MAX_RECENT = 10;

    public DebugTreeModel(TreeModel base) {
        this.$init$();
        this._base = base;
        this._base.addTreeModelListener(this);
    }

    public Object getRoot() {
        Object got = this._base.getRoot();
        this._log("root", got);
        return got;
    }

    public int getChildCount(Object object) {
        int got = this._base.getChildCount(object);
        this._log("getChildCount", object, Integer.toString(got));
        return got;
    }

    public boolean isLeaf(Object object) {
        boolean got = this._base.isLeaf(object);
        this._log("isLeaf", object, got);
        return got;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this._base.addTreeModelListener(treeModelListener);
        this._log("addTreeModelListener", treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this._base.removeTreeModelListener(treeModelListener);
        this._log("removeTreeModelListener", treeModelListener);
    }

    public Object getChild(Object object, int i) {
        Object got = this._base.getChild(object, i);
        this._log("getChild", object, Integer.toString(i), got);
        return got;
    }

    public int getIndexOfChild(Object object, Object object1) {
        int got = this._base.getIndexOfChild(object, object1);
        this._log("getIndexOfChild", object, object1, Integer.toString(got));
        return got;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        this._base.valueForPathChanged(treePath, object);
        this._log("valueForPathChanged", treePath, object);
    }

    private void _log(Object what, Object param1, Object got) {
        this._log(what + "(" + param1 + "): " + got);
    }

    private void _log(Object what, Object param1, Object param2, Object got) {
        this._log(what + "(" + param1 + ", " + param2 + "): " + got);
    }

    private void _log(Object what, Object got) {
        this._log(what + ": " + got);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _log(Object msg) {
        if (msg == null) {
            return;
        }
        msg = msg.toString();
        List list = this._recent;
        synchronized (list) {
            System.out.println("TREE: " + msg);
            this._recent.add(0, msg);
            while (this._recent.size() > 10) {
                this._recent.remove(this._recent.size() - 1);
            }
        }
    }

    private void $init$() {
        this._recent = new ArrayList();
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this._log("treeNodesChanged", treeModelEvent);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this._log("treeNodesInserted", treeModelEvent);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this._log("treeNodesRemoved", treeModelEvent);
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this._log("treeStructureChanged", treeModelEvent);
    }
}

