/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.explorer;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.xml.gui.base.explorer.BaseExplorerGui;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.bali.xml.share.UnmodifiableArrayList;
import oracle.bali.xml.util.XmlModelUtils;
import org.w3c.dom.Node;

final class XmlTreeSelectionModel
implements TreeSelectionModel {
    private LinkedHashSet _pendingAddPaths;
    private LinkedHashSet _pendingRemovePaths;
    private TreePath _leadSelectionPath;
    private boolean _processingModelChange;
    private final LinkedHashSet _selectedPaths;
    private boolean _rowInfoDirty;
    private int _leadSelectionRow;
    private int[] _selectedRows;
    private int _minSelectionRow;
    private int _maxSelectionRow;
    private final BitSet _isRowSelectedBitSet;
    private RowMapper _rowMapper;
    private final BaseExplorerGui _gui;
    private final SafeListenerManager _selectionListeners;
    private static final Logger _LOGGER = Logger.getLogger(XmlTreeSelectionModel.class.getName());

    public XmlTreeSelectionModel(BaseExplorerGui gui) {
        this.$init$();
        this._gui = gui;
    }

    public void setSelectionMode(int newMode) {
        if (newMode != 4) {
            throw new UnsupportedOperationException(this.getClass() + " only supports discontinuous selection mode!");
        }
    }

    public int getSelectionMode() {
        return 4;
    }

    public void setSelectionPath(TreePath path) {
        if (path == null) {
            this.clearSelection();
        } else {
            this._gui.ensureActiveGuiAcquired();
            this._setSelectionFromTree(this._list(path));
        }
    }

    public void setSelectionPaths(TreePath[] paths) {
        if (paths == null || paths.length == 0) {
            this.clearSelection();
        } else {
            this._setSelectionFromTree(this._list(paths));
        }
    }

    public void addSelectionPath(TreePath path) {
        if (path != null) {
            this._addSelectionPaths(this._list(path));
        }
    }

    public void addSelectionPaths(TreePath[] paths) {
        if (paths != null && paths.length > 0) {
            this._addSelectionPaths(this._list(paths));
        }
    }

    public void removeSelectionPath(TreePath path) {
        if (path != null) {
            this._changeSelectionFromTree(Collections.EMPTY_LIST, this._list(path), false);
        }
    }

    public void removeSelectionPaths(TreePath[] paths) {
        if (paths != null && paths.length > 0) {
            this._changeSelectionFromTree(Collections.EMPTY_LIST, this._list(paths), false);
        }
    }

    public TreePath getSelectionPath() {
        if (this._selectedPaths.isEmpty()) {
            return null;
        }
        return (TreePath)this._selectedPaths.iterator().next();
    }

    public TreePath[] getSelectionPaths() {
        TreePath[] ret = new TreePath[this._selectedPaths.size()];
        ret = this._selectedPaths.toArray(ret);
        return ret;
    }

    public int getSelectionCount() {
        return this._selectedPaths.size();
    }

    public boolean isPathSelected(TreePath path) {
        return this._selectedPaths.contains(path);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionCount() == 0;
    }

    public void clearSelection() {
        this._changeSelectionFromTree(Collections.EMPTY_LIST, Collections.EMPTY_LIST, true);
    }

    public void setRowMapper(RowMapper newMapper) {
        this._rowMapper = newMapper;
        this._markRowInfoDirty();
    }

    public RowMapper getRowMapper() {
        return this._rowMapper;
    }

    public int[] getSelectionRows() {
        this._ensureRowInfoUpToDate();
        if (this._selectedRows == null) {
            return null;
        }
        return (int[])this._selectedRows.clone();
    }

    public int getMinSelectionRow() {
        this._ensureRowInfoUpToDate();
        return this._minSelectionRow;
    }

    public int getMaxSelectionRow() {
        this._ensureRowInfoUpToDate();
        return this._maxSelectionRow;
    }

    public boolean isRowSelected(int row) {
        this._ensureRowInfoUpToDate();
        boolean value = row < 0 ? false : this._isRowSelectedBitSet.get(row);
        return value;
    }

    public void resetRowSelection() {
        this._markRowInfoDirty();
    }

    public int getLeadSelectionRow() {
        this._ensureRowInfoUpToDate();
        return this._leadSelectionRow;
    }

    public TreePath getLeadSelectionPath() {
        return this._leadSelectionPath;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public void addTreeSelectionListener(TreeSelectionListener x) {
        this._selectionListeners.addListener(x);
    }

    public void removeTreeSelectionListener(TreeSelectionListener x) {
        this._selectionListeners.removeListener(x, false);
    }

    void __initializeFromView() {
        XmlTreeModel treeModel = this._treeModel();
        XmlView view = this._gui.getView();
        view.acquireReadLock();
        try {
            Iterator<Node> nodeItor = view.getSelection().getSelectedNodes();
            while (nodeItor.hasNext()) {
                Node node = nodeItor.next();
                TreePath path = treeModel.getPathForDomElement(node);
                if (path == null) continue;
                this._selectedPaths.add(path);
            }
        }
        finally {
            view.releaseReadLock();
        }
        this._updateLeadPath();
        this._markRowInfoDirty();
    }

    void __handleEventBeforeTreeModel(XmlModelEvent event) {
        this._processingModelChange = true;
        if (this._modelEventMatters(event)) {
            this._clearSelectionDirectly();
        }
    }

    void __handleEventAfterTreeModel(XmlModelEvent event) {
        try {
            if (!this._modelEventMatters(event)) {
                return;
            }
            Selection sel = this._gui.getView().getSelection();
            if (!sel.isEmpty()) {
                Iterator<Node> nodeItor = sel.getSelectedNodes();
                LinkedList<TreePath> pathsToAdd = new LinkedList<TreePath>();
                while (nodeItor.hasNext()) {
                    Node node = nodeItor.next();
                    TreePath nodePath = this._treeModel().getPathForDomElement(node);
                    if (nodePath == null) continue;
                    pathsToAdd.add(nodePath);
                }
                if (!pathsToAdd.isEmpty()) {
                    if (this._pendingAddPaths != null) {
                        this._pendingAddPaths.addAll(pathsToAdd);
                    } else {
                        this._updateAndDeliverChangeFromXmlModel(pathsToAdd, true);
                    }
                }
            }
        }
        finally {
            this._processingModelChange = false;
        }
    }

    private boolean _modelEventMatters(XmlModelEvent event) {
        return event.matchesFlags(223);
    }

    private XmlTreeModel _treeModel() {
        return this._gui.getTreeModel();
    }

    private void _addSelectionPaths(List paths) {
        boolean shouldClear = this._selectedPaths.isEmpty();
        this._changeSelectionFromTree(paths, Collections.EMPTY_LIST, shouldClear);
    }

    private void _clearSelectionDirectly() {
        if (this._selectedPaths.isEmpty()) {
            return;
        }
        TreePath[] paths = this.getSelectionPaths();
        TreePath oldLead = this.getLeadSelectionPath();
        this._selectedPaths.clear();
        this._updateLeadPath();
        this._markRowInfoDirty();
        if (!this._selectionListeners.isEmpty()) {
            TreeSelectionEvent event = new TreeSelectionEvent((Object)this, paths, this._boolArray(paths.length, false), oldLead, null);
            this._fireEvent(event);
        }
    }

    private boolean[] _boolArray(int size, boolean value) {
        boolean[] ret = new boolean[size];
        Arrays.fill(ret, value);
        return ret;
    }

    private void _setSelectionFromTree(List listToSet) {
        this._changeSelectionFromTree(listToSet, new ArrayList(this._selectedPaths), true);
    }

    private void _changeSelectionFromTree(List pathsToAddList, List pathsToRemoveList, boolean clearSelection) {
        if (this._processingModelChange) {
            return;
        }
        if (pathsToAddList.isEmpty() && pathsToRemoveList.isEmpty()) {
            return;
        }
        XmlView view = this._gui.getView();
        view.acquireReadLock();
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "TreeSelModel updating from tree: toAdd={0} toRemove={1} beforeSelected={2}", new Object[]{this._dbg(pathsToAddList), this._dbg(pathsToRemoveList), this._dbg(this._selectedPaths)});
        }
        boolean canChangeDom = false;
        try {
            canChangeDom = view.getDocument() != null;
        }
        finally {
            view.releaseReadLock();
        }
        if (canChangeDom) {
            new 1(this, pathsToAddList, pathsToRemoveList, clearSelection).run(view);
        } else {
            this._doChangeDirectlyAndCalculatePendingPaths(pathsToAddList, pathsToRemoveList, false, clearSelection);
        }
        int numChangedPaths = this._pendingAddPaths.size() + this._pendingRemovePaths.size();
        if (numChangedPaths == 0) {
            this._pendingAddPaths = null;
            this._pendingRemovePaths = null;
            return;
        }
        TreePath oldLead = this.getLeadSelectionPath();
        TreePath[] changedPaths = new TreePath[numChangedPaths];
        boolean[] isAddedPath = new boolean[numChangedPaths];
        int i = 0;
        Iterator addItor = this._pendingAddPaths.iterator();
        while (addItor.hasNext()) {
            TreePath path;
            changedPaths[i] = path = (TreePath)addItor.next();
            isAddedPath[i] = true;
            ++i;
        }
        Iterator removeItor = this._pendingRemovePaths.iterator();
        while (removeItor.hasNext()) {
            TreePath path;
            changedPaths[i] = path = (TreePath)removeItor.next();
            isAddedPath[i] = false;
            ++i;
        }
        this._selectedPaths.addAll(this._pendingAddPaths);
        this._selectedPaths.removeAll(this._pendingRemovePaths);
        this._pendingAddPaths = null;
        this._pendingRemovePaths = null;
        this._updateLeadPath();
        this._markRowInfoDirty();
        if (!this._selectionListeners.isEmpty()) {
            TreeSelectionEvent event = new TreeSelectionEvent((Object)this, changedPaths, isAddedPath, oldLead, this.getLeadSelectionPath());
            this._fireEvent(event);
        }
    }

    private void _doChangeDirectlyAndCalculatePendingPaths(List pathsToAddList, List pathsToRemoveList, boolean canChangeDom, boolean clearSelection) {
        this._pendingAddPaths = new LinkedHashSet();
        this._pendingRemovePaths = new LinkedHashSet();
        Iterator pathsToAdd = pathsToAddList.iterator();
        Iterator pathsToRemove = pathsToRemoveList.iterator();
        XmlView view = this._gui.getView();
        Selection selection = view.getSelection();
        XmlTreeModel treeModel = this._treeModel();
        if (canChangeDom && clearSelection) {
            selection.clear();
        }
        while (pathsToRemove.hasNext()) {
            TreePath path = (TreePath)pathsToRemove.next();
            if (!this._selectedPaths.contains(path)) continue;
            Node node = treeModel.pathToSourceDom(path);
            if (node == null) {
                this._pendingRemovePaths.add(path);
                continue;
            }
            if (!canChangeDom || clearSelection) continue;
            selection.remove(node);
        }
        while (pathsToAdd.hasNext()) {
            TreePath path = (TreePath)pathsToAdd.next();
            Node node = treeModel.pathToSourceDom(path);
            if (node == null) {
                this._pendingRemovePaths.remove(path);
                this._pendingAddPaths.add(path);
                continue;
            }
            if (!canChangeDom) continue;
            selection.add(node);
        }
    }

    private void _ensureRowInfoUpToDate() {
        if (this._rowInfoDirty) {
            this._rowInfoDirty = false;
            if (this._rowMapper != null) {
                TreePath[] selectedPaths = this.getSelectionPaths();
                this._selectedRows = this._rowMapper.getRowsForPaths(selectedPaths);
                int minusOneCount = 0;
                int i = 0;
                while (i < this._selectedRows.length) {
                    int cur = this._selectedRows[i];
                    if (this._leadSelectionPath == selectedPaths[i]) {
                        this._leadSelectionRow = cur;
                    }
                    if (cur == -1) {
                        ++minusOneCount;
                    } else {
                        if (i == 0) {
                            this._minSelectionRow = cur;
                            this._maxSelectionRow = cur;
                        } else {
                            this._minSelectionRow = Math.min(this._minSelectionRow, cur);
                            this._maxSelectionRow = Math.max(this._maxSelectionRow, cur);
                        }
                        this._isRowSelectedBitSet.set(cur);
                    }
                    ++i;
                }
                if (minusOneCount > 0) {
                    this._selectedRows = this._removeMinusOnes(this._selectedRows, minusOneCount);
                }
            }
        }
    }

    private int[] _removeMinusOnes(int[] input, int minusOneCount) {
        int fixedSize = input.length - minusOneCount;
        if (fixedSize == 0) {
            return null;
        }
        int[] fixed = new int[fixedSize];
        int fixedIndex = 0;
        int i = 0;
        while (i < this._selectedRows.length) {
            int cur = input[i];
            if (cur != -1) {
                fixed[fixedIndex] = cur;
                ++fixedIndex;
            }
            ++i;
        }
        return fixed;
    }

    private void _markRowInfoDirty() {
        if (!this._rowInfoDirty) {
            this._rowInfoDirty = true;
            this._selectedRows = null;
            this._leadSelectionRow = -1;
            this._minSelectionRow = -1;
            this._maxSelectionRow = -1;
            this._isRowSelectedBitSet.clear();
        }
    }

    private void _updateLeadPath() {
        this._leadSelectionPath = null;
        TreePath[] selectedPaths = this.getSelectionPaths();
        if (selectedPaths != null && selectedPaths.length != 0) {
            int leadIndex = selectedPaths.length - 1;
            this._leadSelectionPath = selectedPaths[leadIndex];
        }
    }

    private void _updateAndDeliverChangeFromXmlModel(List changedPaths, boolean isAdd) {
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "TreeSelModel updating from model: changedPath={0} isAdd={1} oldPaths={2}", new Object[]{this._dbg(changedPaths), isAdd, this._dbg(this._selectedPaths)});
        }
        TreePath oldLead = this.getLeadSelectionPath();
        if (isAdd) {
            this._selectedPaths.addAll(changedPaths);
        } else {
            this._selectedPaths.removeAll(changedPaths);
        }
        this._updateLeadPath();
        this._markRowInfoDirty();
        if (!this._selectionListeners.isEmpty()) {
            TreePath[] pathArray = new TreePath[changedPaths.size()];
            pathArray = changedPaths.toArray(pathArray);
            TreeSelectionEvent event = new TreeSelectionEvent((Object)this, pathArray, this._boolArray(pathArray.length, isAdd), oldLead, this.getLeadSelectionPath());
            this._fireEvent(event);
        }
    }

    private void _fireEvent(TreeSelectionEvent event) {
        if (!this._selectionListeners.isEmpty()) {
            if (_LOGGER.isLoggable(Level.FINER)) {
                XmlView view = this._gui.getView();
                view.acquireReadLock();
                _LOGGER.log(Level.FINER, "Delivering event: gui={0} paths={1}", new Object[]{this._gui, this._dbg(event.getPaths())});
                view.releaseReadLock();
            }
            Iterator itor = this._selectionListeners.iterator();
            while (itor.hasNext()) {
                TreeSelectionListener l = (TreeSelectionListener)itor.next();
                try {
                    l.valueChanged(event);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    _LOGGER.log(Level.SEVERE, "Exception notifying tree selection listener " + l + " of event " + event, t);
                }
            }
        }
    }

    private List _list(TreePath path) {
        return Collections.singletonList(path);
    }

    private List _list(TreePath[] paths) {
        return new UnmodifiableArrayList<TreePath>(paths);
    }

    private StringBuffer _dbg(Collection col) {
        Iterator itor = col.iterator();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        while (itor.hasNext()) {
            TreePath path = (TreePath)itor.next();
            Object val = path.getLastPathComponent();
            if (val instanceof Node) {
                val = XmlModelUtils.getDisplayName(this._gui.getView(), (Node)val);
            }
            buf.append(val);
            if (!itor.hasNext()) continue;
            buf.append(" ");
        }
        buf.append("]");
        return buf;
    }

    private StringBuffer _dbg(TreePath[] array) {
        return this._dbg(new UnmodifiableArrayList<TreePath>(array));
    }

    private void $init$() {
        this._pendingAddPaths = null;
        this._pendingRemovePaths = null;
        this._leadSelectionPath = null;
        this._processingModelChange = false;
        this._selectedPaths = new LinkedHashSet();
        this._rowInfoDirty = true;
        this._leadSelectionRow = -1;
        this._minSelectionRow = -1;
        this._maxSelectionRow = -1;
        this._isRowSelectedBitSet = new BitSet();
        this._rowMapper = null;
        this._selectionListeners = new SafeListenerManager();
    }

    static void mav$_doChangeDirectlyAndCalculatePendingPaths(XmlTreeSelectionModel xmlTreeSelectionModel, List list, List list2, boolean bl, boolean bl2) {
        xmlTreeSelectionModel._doChangeDirectlyAndCalculatePendingPaths(list, list2, bl, bl2);
    }

    final class 1
    extends NonDomMutationTransactionTask {
        private final /* synthetic */ List v$pathsToAddList;
        private final /* synthetic */ List v$pathsToRemoveList;
        private final /* synthetic */ boolean v$clearSelection;
        final /* synthetic */ XmlTreeSelectionModel this$0;

        protected void performTask(AbstractModel model) {
            XmlTreeSelectionModel.mav$_doChangeDirectlyAndCalculatePendingPaths(this.this$0, this.v$pathsToAddList, this.v$pathsToRemoveList, true, this.v$clearSelection);
        }

        public 1(XmlTreeSelectionModel xmlTreeSelectionModel, List list, List list2, boolean bl) {
            this.v$clearSelection = bl;
            this.v$pathsToRemoveList = list2;
            this.v$pathsToAddList = list;
            this.this$0 = xmlTreeSelectionModel;
        }
    }
}

