/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.beans.PropertyEditor;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.share.beans.JavaPropertyEditorManager;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.util.AttributeValueUtils;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.gui.base.inspector.AttributeValueItemPropertyEditor;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.EnumeratedValuesInfo;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.gui.base.inspector.XmlPropertyId;
import oracle.bali.xml.model.annotation.AnnotationGrammar;
import oracle.bali.xml.model.annotation.AnnotationMetadataResolver;
import oracle.bali.xml.model.annotation.AnnotationProperty;
import oracle.bali.xml.model.annotation.AnnotationPropertyDef;
import oracle.bali.xml.model.annotation.AnnotationProvider;
import oracle.bali.xml.model.annotation.InvalidAnnotationException;
import oracle.bali.xml.util.AttributeValueItem;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationPropertyRow
extends PropertyRow {
    private final QualifiedName _qualifiedName;
    private final AnnotationProvider _provider;
    private final AnnotationPropertyDef _propertyDef;
    private AnnotationProperty _property;
    private static final Logger _LOGGER = Logger.getLogger(AnnotationPropertyRow.class.getName());

    public AnnotationPropertyRow(BaseInspectorGui gui, QualifiedName qualifiedName, PropertyRowOwner owner) {
        super(gui, owner);
        if (qualifiedName == null) {
            throw new IllegalArgumentException("No QualifiedName for Annotation Property Row");
        }
        this._qualifiedName = qualifiedName;
        this._provider = this._getAnnotationProvider();
        this._property = this._getAnnotationProperty();
        this._propertyDef = this._getAnnotationPropertyDef();
    }

    @Override
    protected Object getColumnValueImpl(int columnIndex) {
        Object result = null;
        AnnotationMetadataResolver resolver = this.getView().getContext().getAnnotationMetadataResolver();
        Node associatedNode = this.getOwner().getParentNode();
        switch (columnIndex) {
            case 0: {
                result = this.__createPropertyId();
                break;
            }
            case 14: {
                result = this.getQName().getName();
                break;
            }
            case 1: {
                result = resolver.getShortDisplayName(this.getQName(), associatedNode);
                if (result != null) break;
                result = this.getQName().getName();
                break;
            }
            case 4: {
                result = resolver.getDisplayValue(this.getQName(), associatedNode);
                if (result != null && !result.equals("")) break;
                result = this._getRowValueDirectly(true);
                break;
            }
            case 2: {
                result = this._getRowValueDirectly(false);
                break;
            }
            case 6: {
                result = resolver.getGroup(this.getQName(), associatedNode);
                if (result == null) {
                    result = this.getView().getTranslatedString("Annotation");
                }
                result = AnnotationPropertyRow.getFixedPropertyGroup((String)result);
                break;
            }
            case 11: {
                result = resolver.getShortDescription(this.getQName(), associatedNode);
                break;
            }
            case 37: {
                result = AttributeValueItemPropertyEditor.create(this, this.getPEF2(this._getPropertyEditor(resolver, associatedNode)));
                break;
            }
            case 5: {
                result = this.isSet();
                break;
            }
            case 20: {
                result = resolver.getJavaType(this.getQName(), associatedNode);
                break;
            }
            case 7: {
                result = resolver.isExpert(this.getQName(), associatedNode);
                break;
            }
            case 8: {
                result = resolver.isHidden(this.getQName(), associatedNode);
                break;
            }
            case 9: {
                result = true;
                break;
            }
            case 10: {
                result = resolver.isValueModifable(this.getView().getContext().getAnnotationModel(), this._provider, this._qualifiedName, associatedNode);
                break;
            }
            case 18: {
                result = resolver.getHelpTopic(this.getQName(), associatedNode);
                if (result != null) break;
                result = "";
                break;
            }
            case 15: 
            case 16: {
                result = false;
                break;
            }
            case 27: {
                result = Collections.emptyList();
                break;
            }
            case 19: {
                result = resolver.isRequired(this.getQName(), associatedNode);
                break;
            }
            case 23: {
                result = resolver.isPreferred(this.getQName(), associatedNode);
                break;
            }
            case 24: {
                result = false;
                break;
            }
            case 22: {
                result = resolver.getDisplayOrder(this.getQName(), associatedNode);
                break;
            }
            case 30: {
                result = this.getActionGroups();
                break;
            }
            case 32: {
                result = this._getDefaultValue();
                break;
            }
            case 33: {
                result = false;
                break;
            }
            case 31: {
                result = this._getAttributeValueItems(resolver, associatedNode);
                break;
            }
            case 39: {
                result = this._qualifiedName;
                break;
            }
        }
        return result;
    }

    @Override
    public PropertyRow.UpdateResult setRowValueImpl(Object value) {
        boolean fireEvent = false;
        try {
            String sv = null;
            SimpleType st = this._getType();
            sv = st != null ? JavaTypeManager.getInstance().convertToString(value, st) : value.toString();
            if (value == null || "".equals(value)) {
                if (this._property != null && this._provider != null) {
                    this._provider.removeAnnotationProperty(this.getQName());
                    this._property = null;
                    fireEvent = true;
                }
            } else if (this._property == null) {
                if (this._provider != null) {
                    this._property = this._provider.addAnnotationProperty(this.getQName(), sv);
                    fireEvent = true;
                }
            } else {
                this._property.setValue(sv);
                fireEvent = true;
            }
        }
        catch (Exception e) {
            _LOGGER.log(Level.WARNING, "Failed to set a value for the AnnotationPropertyRow: " + this.getQName().getName());
        }
        return fireEvent ? PropertyRow.UpdateResult.INVALIDATE_MODEL : PropertyRow.UpdateResult.NO_UPDATE;
    }

    public QualifiedName getQName() {
        return this._qualifiedName;
    }

    @Override
    protected void setDefaultRowValueImpl() {
        try {
            if (this._provider != null && this._property != null) {
                this._provider.removeAnnotationProperty(this.getQName());
                this._property = null;
            }
        }
        catch (InvalidAnnotationException iae) {
            _LOGGER.log(Level.WARNING, "Failed to set the default value for theAnnotationPropertyRow: " + this.getQName().getName());
        }
    }

    @Override
    protected boolean isSet() {
        if (this._property != null) {
            return this._property.getValue() != null && this._property.isSpecified();
        }
        return false;
    }

    Object __createPropertyId() {
        SimpleType type = this._getType();
        return new XmlPropertyId(this.getGui(), this.getQName(), (Type)type, XmlPropertyId.PropertyType.ANNOTATION, this.getOwner().getPromotionPath());
    }

    private SimpleType _getType() {
        if (this._propertyDef != null) {
            return this._propertyDef.getType();
        }
        return null;
    }

    private AnnotationProvider _getAnnotationProvider() {
        return this.getView().getContext().getAnnotationModel().getAnnotationProvider(this.getOwner().getParentNode());
    }

    private AnnotationPropertyDef _getAnnotationPropertyDef() {
        AnnotationGrammar grammar = this.getView().getContext().getAnnotationGrammar();
        Map<QualifiedName, AnnotationPropertyDef> map = grammar.getAnnotationPropertyDefMap(this.getOwner().getParentNode());
        return map.get(this.getQName());
    }

    private AnnotationProperty _getAnnotationProperty() {
        if (this._provider != null) {
            return this._provider.getAnnotationProperty(this.getQName());
        }
        return null;
    }

    private String _getRowValueDirectly(boolean useDefault) {
        if (this._property != null) {
            return this._property.getValue();
        }
        if (useDefault) {
            return this._getDefaultValue();
        }
        return null;
    }

    private String _getDefaultValue() {
        if (this._propertyDef != null) {
            return this._propertyDef.getDefaultValue();
        }
        return null;
    }

    private Object _getPropertyEditor(AnnotationMetadataResolver resolver, Node associatedNode) {
        BaseInspectorGui gui = this.getGui();
        PropertyEditor pe = null;
        Object o = resolver.getPropertyEditor(this.getQName(), associatedNode);
        if (o != null && o instanceof String) {
            String s = (String)o;
            String peClass = gui.getPropertyEditorUsingIdentifier(s);
            if (peClass != null) {
                pe = gui.__loadPropertyEditor(peClass);
            }
            if (pe == null) {
                pe = gui.__loadPropertyEditor(s);
            }
        }
        try {
            if (pe == null && this._propertyDef != null) {
                pe = JavaTypeManager.getInstance().getPropertyEditor(this._propertyDef.getType());
            }
            if (pe == null) {
                pe = gui.__getEditorFromJavaType(this._getJavaType());
            }
        }
        catch (GrammarException ge) {
            _LOGGER.log(Level.WARNING, "Failed to return a property editor for the AnnotationPropertyRow: " + this.getQName().getName());
        }
        if (pe == null) {
            pe = JavaPropertyEditorManager.findEditor(String.class);
        }
        return pe;
    }

    private <T> Class<T> _getJavaType() throws GrammarException {
        Class c = (Class)this.getColumnValue(20);
        if (c != null) {
            return c;
        }
        if (this._propertyDef != null) {
            c = JavaTypeManager.getInstance().getJavaClass(this._propertyDef.getType());
        }
        return c;
    }

    private EnumeratedValuesInfo _getAttributeValueItems(AnnotationMetadataResolver resolver, Node associatedNode) {
        Set<AttributeValueItem> s;
        BaseInspectorGui gui = this.getGui();
        Set<AttributeValueItem> set = gui.__createAVIPSet();
        if (this._propertyDef != null && (s = gui.__convertCollection(AttributeValueUtils.getAttributeValues((SimpleType)this._propertyDef.getType()))) != null) {
            set.addAll(s);
        }
        set.addAll(gui.__getTags((PropertyEditor)this._getPropertyEditor(resolver, associatedNode)));
        return new EnumeratedValuesInfo(set, true);
    }
}

