/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.BaseXmlKeyPropertyRowCreator;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributePropertyRowCreator
extends BaseXmlKeyPropertyRowCreator<Attr> {
    @Override
    protected List<XmlKey> getGrammarBasedKeys(BaseInspectorGui gui, PropertyRowOwner owner) {
        XmlMetadataResolver resolver = gui.getView().getXmlMetadataResolver();
        return resolver.getAttributeKeys(owner.getParentKey());
    }

    @Override
    protected Map<XmlKey, Attr> getModelObjects(BaseInspectorGui gui, PropertyRowOwner owner) {
        Node ownerNode = owner.getParentNode();
        if (ownerNode == null) {
            return Collections.emptyMap();
        }
        Iterable attrs = DomUtils.getAttributesIterable((Node)ownerNode);
        if (attrs == null) {
            return Collections.emptyMap();
        }
        HashMap<XmlKey, Attr> map = new HashMap<XmlKey, Attr>();
        for (Attr attr : attrs) {
            XmlKey attrKey = DerivedXmlKey.createAttributeKey((GrammarResolver)gui.getGuiContext().getGrammarResolver(), (XmlKey)owner.getParentKey(), (QualifiedName)DomUtils.getQualifiedName((Node)attr));
            map.put(attrKey, attr);
        }
        return map;
    }

    @Override
    protected PropertyRow createRow(BaseInspectorGui gui, PropertyRowOwner owner, XmlKey key, XmlKey grammarInfo, Attr modelObj) {
        return gui.createPropertyRow(key, modelObj, owner);
    }

    @Override
    protected boolean supportsAnyProperties(BaseInspectorGui gui, PropertyRowOwner owner) {
        return DomUtils.isElement((Node)owner.getTargetNode());
    }

    AttributePropertyRowCreator() {
    }
}

