/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactoryInfo;
import oracle.bali.inspector.editor.ToStringConverter;
import oracle.bali.xml.gui.base.inspector.AbstractAttributeValueItemPropertyEditor;
import oracle.bali.xml.gui.base.inspector.AttributeValueItemPropertyEditor;
import oracle.bali.xml.gui.base.inspector.AttributeValueItemRenderer;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.AttributeValueItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComboBoxSupport {
    public static EditorComponentInfo getComboBoxInfo(AttributeValueItemPropertyEditor propEditor) {
        Vector<AttributeValueItem> peItems = propEditor.getAttributeValueItems();
        if (!ComboBoxSupport._needComboBox(peItems)) {
            return null;
        }
        HashMap<MappedEditorFactoryInfo.PropertyName, Object> properties = new HashMap<MappedEditorFactoryInfo.PropertyName, Object>(5);
        properties.put(MappedEditorFactoryInfo.PropertyName.MODEL, ComboBoxSupport._getComboBoxModel(propEditor, peItems));
        properties.put(MappedEditorFactoryInfo.PropertyName.RENDERER, ComboBoxSupport._getRenderer(propEditor));
        properties.put(MappedEditorFactoryInfo.PropertyName.EDITABLE, ComboBoxSupport._isEditable(propEditor));
        1 eci = new 1(properties, propEditor);
        return eci;
    }

    private static Object _getInitialSelection(AttributeValueItemPropertyEditor propEditor) {
        Object initialSelection = !propEditor.__isRowSet() ? (propEditor.isConstrainedToEnumeration() ? propEditor.getNoneItem() : null) : propEditor.getAsText();
        return initialSelection;
    }

    private static ListCellRenderer _getRenderer(AttributeValueItemPropertyEditor propEditor) {
        return new DelegatingListCellRenderer(propEditor);
    }

    private static ComboBoxModel _getComboBoxModel(AttributeValueItemPropertyEditor propEditor, Vector<AttributeValueItem> peItems) {
        AVIComboModel model = new AVIComboModel(propEditor, peItems);
        ((DefaultComboBoxModel)model).setSelectedItem(ComboBoxSupport._getInitialSelection(propEditor));
        return model;
    }

    private static boolean _needComboBox(Vector<AttributeValueItem> peItems) {
        return peItems.isEmpty() ^ true;
    }

    private static boolean _isEditable(AttributeValueItemPropertyEditor propEditor) {
        return propEditor.isConstrainedToEnumeration() ^ true;
    }

    public static void initializeComboBox(JComboBox jcb, AttributeValueItemPropertyEditor propEditor) {
        Vector<AttributeValueItem> peItems = propEditor.getAttributeValueItems();
        if (!ComboBoxSupport._needComboBox(peItems)) {
            return;
        }
        jcb.setRenderer(ComboBoxSupport._getRenderer(propEditor));
        jcb.setModel(ComboBoxSupport._getComboBoxModel(propEditor, peItems));
        jcb.setEditable(ComboBoxSupport._isEditable(propEditor));
    }

    ComboBoxSupport() {
    }

    static final class 1
    extends EditorComponentInfo {
        private final /* synthetic */ Map v$properties;
        private final /* synthetic */ AttributeValueItemPropertyEditor v$propEditor;

        public Object initialValue() {
            return new MappedEditorFactoryInfo(MappedEditorFactoryInfo.EditorType.COMBO_BOX, this.v$properties);
        }

        public ToStringConverter editorValueToStringConverter() {
            return this.v$propEditor.getRow().getStringConverter();
        }

        public 1(Map map, AttributeValueItemPropertyEditor attributeValueItemPropertyEditor) {
            this.v$propEditor = attributeValueItemPropertyEditor;
            this.v$properties = map;
        }
    }

    private static final class DelegatingListCellRenderer
    implements ListCellRenderer {
        private final AbstractAttributeValueItemPropertyEditor _propEditor;
        private final AttributeValueItemRenderer _default_renderer;

        public DelegatingListCellRenderer(AbstractAttributeValueItemPropertyEditor propEditor) {
            this._propEditor = propEditor;
            this._default_renderer = new AttributeValueItemRenderer();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListCellRenderer<Object> cellRenderer = null;
            if (value instanceof AttributeValueItem) {
                AttributeValueItem item = (AttributeValueItem)value;
                cellRenderer = this._getCustomListCellRenderer(item);
            }
            if (cellRenderer == null) {
                cellRenderer = this._default_renderer;
            }
            return cellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        private ListCellRenderer _getCustomListCellRenderer(AttributeValueItem item) {
            AttributeValueItemProvider avip = this._propEditor.getAvip();
            if (avip != null && avip.hasCustomRenderer()) {
                return avip.getCustomListCellRenderer(item);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AVIComboModel
    extends DefaultComboBoxModel {
        private final AttributeValueItemPropertyEditor _propEditor;

        public AVIComboModel(AttributeValueItemPropertyEditor propEditor, Vector<AttributeValueItem> items) {
            super(items);
            this._propEditor = propEditor;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof String) {
                String str = anObject.toString();
                int i = 0;
                int size = this.getSize();
                while (i < size) {
                    AttributeValueItem item = (AttributeValueItem)this.getElementAt(i);
                    if (AttributeValueItemPropertyEditor.__equalsSelectedValue(item, str)) {
                        anObject = item;
                        break;
                    }
                    ++i;
                }
            } else if (anObject == null) {
                if (this._propEditor.isConstrainedToEnumeration()) {
                    anObject = this._propEditor.getNoneItem();
                }
            } else if (!(anObject instanceof AttributeValueItem)) {
                throw new IllegalArgumentException("tried to set selection of invalid type: " + anObject);
            }
            super.setSelectedItem(anObject);
        }
    }
}

