/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import oracle.bali.inspector.multi.ArraySelectionModel;
import oracle.bali.inspector.multi.SelectionListener;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlView;
import org.w3c.dom.Node;

public class PISelectionModel
implements SelectionModel {
    private XmlDomPropertyModel[] _propertyModels;
    private BaseInspectorGui _gui;

    public PISelectionModel(BaseInspectorGui inspectorGui, boolean listenToSelection) {
        if (inspectorGui == null) {
            throw new IllegalArgumentException("BaseInspectorXmlGui required");
        }
        this._gui = inspectorGui;
        this._propertyModels = this._getPropertyModels();
    }

    public void dispose() {
        this._gui = null;
        if (this._propertyModels != null) {
            int i = 0;
            while (i < this._propertyModels.length) {
                this._propertyModels[i].disposeModel();
                ++i;
            }
            this._propertyModels = new XmlDomPropertyModel[0];
        }
    }

    public int getSelectedItemCount() {
        return this._propertyModels.length;
    }

    public Object getSelectedItem(int index) {
        return this._propertyModels[index];
    }

    public void addSelectionListener(SelectionListener listener) {
    }

    public void removeSelectionListener(SelectionListener listener) {
    }

    public SelectionModel copyContents() {
        return new ArraySelectionModel(new Vector<XmlDomPropertyModel>(Arrays.asList(this._propertyModels)));
    }

    private XmlDomPropertyModel[] _getPropertyModels() {
        XmlView view = this._gui.getView();
        Set inspectableSet = this.getInspectableNodes();
        int inspectableNodeCount = inspectableSet.size();
        XmlDomPropertyModel[] propertyModels = new XmlDomPropertyModel[inspectableNodeCount];
        Iterator inspectableNodes = inspectableSet.iterator();
        int i = 0;
        while (i < inspectableNodeCount) {
            Node n = (Node)inspectableNodes.next();
            XmlKey key = view.getNodeXmlKey(n);
            propertyModels[i] = this._gui.createPropertyModel(n, key);
            ++i;
        }
        return propertyModels;
    }

    protected Set getInspectableNodes() {
        XmlView view = this._gui.getView();
        HashSet<Node> inspectableSet = null;
        view.acquireReadLock();
        try {
            Node[] nodes = view.getSelection().getSelectedNodesArray();
            inspectableSet = new HashSet<Node>(nodes.length);
            int i = 0;
            while (i < nodes.length) {
                Node inspectableNode = nodes[i];
                if (inspectableNode != null) {
                    inspectableSet.add(inspectableNode);
                }
                ++i;
            }
        }
        finally {
            view.releaseReadLock();
        }
        return inspectableSet;
    }

    protected BaseInspectorGui getGui() {
        return this._gui;
    }
}

