/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import oracle.bali.inspector.JavaBeansPropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.xml.dom.NodeCustomizationDetails;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.base.inspector.AttributeValueItemPropertyEditor;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.EnumeratedValuesInfo;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.gui.base.inspector.XmlKeyPropertyRow;
import oracle.bali.xml.gui.base.inspector.editors.BooleanEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.DefaultAttributeValueItem;
import oracle.bali.xml.util.XmlModelUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class PresenceBooleanPropertyRow
extends PropertyRow {
    private Node _node;
    private XmlKey _key;

    public PresenceBooleanPropertyRow(BaseInspectorGui gui, Node node, XmlKey key, PropertyRowOwner owner) {
        super(gui, owner);
        this._node = node;
        this._key = key;
    }

    protected PropertyRow.UpdateResult setRowValueImpl(Object value) {
        boolean isFalse = value == null || Boolean.FALSE.equals(value) || "".equals(value) || "false".equalsIgnoreCase(value.toString());
        boolean boolVal = isFalse ^ true;
        if (boolVal == this.isSet()) {
            return PropertyRow.UpdateResult.NO_UPDATE;
        }
        if (boolVal) {
            this._addValue();
        } else {
            this._removeValue();
        }
        return PropertyRow.UpdateResult.INVALIDATE_MODEL;
    }

    protected Object getColumnValueImpl(int columnIndex) {
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        switch (columnIndex) {
            case 0: {
                return this.getGui().__getPropertyId(this._key, this.getOwner());
            }
            case 25: 
            case 39: {
                return this._key;
            }
            case 1: {
                return this.getPropertyDisplayName(resolver, this._key, this.getOwner().getParentNode(), this.getOwner().getParentKey());
            }
            case 4: {
                return String.valueOf(this.isSet());
            }
            case 2: {
                return this.isSet();
            }
            case 32: {
                return false;
            }
            case 37: {
                return AttributeValueItemPropertyEditor.create(this, (PropertyEditorFactory2)new JavaBeansPropertyEditorAdapter((PropertyEditor)new BooleanEditor()));
            }
            case 5: {
                return this.isSet();
            }
            case 14: {
                return this._key.getLocalName();
            }
            case 20: {
                return Boolean.class;
            }
            case 6: {
                return XmlKeyPropertyRow.__getPropertyGroup(this._key, resolver);
            }
            case 7: {
                return resolver.isExpert(this._key);
            }
            case 8: {
                return resolver.isHidden(this._key);
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return resolver.getShortDescription(this._key);
            }
            case 12: {
                return false;
            }
            case 13: {
                return null;
            }
            case 15: {
                return false;
            }
            case 16: {
                return false;
            }
            case 17: {
                return this._node;
            }
            case 18: {
                return this.getGui().getHelpTopic(this._node, this._key);
            }
            case 19: {
                return false;
            }
            case 21: {
                return this.isCommon(this._key);
            }
            case 22: {
                return resolver.getDisplayOrder(this._key);
            }
            case 23: {
                return resolver.isPreferred(this._key);
            }
            case 24: {
                return resolver.isFavoriteProperty((Element)this.getOwner().getParentNode(), this.getOwner().getParentKey(), this._node, this._key);
            }
            case 26: {
                return resolver.isDeprecated(this._key);
            }
            case 27: {
                if (this._node == null) {
                    Node owner = this.getOwner().getParentNode();
                    return this.getGui().getNodeMessageList(owner, this._key);
                }
                return this.getGui().getNodeMessageList(this._node);
            }
            case 28: {
                if (this._node == null) {
                    Node owner = this.getOwner().getParentNode();
                    return this.getGui().getNodeToolTip(owner, this._key);
                }
                return this.getGui().getNodeToolTip(this._node);
            }
            case 29: {
                return resolver.isHiddenInPropertiesDialog(this._key, this._node);
            }
            case 30: {
                return this.getActionGroups();
            }
            case 33: {
                return this.isCustomizedAtTip();
            }
            case 31: {
                ArrayList<AttributeValueItem> items = new ArrayList<AttributeValueItem>(2);
                items.add(new DefaultAttributeValueItem("true"));
                return new EnumeratedValuesInfo(items, true);
            }
        }
        return null;
    }

    protected void setDefaultRowValueImpl() {
        this._removeValue();
    }

    protected boolean isSet() {
        return this._node != null;
    }

    protected boolean isCustomizedAtTip() {
        boolean isCustomizedAtTip = false;
        if (this._node != null) {
            this.getView().acquireReadLock();
            try {
                NodeCustomizationDetails ncd = this.getView().getBaseModel().getCustomizationDetails(this._node);
                if (ncd != null) {
                    isCustomizedAtTip = ncd.isCustomizedAtTip();
                }
            }
            finally {
                this.getView().releaseReadLock();
            }
        }
        return isCustomizedAtTip;
    }

    String getPropertyDisplayName(XmlMetadataResolver resolver, XmlKey key, Node ownerNode, XmlKey ownerKey) {
        return resolver.getPropertyDisplayName(key, ownerNode, ownerKey);
    }

    protected boolean isCommon(XmlKey key) {
        if (key.getNodeType() == 2) {
            boolean isFavorite = (Boolean)this.getColumnValue(24);
            boolean common = isFavorite || this.getView().getXmlMetadataResolver().isPreferred(key);
            return common;
        }
        return false;
    }

    private void _addValue() {
        if (this._node == null) {
            XmlView view = this.getGui().getView();
            XmlModel model = view.getContext().getModel();
            DomPosition pos = DomPositionFactory.inside((Node)this.getOwner().getParentNode());
            try {
                Node created = XmlModelUtils.createNodeFromKey(view, this._key, pos);
                if (created != null) {
                    if (model.isInModelDocumentHierarchy(pos)) {
                        this._node = view.insertNode(created, pos, false);
                    } else {
                        DomPosition realPos = model.findValidInsertionPosition(this._key, created, pos, this.getOwner().getParentKey());
                        DomUtils.insertNodeAtPosition((DomPosition)realPos, (Node)created);
                        this._node = created;
                    }
                }
            }
            catch (XmlCommitException e) {
                // empty catch block
            }
        }
    }

    private void _removeValue() {
        if (this._node != null) {
            Node toRemove = this._node;
            this._node = null;
            toRemove.getParentNode().removeChild(toRemove);
        }
    }
}

