/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.MultiObjectModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlMultiObjectModel;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyModelUtils {
    public static <T> T getData(PropertyModel model, int row, Object columnId, Class<T> clazz) {
        if (model == null || columnId == null || clazz == null) {
            throw new IllegalArgumentException("null param; model=" + model + " columnId=" + columnId + " clazz=" + clazz);
        }
        return (T)ModelUtil.as((Object)model.getData(columnId, row), clazz);
    }

    public static <T> T getValueAt(PropertyModel model, int row, int column, Class<T> clazz) {
        return (T)ModelUtil.as((Object)model.getValueAt(row, column), clazz);
    }

    public static boolean isRequired(PropertyModel model, int row) {
        return PropertyModelUtils.getBooleanData(model, row, XmlDomPropertyModel.COLUMN_IS_REQUIRED, false);
    }

    public static boolean isSet(PropertyModel model, int row) {
        return PropertyModelUtils.getBooleanData(model, row, XmlDomPropertyModel.COLUMN_IS_SET, true);
    }

    public static boolean getBooleanData(PropertyModel model, int row, Object columnId, boolean valueIfUnset) {
        Boolean ret = PropertyModelUtils.getData(model, row, columnId, Boolean.class);
        if (ret == null) {
            return valueIfUnset;
        }
        return ret;
    }

    public static XmlKey getXmlKey(PropertyModel model, int row) {
        return PropertyModelUtils.getData(model, row, XmlDomPropertyModel.COLUMN_XMLKEY, XmlKey.class);
    }

    public static Node getNode(PropertyModel model, int row) {
        return PropertyModelUtils.getData(model, row, XmlDomPropertyModel.COLUMN_NODE, Node.class);
    }

    public static XmlKey getTargetXmlKey(PropertyModel model, int row) {
        return PropertyModelUtils.getData(model, row, XmlDomPropertyModel.COLUMN_TARGET_KEY, XmlKey.class);
    }

    public static Node getTargetNode(PropertyModel model, int row) {
        return PropertyModelUtils.getData(model, row, XmlDomPropertyModel.COLUMN_TARGET_NODE, Node.class);
    }

    public static Node getNearestAncestorNode(PropertyModel model, int row) {
        return PropertyModelUtils.getData(model, row, XmlDomPropertyModel.COLUMN_NEAREST_ANCESTOR_NODE, Node.class);
    }

    public static BaseInspectorGui getInspectorGui(PropertyModel model, int row) {
        return PropertyModelUtils.getData(model, row, XmlDomPropertyModel.COLUMN_INSPECTOR_GUI, BaseInspectorGui.class);
    }

    public static Node getOwnerNode(PropertyModel model, int row) {
        return PropertyModelUtils.getData(model, row, XmlDomPropertyModel.COLUMN_OWNER_NODE, Node.class);
    }

    public static XmlKey getOwnerKey(PropertyModel model, int row) {
        return PropertyModelUtils.getData(model, row, XmlDomPropertyModel.COLUMN_OWNER_KEY, XmlKey.class);
    }

    public static XmlContext getXmlContext(PropertyModel model, int row) {
        BaseInspectorGui gui = PropertyModelUtils.getInspectorGui(model, row);
        if (gui == null) {
            return null;
        }
        return gui.getGuiContext();
    }

    public static int findRowForXmlKey(PropertyModel model, XmlKey key) {
        if (key == null || model == null) {
            throw new IllegalArgumentException("null param; model=" + model + " key=" + key);
        }
        model.startRead();
        try {
            int i = 0;
            while (i < model.getRowCount()) {
                if (key.equals((Object)PropertyModelUtils.getXmlKey(model, i))) {
                    int n = i;
                    return n;
                }
                ++i;
            }
        }
        finally {
            model.stopRead();
        }
        return -1;
    }

    public static PropertyEditorContext createPropertyEditorContext(PropertyModel model, int row) {
        return PropertyEditorContext.create(PropertyModelUtils.getXmlContext(model, row), PropertyModelUtils.getXmlKey(model, row), PropertyModelUtils.getNode(model, row), PropertyModelUtils.getOwnerNode(model, row), PropertyModelUtils.getOwnerKey(model, row), PropertyModelUtils.getNearestAncestorNode(model, row), PropertyModelUtils.getTargetNode(model, row));
    }

    public static PropertyEditorContext createPropertyEditorContext(PropertyModel model, XmlKey rowKey) {
        int row = PropertyModelUtils.findRowForXmlKey(model, rowKey);
        if (row < 0) {
            return null;
        }
        return PropertyModelUtils.createPropertyEditorContext(model, row);
    }

    public static <T> T getGlobalDataIfSingleModel(PropertyModel model, Class<T> clazz, Object columnId) {
        if (model == null) {
            return null;
        }
        T data = null;
        model.startRead();
        try {
            int i = 0;
            int count = model.getRowCount();
            while (i < count) {
                T gotData = PropertyModelUtils.getData(model, i, columnId, clazz);
                if (gotData != data && gotData != null) {
                    if (data != null) {
                        T t = null;
                        return t;
                    }
                    data = gotData;
                }
                ++i;
            }
        }
        finally {
            model.stopRead();
        }
        return data;
    }

    /*
     * Unable to fully structure code
     */
    public static <T> T getGlobalDataFromPrimaryModel(PropertyModel pm, Class<T> clazz, Object columnId) {
        block5: {
            if (pm == null) {
                return null;
            }
            pm.startRead();
            try {
                sm = PropertyModelUtils.getSelectionModel(pm);
                if (sm == null || (ppm = (PropertyModel)sm.getSelectedItem(0)).getRowCount() <= 0) break block5;
                var5_5 = PropertyModelUtils.getData(pm, 0, columnId, clazz);
                ** try [egrp 1[TRYBLOCK] [1 : 53->59)] { 
            }
lbl10:
            // 1 sources

            catch (Throwable var6_6) {
                throw var6_6;
            }
            finally {
                pm.stopRead();
            }
lbl9:
            // 1 sources

            return var5_5;
        }
        return PropertyModelUtils.getGlobalDataIfSingleModel(pm, clazz, columnId);
    }

    public static <T> List<T> getGlobalDataFromModels(PropertyModel pm, Class<T> clazz, Object columnId) {
        block7: {
            if (pm == null) {
                return null;
            }
            pm.startRead();
            try {
                SelectionModel sm = PropertyModelUtils.getSelectionModel(pm);
                if (sm == null) break block7;
                int c = sm.getSelectedItemCount();
                ArrayList<T> l = new ArrayList<T>(c);
                int i = 0;
                while (i < c) {
                    T data;
                    PropertyModel m = (PropertyModel)sm.getSelectedItem(0);
                    if (m.getRowCount() > 0 && (data = PropertyModelUtils.getData(m, 0, columnId, clazz)) != null) {
                        l.add(data);
                    }
                    ++i;
                }
                ArrayList<T> arrayList = l;
                return arrayList;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                pm.stopRead();
            }
        }
        return Collections.singletonList(PropertyModelUtils.getGlobalDataIfSingleModel(pm, clazz, columnId));
    }

    public static boolean isSupportedRootModel(PropertyModel pm) {
        return pm instanceof XmlMultiObjectModel;
    }

    public static SelectionModel getSelectionModel(PropertyModel pm) {
        if (!(pm instanceof MultiObjectModel)) {
            return null;
        }
        return ((MultiObjectModel)pm).getSelectionModel();
    }

    private PropertyModelUtils() {
    }
}

