/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.JavaBeansPropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.editor.ToStringConverter;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PropertyRowColumnUtils;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.share.GroupingAction;
import oracle.bali.xml.share.UnmodifiableArrayList;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.ide.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyRow {
    private final BaseInspectorGui _gui;
    private final PropertyRowOwner _owner;
    private final transient Object[] _columns;
    private static final Object _UNINITIALIZED_VALUE = new Object();

    PropertyRow(BaseInspectorGui gui, PropertyRowOwner owner) {
        if (gui == null) {
            throw new IllegalArgumentException("No gui");
        }
        if (owner == null) {
            throw new IllegalArgumentException("No owner");
        }
        this._gui = gui;
        this._owner = owner;
        this._columns = new Object[PropertyRowColumnUtils.getColumnCount()];
        this._uninitAllColumns();
    }

    public final PropertyRowOwner getOwner() {
        return this._owner;
    }

    public final UpdateResult setRowValue(Object value) {
        if (!this.rowValueRequiresUpdate(value)) {
            return UpdateResult.NO_UPDATE;
        }
        try {
            this.getOwner().createMissingAncestors();
            UpdateResult ret = this.setRowValueImpl(value);
            if (ret != UpdateResult.NO_UPDATE) {
                this.dispose();
            }
            UpdateResult updateResult = ret;
            return updateResult;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public final Object getColumnValue(int columnIndex) {
        Object result = this._columns[columnIndex];
        if (result != _UNINITIALIZED_VALUE && !this._ignoreCache(columnIndex)) {
            return result;
        }
        switch (columnIndex) {
            case 35: {
                result = this.getOwner().getParentNode();
                break;
            }
            case 36: {
                result = this.getOwner().getParentKey();
                break;
            }
            case 34: {
                result = this.getOwner().getNearestAncestor();
                break;
            }
            default: {
                result = this.getColumnValueImpl(columnIndex);
                break;
            }
        }
        this._columns[columnIndex] = result;
        return result;
    }

    public final void setDefaultRowValue() {
        this.setDefaultRowValueImpl();
        this.dispose();
    }

    public void dispose() {
        try {
            Object o = this._columns[3];
            if (o instanceof PropertyEditorAdapter) {
                o = ((PropertyEditorAdapter)o).getPropertyEditor();
            }
            PropertyEditorContext.clearContext(o);
            o = this._columns[13];
            if (o instanceof PropertyModel) {
                ((PropertyModel)o).dispose();
            }
        }
        finally {
            this._uninitAllColumns();
        }
    }

    protected boolean rowValueRequiresUpdate(Object newValue) {
        String newStringValue;
        boolean isSet = Boolean.TRUE.equals(this.getColumnValue(5));
        Object oldValue = this.getColumnValue(2);
        String oldStringValue = oldValue != null ? oldValue.toString() : "";
        String string = newStringValue = newValue != null ? newValue.toString() : "";
        if (isSet && (oldValue == newValue || oldValue != null && oldValue.equals(newValue))) {
            return false;
        }
        boolean newEmpty = ModelUtil.hasLength((String)newStringValue) ^ true;
        if (!isSet && newEmpty) {
            return false;
        }
        return !newEmpty || ModelUtil.hasLength((String)oldStringValue);
    }

    protected final BaseInspectorGui getGui() {
        return this._gui;
    }

    protected final XmlView getView() {
        return this.getGui().getView();
    }

    protected static final PropertyGroup getFixedPropertyGroup(String groupName) {
        return new FixedPropertyGroup(groupName);
    }

    protected abstract UpdateResult setRowValueImpl(Object var1);

    protected abstract Object getColumnValueImpl(int var1);

    protected abstract void setDefaultRowValueImpl();

    protected abstract boolean isSet();

    protected final List<ActionGroup> getActionGroups() {
        LinkedList<Action> actions = new LinkedList<Action>();
        this.getGui().gatherPropertyLevelActions(this, actions);
        if (actions.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<Object, ActionGroup> groups = new LinkedHashMap<Object, ActionGroup>();
        for (Action action : actions) {
            if (Boolean.FALSE.equals(action.getValue("show-in-pi"))) continue;
            Object id = GroupingAction.getGroupIdentifier(action);
            ActionGroup curGroup = (ActionGroup)groups.get(id);
            if (curGroup == null) {
                curGroup = new ActionGroup();
                groups.put(id, curGroup);
            }
            curGroup.add(action);
        }
        Collection groupsCol = groups.values();
        ActionGroup[] groupsArr = groupsCol.toArray(new ActionGroup[groupsCol.size()]);
        return new UnmodifiableArrayList<ActionGroup>(groupsArr);
    }

    protected PropertyEditorFactory2 getPEF2(Object pe) {
        PropertyEditorFactory2 pef2 = null;
        if (pe instanceof PropertyEditorFactory2) {
            pef2 = (PropertyEditorFactory2)pe;
        } else if (pe instanceof PropertyEditor) {
            pef2 = new JavaBeansPropertyEditorAdapter((PropertyEditor)pe);
        } else if (pe instanceof PropertyEditorAdapter) {
            pef2 = new JavaBeansPropertyEditorAdapter(((PropertyEditorAdapter)pe).getPropertyEditor());
        } else {
            throw new IllegalArgumentException("Could not convert this editor to PEF2: " + pe.getClass().getCanonicalName());
        }
        return pef2;
    }

    protected ToStringConverter getStringConverter() {
        return new 1();
    }

    private void _uninitAllColumns() {
        Arrays.fill(this._columns, _UNINITIALIZED_VALUE);
    }

    private boolean _ignoreCache(int columnIndex) {
        return 27 == columnIndex;
    }

    final class 1
    implements ToStringConverter {
        public String convertToString(Object value) {
            try {
                if (value == null) {
                    String string = null;
                    return string;
                }
                if (value instanceof AttributeValueItem) {
                    String string = ((AttributeValueItem)value).selectValue();
                    return string;
                }
                if (value instanceof String) {
                    String string = (String)value;
                    return string;
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            return value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UpdateResult
    extends Enum<UpdateResult> {
        private static final /* synthetic */ UpdateResult[] $v;
        public static final /* enum */ UpdateResult INVALIDATE_MODEL;
        public static final /* enum */ UpdateResult INVALIDATE_CELL;
        public static final /* enum */ UpdateResult NO_UPDATE;

        public static UpdateResult valueOf(String string) {
            return Enum.valueOf(UpdateResult.class, string);
        }

        public static final UpdateResult[] values() {
            return (UpdateResult[])$v.clone();
        }

        static {
            UpdateResult[] updateResultArray = new UpdateResult[3];
            updateResultArray[2] = NO_UPDATE = new UpdateResult("NO_UPDATE", 2);
            updateResultArray[1] = INVALIDATE_CELL = new UpdateResult("INVALIDATE_CELL", 1);
            updateResultArray[0] = INVALIDATE_MODEL = new UpdateResult("INVALIDATE_MODEL", 0);
            $v = updateResultArray;
        }

        private UpdateResult(String string2, int n2) {
        }
    }

    private static class FixedPropertyGroup
    implements PropertyGroup {
        private final String _groupName;

        public FixedPropertyGroup(String groupName) {
            if (groupName == null) {
                throw new IllegalArgumentException();
            }
            this._groupName = groupName;
        }

        public String getName(Locale locale) {
            return this._groupName;
        }

        public String toString() {
            return this._groupName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof FixedPropertyGroup) {
                return this._groupName.equals(((FixedPropertyGroup)o)._groupName);
            }
            return false;
        }

        public int hashCode() {
            return this._groupName.hashCode();
        }
    }
}

