/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.grammar.GrammarUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyRowColumnUtils {
    private static final Object[] _COLUMNS = new Object[]{PropertyModel.COLUMN_ID, PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_VALUE, PropertyModel.COLUMN_EDITOR_FACTORY, PropertyModel.COLUMN_DISPLAY_VALUE, XmlDomPropertyModel.COLUMN_IS_SET, PropertyModel.COLUMN_GROUP, PropertyModel.COLUMN_IS_EXPERT, PropertyModel.COLUMN_IS_HIDDEN, PropertyModel.COLUMN_IS_READABLE, PropertyModel.COLUMN_IS_WRITABLE, PropertyModel.COLUMN_DESCRIPTION, PropertyModel.COLUMN_IS_DRILLABLE, PropertyModel.COLUMN_MODEL, PropertyModel.COLUMN_NAME, XmlDomPropertyModel.COLUMN_SUPPORTS_DATABINDING, XmlDomPropertyModel.COLUMN_IS_DATABOUND, XmlDomPropertyModel.COLUMN_NODE, XmlDomPropertyModel.COLUMN_HELP_TOPIC, XmlDomPropertyModel.COLUMN_IS_REQUIRED, PropertyModel.COLUMN_VALUE_CLASS, XmlDomPropertyModel.COLUMN_IS_COMMON, XmlDomPropertyModel.COLUMN_DISPLAY_ORDER, XmlDomPropertyModel.COLUMN_IS_PREFERRED, XmlDomPropertyModel.COLUMN_IS_FAVORITE, XmlDomPropertyModel.COLUMN_XMLKEY, XmlDomPropertyModel.COLUMN_IS_DEPRECATED, PropertyModel.COLUMN_VALIDATION_ISSUES, XmlDomPropertyModel.COLUMN_TOOLTIP, XmlDomPropertyModel.COLUMN_HIDDEN_IN_PROPERTIES_DIALOG, PropertyModel.COLUMN_ACTIONS, XmlDomPropertyModel.COLUMN_ENUMERATED_VALUES_INFO, XmlDomPropertyModel.COLUMN_DEFAULT_VALUE, XmlDomPropertyModel.COLUMN_IS_CUSTOMIZED_AT_TIP, XmlDomPropertyModel.COLUMN_NEAREST_ANCESTOR_NODE, XmlDomPropertyModel.COLUMN_OWNER_NODE, XmlDomPropertyModel.COLUMN_OWNER_KEY, PropertyModel.COLUMN_EDITOR_FACTORY_2, XmlDomPropertyModel.COLUMN_ATTRIBUTE_VALUE_ITEM_PROVIDER, XmlDomPropertyModel.COLUMN_KEY};
    static final int ID_INDEX = 0;
    protected static final int DISPLAY_NAME_INDEX = 1;
    protected static final int VALUE_INDEX = 2;
    protected static final int EDITOR_FACTORY_INDEX = 3;
    protected static final int DISPLAY_VALUE_INDEX = 4;
    protected static final int INDEX_IS_SET = 5;
    protected static final int GROUP_INDEX = 6;
    protected static final int EXPERT_INDEX = 7;
    protected static final int HIDDEN_INDEX = 8;
    protected static final int READABLE_INDEX = 9;
    protected static final int WRITABLE_INDEX = 10;
    protected static final int DESCRIPTION_INDEX = 11;
    protected static final int DRILLABLE_INDEX = 12;
    protected static final int MODEL_INDEX = 13;
    protected static final int NAME_INDEX = 14;
    protected static final int SUPPORTS_DATABINDING = 15;
    protected static final int INDEX_ISDATABOUND = 16;
    protected static final int NODE_INDEX = 17;
    protected static final int INDEX_HELP_TOPIC = 18;
    protected static final int REQUIRED_INDEX = 19;
    protected static final int VALUE_CLASS_INDEX = 20;
    protected static final int COMMON_INDEX = 21;
    protected static final int DISPLAY_ORDER_INDEX = 22;
    protected static final int PREFERRED_INDEX = 23;
    protected static final int FAVORITE_INDEX = 24;
    protected static final int XMLKEY_INDEX = 25;
    protected static final int IS_DEPRECATED_INDEX = 26;
    protected static final int VALIDATION_ISSUES_INDEX = 27;
    protected static final int TOOLTIP = 28;
    protected static final int HIDDEN_IN_PROPERTIES_DIALOG = 29;
    protected static final int ACTIONS_INDEX = 30;
    protected static final int ENUMERATED_VALUES_INFO_INDEX = 31;
    protected static final int DEFAULT_VALUE_INDEX = 32;
    protected static final int CUSTOMIZED_AT_TIP = 33;
    protected static final int NEAREST_ANCESTOR_NODE_INDEX = 34;
    protected static final int OWNER_NODE_INDEX = 35;
    protected static final int OWNER_KEY_INDEX = 36;
    protected static final int PROPERTY_EDITOR_FACTORY2_INDEX = 37;
    protected static final int ATTRIBUTE_VALUE_ITEM_PROVIDER_INDEX = 38;
    protected static final int KEY_INDEX = 39;

    private PropertyRowColumnUtils() {
    }

    public static Object[] getColumnMapping() {
        return _COLUMNS;
    }

    static int getColumnCount() {
        return _COLUMNS.length;
    }

    static List<PropertyRow> mergeSortedLists(List<PropertyRow> list1, List<PropertyRow> list2, Comparator sorter, boolean isAppended) {
        int list2Count;
        int list1Count = list1 != null ? list1.size() : 0;
        int n = list2Count = list2 != null ? list2.size() : 0;
        if (list1Count == 0) {
            return list2;
        }
        if (list2Count == 0) {
            return list1;
        }
        if (isAppended) {
            list1.addAll(list2);
            return list1;
        }
        int mergedCount = list1Count + list2Count;
        ArrayList<PropertyRow> mergedList = new ArrayList<PropertyRow>(mergedCount);
        Iterator<PropertyRow> list1Objects = list1.iterator();
        Iterator<PropertyRow> list2Objects = list2.iterator();
        PropertyRow currList1Object = list1Objects.next();
        PropertyRow currList2Object = list2Objects.next();
        while (currList1Object != null || currList2Object != null) {
            PropertyRow currValue;
            int result = currList1Object != null ? (currList2Object != null ? sorter.compare(currList1Object, currList2Object) : -1) : 1;
            if (result <= 0) {
                currValue = currList1Object;
                currList1Object = list1Objects.hasNext() ? list1Objects.next() : null;
            } else {
                currValue = currList2Object;
                currList2Object = list2Objects.hasNext() ? list2Objects.next() : null;
            }
            mergedList.add(currValue);
        }
        return mergedList;
    }

    static boolean isElement(BaseInspectorGui gui, PropertyRowOwner owner) {
        XmlKey key = owner.getParentKey();
        Node node = owner.getParentNode();
        if (node == null) {
            ElementDef ed = GrammarUtils.getElementDef((GrammarResolver)gui.getView().getContext().getGrammarResolver(), (XmlKey)key);
            return ed != null;
        }
        return DomUtils.isElement((Node)node);
    }
}

