/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyRowOwner {
    private final BaseInspectorGui _gui;
    private final XmlKey _targetKey;
    private final Node _targetNode;
    private final List<XmlKey> _promotionPath;
    private TreeTraversal _ownerTraversal;
    private int _hashCode;

    PropertyRowOwner(BaseInspectorGui gui, Node node, XmlKey key, List<XmlKey> ancestors) {
        if (gui == null) {
            throw new IllegalArgumentException("gui cannot be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this._gui = gui;
        this._targetNode = node;
        this._ownerTraversal = XmlModelUtils.getPropertyEditorOwnerTraversal(this._targetNode);
        this._targetKey = key;
        this._promotionPath = ancestors == null ? Collections.singletonList(this._targetKey) : this._getUnmodifiableClonedList(ancestors);
        this._hashCode = this._hashCode();
    }

    public Node getTargetNode() {
        return this._targetNode;
    }

    public XmlKey getTargetKey() {
        return this._targetKey;
    }

    public Node getParentNode() {
        if (this.isTargetNodeParent()) {
            return this.getTargetNode();
        }
        return this._getNode(this._promotionPath.size() - 1, this._targetNode);
    }

    public XmlKey getParentKey() {
        return this._promotionPath.get(this._promotionPath.size() - 1);
    }

    public List<XmlKey> getPromotionPath() {
        return this._promotionPath;
    }

    public Node getNearestAncestor() {
        if (this.isTargetNodeParent()) {
            return this._targetNode;
        }
        int i = this._promotionPath.size() - 1;
        while (i >= 0) {
            Node n = this._getNode(i, this._targetNode);
            if (n != null) {
                return n;
            }
            --i;
        }
        return this._targetNode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != PropertyRowOwner.class) {
            return false;
        }
        if (o.hashCode() != this.hashCode()) {
            return false;
        }
        PropertyRowOwner other = (PropertyRowOwner)o;
        return other._gui == this._gui && other._targetNode == this._targetNode && ModelUtil.areEqual((Object)other._targetKey, (Object)this._targetKey) && ModelUtil.areEqual(other._promotionPath, this._promotionPath);
    }

    public int hashCode() {
        return this._hashCode;
    }

    void createMissingAncestors() throws Exception {
        if (this.getParentNode() != null) {
            return;
        }
        Node parent = this._targetNode;
        XmlKey parentKey = this._targetKey;
        int i = 1;
        while (i < this._promotionPath.size()) {
            parent = this._createNode(parentKey, parent, i);
            parentKey = this._promotionPath.get(i);
            ++i;
        }
    }

    boolean isTargetNodeParent() {
        return this._promotionPath.size() == 1;
    }

    private int _hashCode() {
        int code = 19;
        code = 31 * code + this._gui.hashCode();
        code = 31 * code + this._targetKey.hashCode();
        code = 31 * code + this._targetNode.hashCode();
        code = 31 * code + this._promotionPath.hashCode();
        return code;
    }

    private Node _createNode(XmlKey parentKey, Node parentNode, int index) throws Exception {
        Node n = this._getNode(index, this._targetNode);
        if (n != null) {
            return n;
        }
        XmlKey childKey = this._promotionPath.get(index);
        XmlModel model = this._gui.getView().getContext().getModel();
        Node childNode = DomUtils.createNodeFromKey((Document)model.getDocument(), (XmlKey)childKey);
        if (childNode == null) {
            throw new IllegalStateException("child node cannot be null");
        }
        model.initializeNewNode(childNode, childKey);
        DomPosition pos = DomPositionFactory.inside((Node)parentNode);
        if (model.isInModelDocumentHierarchy(pos)) {
            if ((childNode = model.insertNode(childNode, pos, false)) == null) {
                throw new IllegalStateException("owner node not created");
            }
        } else {
            DomPosition realPos = model.findValidInsertionPosition(childKey, childNode, pos, parentKey);
            DomUtils.insertNodeAtPosition((DomPosition)realPos, (Node)childNode);
        }
        return childNode;
    }

    private Node _getNode(int index, Node startNode) {
        if (this._isMatch(index, startNode)) {
            return startNode;
        }
        TreeTraversal tt = this._gui.getGuiContext().getModel().getTreeTraversal();
        int i = 0;
        while (i < tt.getChildCount(startNode)) {
            Node found;
            Node child = tt.getChild(startNode, i);
            if (DomUtils.isElement((Node)child) && (found = this._getNode(index, child)) != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    private boolean _isMatch(int index, Node node) {
        Node n = node;
        int i = index;
        while (i >= 0 && n != this._targetNode.getParentNode()) {
            XmlKey xmlKey;
            if (DomUtils.isInDocumentHierarchy((Node)n)) {
                xmlKey = this._gui.getView().getNodeXmlKey(n);
            } else {
                xmlKey = XmlModelUtils.getOwnerTraversalDerivedXmlKey(this._ownerTraversal, n, this._gui.getView());
                if (xmlKey == null) {
                    return false;
                }
            }
            if (!xmlKey.equals((Object)this._promotionPath.get(i))) {
                return false;
            }
            n = n.getParentNode();
            --i;
        }
        return i < 0 && (n == this._targetNode.getParentNode() || n == this._targetNode);
    }

    private List<XmlKey> _getUnmodifiableClonedList(List<XmlKey> ol) {
        ArrayList<XmlKey> nl = new ArrayList<XmlKey>(ol.size());
        nl.addAll(ol);
        return Collections.unmodifiableList(nl);
    }
}

