/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bali.xml.gui.base.inspector.AnnotationPropertyRowCreator;
import oracle.bali.xml.gui.base.inspector.AttributePropertyRowCreator;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PromotedPropertiesRowCreator;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowColumnUtils;
import oracle.bali.xml.gui.base.inspector.PropertyRowCreator;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.gui.base.inspector.SimpleElementPropertyRowCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyRowsProvider {
    private static final Collection<PropertyRowCreator> _sCREATORS = PropertyRowsProvider._getCreators();

    public void clearCaches() {
        for (PropertyRowCreator prc : _sCREATORS) {
            prc.clearCaches();
        }
    }

    public List<PropertyRow> createAllRows(PropertyRowOwner owner, BaseInspectorGui gui) {
        List<PropertyRow> allProperties = new ArrayList<PropertyRow>();
        for (PropertyRowCreator prc : _sCREATORS) {
            List<PropertyRow> properties = prc.getProperties(gui, owner);
            if (properties.isEmpty()) continue;
            allProperties = PropertyRowColumnUtils.mergeSortedLists(allProperties, properties, gui.__getRowComparator(), prc.isAppended());
        }
        return allProperties;
    }

    private static Collection<PropertyRowCreator> _getCreators() {
        ArrayList<PropertyRowCreator> creators = new ArrayList<PropertyRowCreator>(3);
        creators.add(new AttributePropertyRowCreator());
        creators.add(new SimpleElementPropertyRowCreator());
        creators.add(new AnnotationPropertyRowCreator());
        creators.add(new PromotedPropertiesRowCreator());
        return creators;
    }
}

