/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.HashSet;
import java.util.Set;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.MultiObjectModel;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.grammar.resolver.GrammarResolverListener;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PropertyModelUtils;
import oracle.bali.xml.gui.base.inspector.TransactedPropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlPropertyModelEvent;
import oracle.bali.xml.gui.base.inspector.XmlPropertyModelListener;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.annotation.AnnotationModelEvent;
import oracle.bali.xml.model.annotation.AnnotationModelListener;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.TransactionToken;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactedPIMultiModel
extends MultiObjectModel
implements TransactedPropertyModel,
AnnotationModelListener,
XmlModelListener,
GrammarResolverListener {
    private final BaseInspectorGui _gui;
    private TransactionToken _token;
    private Set<XmlPropertyModelListener> _listeners;

    public TransactedPIMultiModel(BaseInspectorGui gui) {
        this.$init$();
        if (gui == null) {
            throw new IllegalArgumentException("No gui");
        }
        this._gui = gui;
        this._gui.addModelListener(this);
        this._gui.getGuiContext().getGrammarResolver().addGrammarResolverListener((GrammarResolverListener)this);
        this._gui.getGuiContext().getAnnotationModel().addModelListener(this);
    }

    public void dispose() {
        super.dispose();
        this._listeners.clear();
        this._gui.removeModelListener(this);
        this._gui.getGuiContext().getGrammarResolver().removeGrammarResolverListener((GrammarResolverListener)this);
        this._gui.getGuiContext().getAnnotationModel().removeModelListener(this);
    }

    public void setValueAt(Object data, int rowIndex, int columnIndex) {
        boolean ok = false;
        try {
            ok = new SetValueTask(data, rowIndex, columnIndex).run(this.getView());
        }
        finally {
            if (!ok) {
                this._invalidate();
            }
        }
    }

    @Override
    public void setTransactionToken(TransactionToken token) {
        this._token = token;
    }

    @Override
    public void addXmlPropertyChangeListener(XmlPropertyModelListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    @Override
    public void removeXmlPropertyChangeListener(XmlPropertyModelListener listener) {
        if (this._listeners.contains(listener)) {
            this._listeners.remove(listener);
        }
    }

    @Override
    public void fireXmlPropertyModelEvent(Object column) {
        for (XmlPropertyModelListener listener : this._listeners) {
            listener.propertyModelChanged(new XmlPropertyModelEvent(column));
        }
    }

    @Override
    public void listenerAttached(XmlModelEvent event) {
    }

    @Override
    public void invalidate(XmlModelEvent event) {
    }

    @Override
    public void modelChanged(XmlModelEvent event) {
        PropertyChange pc = event.getIssueListPropertyChange();
        if (event.isDomTreeChanged()) {
            if (this._isRelevantChange(event)) {
                this.fireXmlPropertyModelEvent(null);
            }
        } else if (pc != null) {
            this.fireXmlPropertyModelEvent(PropertyModel.COLUMN_VALIDATION_ISSUES);
        }
    }

    @Override
    public void noChange(XmlModelEvent event) {
    }

    @Override
    public void listenerDetached(XmlModelEvent event) {
    }

    public void grammarResolverChanged(GrammarResolverEvent e) {
        this.fireXmlPropertyModelEvent(null);
    }

    @Override
    public void annotationModelChanged(AnnotationModelEvent e) {
        this.fireXmlPropertyModelEvent(null);
    }

    public final BaseInspectorGui getGui() {
        return this._gui;
    }

    public final XmlView getView() {
        return this._gui.getView();
    }

    private boolean _isRelevantChange(XmlModelEvent event) {
        if (this.getRowCount() == 0) {
            return false;
        }
        NodeChangeDetails ncd = event.getNodeChangeDetails();
        if (ncd == null || NodeChangeDetails.NO_DETAILS_AVAILABLE.equals(ncd)) {
            return false;
        }
        return this._relevantNodeFound(event.getChangeRoot(), ncd.getChangedNodes());
    }

    private boolean _relevantNodeFound(Node rootNode, Set<Node> nodes) {
        Node inspectableNode = PropertyModelUtils.getTargetNode((PropertyModel)this, 0);
        if (rootNode == inspectableNode || DomUtils.isDescendant((Node)rootNode, (Node)inspectableNode)) {
            return true;
        }
        for (Node n : nodes) {
            if (n != inspectableNode && !DomUtils.isDescendant((Node)n, (Node)inspectableNode)) continue;
            return true;
        }
        return false;
    }

    private void _superSetValueAt(Object data, int rowIndex, int columnIndex) {
        super.setValueAt(data, rowIndex, columnIndex);
    }

    private void _invalidate() {
        this.invalidateValueData();
    }

    private void $init$() {
        this._listeners = new HashSet<XmlPropertyModelListener>(3);
    }

    static TransactionToken ra$_token(TransactedPIMultiModel transactedPIMultiModel) {
        return transactedPIMultiModel._token;
    }

    static void mav$_superSetValueAt(TransactedPIMultiModel transactedPIMultiModel, Object object, int n, int n2) {
        transactedPIMultiModel._superSetValueAt(object, n, n2);
    }

    private class SetValueTask
    extends FixedNameTransactionTask {
        private final Object _data;
        private final int _rowIndex;
        private final int _columnIndex;

        public SetValueTask(Object data, int rowIndex, int columnIndex) {
            super(TransactedPIMultiModel.this.getView().getTranslatedString("INSPECTOR.CHANGE_ATTRIBUTE_KEY"));
            this._data = data;
            this._rowIndex = rowIndex;
            this._columnIndex = columnIndex;
        }

        protected void performTask(AbstractModel model) {
            TransactionToken token = TransactedPIMultiModel.this.getView().getContext().getTransactionToken();
            if (token == null) {
                token = TransactedPIMultiModel.ra$_token(TransactedPIMultiModel.this);
            }
            if (token != null) {
                TransactedPIMultiModel.this.getView().getContext().setTransactionToken(token);
            }
            TransactedPIMultiModel.mav$_superSetValueAt(TransactedPIMultiModel.this, this._data, this._rowIndex, this._columnIndex);
        }

        protected boolean handleThrownRuntimeException(AbstractModel model, RuntimeException re, String txnName) {
            return true;
        }
    }
}

