/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.ProcessingInstructionTargetPropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowColumnUtils;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.gui.base.inspector.XmlKeyPropertyRow;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.util.NameToStringUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDomPropertyModel
extends PropertyModel {
    public static final Object COLUMN_IS_DATABOUND;
    public static final Object COLUMN_SUPPORTS_DATABINDING;
    public static final Object COLUMN_HELP_TOPIC;
    public static final Object COLUMN_NODE;
    public static final Object COLUMN_IS_REQUIRED;
    public static final Object COLUMN_IS_COMMON;
    public static final Object COLUMN_IS_SET;
    public static final Object COLUMN_DISPLAY_ORDER;
    public static final Object COLUMN_IS_PREFERRED;
    public static final Object COLUMN_IS_FAVORITE;
    public static final Object COLUMN_XMLKEY;
    public static final Object COLUMN_IS_DEPRECATED;
    public static final Object COLUMN_TOOLTIP;
    public static final Object COLUMN_HIDDEN_IN_PROPERTIES_DIALOG;
    public static final Object COLUMN_ENUMERATED_VALUES_INFO;
    public static final Object COLUMN_DEFAULT_VALUE;
    public static final Object COLUMN_INSPECTOR_GUI;
    public static final Object COLUMN_TARGET_NODE;
    public static final Object COLUMN_TARGET_KEY;
    public static final Object COLUMN_IS_CUSTOMIZED_AT_TIP;
    public static final Object COLUMN_NEAREST_ANCESTOR_NODE;
    public static final Object COLUMN_OWNER_NODE;
    public static final Object COLUMN_OWNER_KEY;
    public static final Object COLUMN_ATTRIBUTE_VALUE_ITEM_PROVIDER;
    public static final Object COLUMN_KEY;
    private Node _node;
    private XmlKey _key;
    private BaseInspectorGui _gui;
    private boolean isBeingQueried;
    private transient String _name;
    private transient List<? extends PropertyRow> _attrRows;
    private transient int _lockCount;
    private final transient ConcurrentHashMap<Object, PropertyRow> _propertyIdToRow;
    private final Map<PropertyRowOwner, Map<Object, PropertyRow>> _keyToRow;
    private static final Object[] _COLUMNS;
    private static final int _INDEX_INSPECTOR_GUI;
    private static final int _INDEX_TARGET_NODE;
    private static final int _INDEX_TARGET_KEY;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XmlDomPropertyModel(Node node, XmlKey nodeKey, BaseInspectorGui gui) {
        this.$init$();
        if (gui == null) {
            throw new IllegalArgumentException("No gui");
        }
        if (nodeKey == null) {
            nodeKey = gui.getView().getXmlMetadataResolver().getNodeXmlKey(node);
        }
        this._node = node;
        this._gui = gui;
        this._key = nodeKey;
        this._update();
    }

    public XmlDomPropertyModel(Node node, BaseInspectorGui gui) {
        this(node, null, gui);
    }

    public Node getTargetNode() {
        return this._node;
    }

    public XmlKey getTargetKey() {
        return this._key;
    }

    public Object[] getColumnMapping() {
        return _COLUMNS;
    }

    public int getRowCount() {
        return this._attrRows.size();
    }

    public void startRead() {
        if (this._gui == null) {
            return;
        }
        this.getView().acquireReadLock();
        ++this._lockCount;
    }

    public void stopRead() {
        if (this._gui == null) {
            return;
        }
        this.getView().releaseReadLock();
        --this._lockCount;
    }

    public final Object getValueAt(int rowIndex, int columnIndex) {
        if (this._gui == null) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        PropertyRow rowAttrs = this.getPropertyRow(rowIndex);
        return this._getPropertyWithLockIfNeeded(rowAttrs, columnIndex);
    }

    public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
        PropertyRow row = this.getPropertyRow(rowIndex);
        switch (columnIndex) {
            case 2: {
                if (newValue == null) {
                    PropertyRow.UpdateResult result = this._setRowIsSet(false, row);
                    break;
                }
                PropertyRow.UpdateResult result = row.setRowValue(newValue);
                break;
            }
            case 16: {
                if (row instanceof XmlKeyPropertyRow) {
                    PropertyRow.UpdateResult result = ((XmlKeyPropertyRow)row).setDataboundValue(newValue);
                    break;
                }
                PropertyRow.UpdateResult result = PropertyRow.UpdateResult.NO_UPDATE;
                break;
            }
            case 5: {
                PropertyRow.UpdateResult result = this._setRowIsSet(newValue, row);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public int getColumnIndex(Object columnID) {
        if (columnID == PropertyModel.COLUMN_ID) {
            return 0;
        }
        return super.getColumnIndex(columnID);
    }

    public Object getPropertyByID(int columnIndex, Object propertyID) {
        if (this._gui == null) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        PropertyRow row = this.getPropertyRow(propertyID);
        if (row != null) {
            return this._getPropertyWithLockIfNeeded(row, columnIndex);
        }
        return PropertyModel.DOES_NOT_EXIST;
    }

    public String getTargetDisplayName() {
        return this._name;
    }

    public void dispose() {
        super.dispose();
        this.invalidateValueData();
    }

    public void invalidateValueData() {
        this._disposeOldRows();
        this.getGui().__clearNodeMessages(this.getTargetNode());
        this._update();
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int row, int column) {
        if (this._gui == null) {
            return false;
        }
        boolean editable = super.isCellEditable(row, column);
        if (editable && (editable = this._gui.isUserEditable())) {
            this.startRead();
            try {
                editable = this.getView().getXmlMetadataResolver().isImmutable(this.getTargetNode()) ^ true;
            }
            finally {
                this.stopRead();
            }
        }
        return editable;
    }

    public String toString() {
        return super.toString() + ", node=" + this._node;
    }

    public void disposeModel() {
        if (this.isBeingQueried) {
            throw new IllegalStateException("PropertyModel cannot be disposed while it's being queried!");
        }
        this._disposeOldRows();
        this._attrRows = Collections.emptyList();
        this._propertyIdToRow.clear();
        this._keyToRow.clear();
        this._gui = null;
        this._node = null;
    }

    public Object getMatchingId(Object id) {
        PropertyRow row;
        String str;
        List<Object> keys;
        if (this._gui == null) {
            return false;
        }
        if (id instanceof String && !(keys = this._parseStringPropertyIdToKey(str = (String)id)).isEmpty() && (row = this._getPropertyRow(keys)) != null) {
            return row.getColumnValue(0);
        }
        return null;
    }

    private PropertyRow _getPropertyRow(List<Object> keys) {
        Object key = keys.get(keys.size() - 1);
        PropertyRow row = null;
        Set<PropertyRowOwner> s = this._keyToRow.keySet();
        boolean found = false;
        for (PropertyRowOwner pro : s) {
            List<XmlKey> promotionPath;
            Map<Object, PropertyRow> m = this._keyToRow.get(pro);
            row = m.get(key);
            if (row != null && (promotionPath = row.getOwner().getPromotionPath()).size() == keys.size()) {
                if (keys.size() == 1) {
                    found = true;
                } else {
                    int i = 1;
                    while (i < promotionPath.size()) {
                        if (!promotionPath.get(i).equals(keys.get(i - 1))) break;
                        if (i == promotionPath.size() - 1) {
                            found = true;
                        }
                        ++i;
                    }
                }
            }
            if (!found) continue;
            return row;
        }
        return null;
    }

    public boolean isSettable(Object oldValue, Object newValue) {
        return true;
    }

    protected Object getProperty(PropertyRow row, int columnIndex) {
        if (columnIndex == _INDEX_INSPECTOR_GUI) {
            return this.getGui();
        }
        if (columnIndex == _INDEX_TARGET_NODE) {
            return this.getTargetNode();
        }
        if (columnIndex == _INDEX_TARGET_KEY) {
            return this.getTargetKey();
        }
        return row.getColumnValue(columnIndex);
    }

    protected final XmlView getView() {
        return this._gui.getView();
    }

    public final BaseInspectorGui getGui() {
        return this._gui;
    }

    protected final PropertyRow getPropertyRow(int rowIndex) {
        return this._attrRows.get(rowIndex);
    }

    protected final PropertyRow getPropertyRow(Object propertyId) {
        return this._propertyIdToRow.get(propertyId);
    }

    private Object _getPropertyWithLockIfNeeded(PropertyRow row, int columnIndex) {
        if (this._gui == null) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        this.isBeingQueried = true;
        this.startRead();
        try {
            Object object = this.getProperty(row, columnIndex);
            return object;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.stopRead();
            this.isBeingQueried = false;
        }
    }

    private int _getPropertyIndex(PropertyRow row) {
        return this._attrRows.indexOf(row);
    }

    private void _fireEvents(PropertyRow.UpdateResult result, PropertyRow row, int index) {
        switch (1.$sm$oracle$bali$xml$gui$base$inspector$PropertyRow$UpdateResult[result.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.fireTableCellUpdated(this._getPropertyIndex(row), index);
                break;
            }
            case 3: {
                this.invalidateValueData();
                break;
            }
        }
    }

    private void _disposeOldRows() {
        int i = 0;
        while (i < this._attrRows.size()) {
            PropertyRow row = this._attrRows.get(i);
            row.dispose();
            ++i;
        }
    }

    private void _update() {
        this.startRead();
        try {
            List<Object> propertyRows;
            String oldName = this._name;
            this._name = null;
            Node targetNode = this._node;
            XmlKey nodeKey = this._key;
            short nodeType = nodeKey.getNodeType();
            PropertyRowOwner owner = new PropertyRowOwner(this.getGui(), targetNode, nodeKey, Collections.singletonList(nodeKey));
            switch (nodeType) {
                case 1: {
                    propertyRows = this.getGui().__createPropertyRows(owner);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    propertyRows = Collections.singletonList(new XmlKeyPropertyRow(this.getGui(), nodeKey, targetNode, owner));
                    break;
                }
                case 7: {
                    ArrayList l = new ArrayList(2);
                    ProcessingInstructionTargetPropertyRow targetRow = new ProcessingInstructionTargetPropertyRow(this.getGui(), nodeKey, targetNode, owner);
                    XmlKeyPropertyRow dataRow = new XmlKeyPropertyRow(this.getGui(), nodeKey, targetNode, owner);
                    l.add(targetRow);
                    l.add(dataRow);
                    propertyRows = l;
                    break;
                }
                default: {
                    propertyRows = Collections.emptyList();
                    break;
                }
            }
            this._propertyIdToRow.clear();
            this._keyToRow.clear();
            this._attrRows = propertyRows;
            int i = 0;
            while (i < this._attrRows.size()) {
                PropertyRow row = this._attrRows.get(i);
                this._propertyIdToRow.put(row.getColumnValue(0), row);
                PropertyRowOwner o = row.getOwner();
                Map<Object, PropertyRow> props = this._keyToRow.get(o);
                if (props == null) {
                    props = new HashMap<Object, PropertyRow>(35);
                }
                props.put(row.getColumnValue(39), row);
                this._keyToRow.put(o, props);
                ++i;
            }
            this._name = this._getName();
            if (this._name != null) {
                this.firePropertyChanged("targetDisplayName", oldName, this._name);
            }
        }
        finally {
            this.stopRead();
        }
    }

    private String _getName() {
        if (this._gui == null) {
            return null;
        }
        this.startRead();
        try {
            Node n = this.getTargetNode();
            XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
            String string = n != null ? resolver.getMediumDisplayName(this.getTargetNode()) : resolver.getMediumDisplayName(this.getTargetKey());
            return string;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.stopRead();
        }
    }

    private PropertyRow.UpdateResult _setRowIsSet(Object value, PropertyRow row) {
        boolean isSet;
        if (Boolean.FALSE.equals(value) && (isSet = Boolean.TRUE.equals(row.getColumnValue(5)))) {
            row.setDefaultRowValue();
            return PropertyRow.UpdateResult.INVALIDATE_MODEL;
        }
        return PropertyRow.UpdateResult.NO_UPDATE;
    }

    private List<Object> _parseStringPropertyIdToKey(String str) {
        ArrayList<Object> keys;
        block10: {
            XmlKey targetKey = this.getTargetKey();
            XmlKey derivedKey = null;
            keys = new ArrayList<Object>();
            boolean isAnnotation = str.startsWith("+");
            if (isAnnotation) {
                str = str.substring(1);
            }
            try {
                int[] index = new int[]{0};
                while (index[0] < str.length()) {
                    XmlKey parsedKey;
                    if (str.charAt(index[0]) == ' ') {
                        index[0] = index[0] + 1;
                    }
                    if ((parsedKey = NameToStringUtils.parseXmlKeyWithPrefixMappings(Collections.singletonMap(null, targetKey.getNamespace()), (CharSequence)str, (int[])index)) == null) continue;
                    if (isAnnotation) {
                        keys.add(parsedKey.getElementQName());
                        continue;
                    }
                    if (parsedKey.getNodeType() == 2) {
                        XmlKey baseKey = keys.isEmpty() ? targetKey : (XmlKey)keys.get(keys.size() - 1);
                        derivedKey = DerivedXmlKey.createAttributeKey((GrammarResolver)this.getGui().getGuiContext().getGrammarResolver(), (XmlKey)baseKey, (QualifiedName)parsedKey.getAttributeQName());
                    } else if (parsedKey.getNodeType() == 1) {
                        derivedKey = DerivedXmlKey.createElementKey((GrammarResolver)this.getGui().getGuiContext().getGrammarResolver(), (XmlKey)targetKey, (List)parsedKey.getElementQNamePath());
                    } else {
                        this.getGui().getLogger().log(Level.WARNING, "Unexpected key type parsed from {0}; key={1}", new Object[]{str, parsedKey});
                    }
                    keys.add(derivedKey);
                }
            }
            catch (NameToStringUtils.ParseException e) {
                Logger logger = this.getGui().getLogger();
                if (!logger.isLoggable(Level.FINER)) break block10;
                logger.log(Level.FINER, "Failed to parse to property ID: " + str, e);
            }
        }
        return keys;
    }

    public final Comparator<PropertyRow> getRowComparator() {
        return this.getGui().__getRowComparator();
    }

    private void $init$() {
        this.isBeingQueried = false;
        this._propertyIdToRow = new ConcurrentHashMap();
        this._keyToRow = new HashMap<PropertyRowOwner, Map<Object, PropertyRow>>(5);
    }

    static {
        $assertionsDisabled = XmlDomPropertyModel.class.desiredAssertionStatus() ^ true;
        COLUMN_IS_DATABOUND = XmlSpecificColumns.COLUMN_IS_DATABOUND;
        COLUMN_SUPPORTS_DATABINDING = XmlSpecificColumns.COLUMN_SUPPORTS_DATABINDING;
        COLUMN_HELP_TOPIC = XmlSpecificColumns.COLUMN_HELP_TOPIC;
        COLUMN_NODE = XmlSpecificColumns.COLUMN_NODE;
        COLUMN_IS_REQUIRED = XmlSpecificColumns.COLUMN_IS_REQUIRED;
        COLUMN_IS_COMMON = XmlSpecificColumns.COLUMN_IS_COMMON;
        COLUMN_IS_SET = XmlSpecificColumns.COLUMN_IS_SET;
        COLUMN_DISPLAY_ORDER = XmlSpecificColumns.COLUMN_DISPLAY_ORDER;
        COLUMN_IS_PREFERRED = XmlSpecificColumns.COLUMN_IS_PREFERRED;
        COLUMN_IS_FAVORITE = XmlSpecificColumns.COLUMN_IS_FAVORITE;
        COLUMN_XMLKEY = XmlSpecificColumns.COLUMN_XMLKEY;
        COLUMN_IS_DEPRECATED = XmlSpecificColumns.COLUMN_IS_DEPRECATED;
        COLUMN_TOOLTIP = XmlSpecificColumns.COLUMN_TOOLTIP;
        COLUMN_HIDDEN_IN_PROPERTIES_DIALOG = XmlSpecificColumns.COLUMN_HIDDEN_IN_PROPERTIES_DIALOG;
        COLUMN_ENUMERATED_VALUES_INFO = XmlSpecificColumns.COLUMN_ENUMERATED_VALUES_INFO;
        COLUMN_DEFAULT_VALUE = XmlSpecificColumns.COLUMN_DEFAULT_VALUE;
        COLUMN_INSPECTOR_GUI = XmlSpecificColumns.COLUMN_INSPECTOR_GUI;
        COLUMN_TARGET_NODE = XmlSpecificColumns.COLUMN_TARGET_NODE;
        COLUMN_TARGET_KEY = XmlSpecificColumns.COLUMN_TARGET_KEY;
        COLUMN_IS_CUSTOMIZED_AT_TIP = XmlSpecificColumns.COLUMN_IS_CUSTOMIZED_AT_TIP;
        COLUMN_NEAREST_ANCESTOR_NODE = XmlSpecificColumns.COLUMN_NEAREST_ANCESTOR_NODE;
        COLUMN_OWNER_NODE = XmlSpecificColumns.COLUMN_OWNER_NODE;
        COLUMN_OWNER_KEY = XmlSpecificColumns.COLUMN_OWNER_KEY;
        COLUMN_ATTRIBUTE_VALUE_ITEM_PROVIDER = XmlSpecificColumns.COLUMN_ATTRIBUTE_VALUE_ITEM_PROVIDER;
        COLUMN_KEY = XmlSpecificColumns.COLUMN_KEY;
        Object[] orig = PropertyRowColumnUtils.getColumnMapping();
        Object[] cols = new Object[orig.length + 3];
        System.arraycopy(orig, 0, cols, 0, orig.length);
        int i = orig.length;
        _INDEX_INSPECTOR_GUI = i++;
        _INDEX_TARGET_NODE = i++;
        _INDEX_TARGET_KEY = i++;
        if (!$assertionsDisabled && i != cols.length) {
            throw new AssertionError();
        }
        cols[XmlDomPropertyModel._INDEX_INSPECTOR_GUI] = COLUMN_INSPECTOR_GUI;
        cols[XmlDomPropertyModel._INDEX_TARGET_NODE] = COLUMN_TARGET_NODE;
        cols[XmlDomPropertyModel._INDEX_TARGET_KEY] = COLUMN_TARGET_KEY;
        _COLUMNS = cols;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XmlSpecificColumns
    extends Enum<XmlSpecificColumns> {
        private static final /* synthetic */ XmlSpecificColumns[] $v;
        public static final /* enum */ XmlSpecificColumns COLUMN_IS_DATABOUND;
        public static final /* enum */ XmlSpecificColumns COLUMN_SUPPORTS_DATABINDING;
        public static final /* enum */ XmlSpecificColumns COLUMN_HELP_TOPIC;
        public static final /* enum */ XmlSpecificColumns COLUMN_NODE;
        public static final /* enum */ XmlSpecificColumns COLUMN_IS_REQUIRED;
        public static final /* enum */ XmlSpecificColumns COLUMN_IS_COMMON;
        public static final /* enum */ XmlSpecificColumns COLUMN_IS_SET;
        public static final /* enum */ XmlSpecificColumns COLUMN_DISPLAY_ORDER;
        public static final /* enum */ XmlSpecificColumns COLUMN_IS_PREFERRED;
        public static final /* enum */ XmlSpecificColumns COLUMN_IS_FAVORITE;
        public static final /* enum */ XmlSpecificColumns COLUMN_XMLKEY;
        public static final /* enum */ XmlSpecificColumns COLUMN_IS_DEPRECATED;
        public static final /* enum */ XmlSpecificColumns COLUMN_TOOLTIP;
        public static final /* enum */ XmlSpecificColumns COLUMN_HIDDEN_IN_PROPERTIES_DIALOG;
        public static final /* enum */ XmlSpecificColumns COLUMN_ENUMERATED_VALUES_INFO;
        public static final /* enum */ XmlSpecificColumns COLUMN_DEFAULT_VALUE;
        public static final /* enum */ XmlSpecificColumns COLUMN_INSPECTOR_GUI;
        public static final /* enum */ XmlSpecificColumns COLUMN_TARGET_NODE;
        public static final /* enum */ XmlSpecificColumns COLUMN_TARGET_KEY;
        public static final /* enum */ XmlSpecificColumns COLUMN_IS_CUSTOMIZED_AT_TIP;
        public static final /* enum */ XmlSpecificColumns COLUMN_NEAREST_ANCESTOR_NODE;
        public static final /* enum */ XmlSpecificColumns COLUMN_OWNER_NODE;
        public static final /* enum */ XmlSpecificColumns COLUMN_OWNER_KEY;
        public static final /* enum */ XmlSpecificColumns COLUMN_ATTRIBUTE_VALUE_ITEM_PROVIDER;
        public static final /* enum */ XmlSpecificColumns COLUMN_KEY;

        public static XmlSpecificColumns valueOf(String string) {
            return Enum.valueOf(XmlSpecificColumns.class, string);
        }

        public static final XmlSpecificColumns[] values() {
            return (XmlSpecificColumns[])$v.clone();
        }

        static {
            XmlSpecificColumns[] xmlSpecificColumnsArray = new XmlSpecificColumns[25];
            xmlSpecificColumnsArray[24] = COLUMN_KEY = new XmlSpecificColumns("COLUMN_KEY", 24);
            xmlSpecificColumnsArray[23] = COLUMN_ATTRIBUTE_VALUE_ITEM_PROVIDER = new XmlSpecificColumns("COLUMN_ATTRIBUTE_VALUE_ITEM_PROVIDER", 23);
            xmlSpecificColumnsArray[22] = COLUMN_OWNER_KEY = new XmlSpecificColumns("COLUMN_OWNER_KEY", 22);
            xmlSpecificColumnsArray[21] = COLUMN_OWNER_NODE = new XmlSpecificColumns("COLUMN_OWNER_NODE", 21);
            xmlSpecificColumnsArray[20] = COLUMN_NEAREST_ANCESTOR_NODE = new XmlSpecificColumns("COLUMN_NEAREST_ANCESTOR_NODE", 20);
            xmlSpecificColumnsArray[19] = COLUMN_IS_CUSTOMIZED_AT_TIP = new XmlSpecificColumns("COLUMN_IS_CUSTOMIZED_AT_TIP", 19);
            xmlSpecificColumnsArray[18] = COLUMN_TARGET_KEY = new XmlSpecificColumns("COLUMN_TARGET_KEY", 18);
            xmlSpecificColumnsArray[17] = COLUMN_TARGET_NODE = new XmlSpecificColumns("COLUMN_TARGET_NODE", 17);
            xmlSpecificColumnsArray[16] = COLUMN_INSPECTOR_GUI = new XmlSpecificColumns("COLUMN_INSPECTOR_GUI", 16);
            xmlSpecificColumnsArray[15] = COLUMN_DEFAULT_VALUE = new XmlSpecificColumns("COLUMN_DEFAULT_VALUE", 15);
            xmlSpecificColumnsArray[14] = COLUMN_ENUMERATED_VALUES_INFO = new XmlSpecificColumns("COLUMN_ENUMERATED_VALUES_INFO", 14);
            xmlSpecificColumnsArray[13] = COLUMN_HIDDEN_IN_PROPERTIES_DIALOG = new XmlSpecificColumns("COLUMN_HIDDEN_IN_PROPERTIES_DIALOG", 13);
            xmlSpecificColumnsArray[12] = COLUMN_TOOLTIP = new XmlSpecificColumns("COLUMN_TOOLTIP", 12);
            xmlSpecificColumnsArray[11] = COLUMN_IS_DEPRECATED = new XmlSpecificColumns("COLUMN_IS_DEPRECATED", 11);
            xmlSpecificColumnsArray[10] = COLUMN_XMLKEY = new XmlSpecificColumns("COLUMN_XMLKEY", 10);
            xmlSpecificColumnsArray[9] = COLUMN_IS_FAVORITE = new XmlSpecificColumns("COLUMN_IS_FAVORITE", 9);
            xmlSpecificColumnsArray[8] = COLUMN_IS_PREFERRED = new XmlSpecificColumns("COLUMN_IS_PREFERRED", 8);
            xmlSpecificColumnsArray[7] = COLUMN_DISPLAY_ORDER = new XmlSpecificColumns("COLUMN_DISPLAY_ORDER", 7);
            xmlSpecificColumnsArray[6] = COLUMN_IS_SET = new XmlSpecificColumns("COLUMN_IS_SET", 6);
            xmlSpecificColumnsArray[5] = COLUMN_IS_COMMON = new XmlSpecificColumns("COLUMN_IS_COMMON", 5);
            xmlSpecificColumnsArray[4] = COLUMN_IS_REQUIRED = new XmlSpecificColumns("COLUMN_IS_REQUIRED", 4);
            xmlSpecificColumnsArray[3] = COLUMN_NODE = new XmlSpecificColumns("COLUMN_NODE", 3);
            xmlSpecificColumnsArray[2] = COLUMN_HELP_TOPIC = new XmlSpecificColumns("COLUMN_HELP_TOPIC", 2);
            xmlSpecificColumnsArray[1] = COLUMN_SUPPORTS_DATABINDING = new XmlSpecificColumns("COLUMN_SUPPORTS_DATABINDING", 1);
            xmlSpecificColumnsArray[0] = COLUMN_IS_DATABOUND = new XmlSpecificColumns("COLUMN_IS_DATABOUND", 0);
            $v = xmlSpecificColumnsArray;
        }

        private XmlSpecificColumns(String string2, int n2) {
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$bali$xml$gui$base$inspector$PropertyRow$UpdateResult;

        static {
            int[] nArray = new int[PropertyRow.UpdateResult.values().length];
            $sm$oracle$bali$xml$gui$base$inspector$PropertyRow$UpdateResult = nArray;
            try {
                nArray[PropertyRow.UpdateResult.NO_UPDATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$bali$xml$gui$base$inspector$PropertyRow$UpdateResult[PropertyRow.UpdateResult.INVALIDATE_CELL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$bali$xml$gui$base$inspector$PropertyRow$UpdateResult[PropertyRow.UpdateResult.INVALIDATE_MODEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

