/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.List;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.metadata.XmlKey;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlPropertyId {
    private final BaseInspectorGui _gui;
    private final QualifiedName _qName;
    private final Type _type;
    private final int _hashCode;
    private final PropertyType _propertyType;
    private final List<XmlKey> _promotionPath;

    public XmlPropertyId(BaseInspectorGui gui, QualifiedName qName, Type type, PropertyType propertyType, List<XmlKey> promotionPath) {
        this._gui = gui;
        this._qName = qName;
        this._type = type;
        this._propertyType = propertyType;
        this._promotionPath = promotionPath;
        this._hashCode = this._computeHashCode();
    }

    PropertyType __getPropertyType() {
        return this._propertyType;
    }

    QualifiedName __getQName() {
        return this._qName;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != XmlPropertyId.class) {
            return false;
        }
        if (obj.hashCode() != this.hashCode()) {
            return false;
        }
        XmlPropertyId other = (XmlPropertyId)obj;
        return this._gui == other._gui && ModelUtil.areEqual((Object)other._qName, (Object)this._qName) && ModelUtil.areEqual((Object)other._type, (Object)this._type) && other._propertyType.equals((Object)this._propertyType) && this._pathsAreEqual(other._promotionPath);
    }

    private int _computeHashCode() {
        int code = 19;
        code = 31 * code + this._gui.hashCode();
        code = 31 * code + this._qName.hashCode();
        code = 31 * code + (this._type == null ? 0 : this._type.hashCode());
        code = 31 * code + this._propertyType.hashCode();
        code = this._getPathCode(code);
        return code;
    }

    private boolean _pathsAreEqual(List<XmlKey> otherPath) {
        if (this._promotionPath == otherPath) {
            return true;
        }
        if (otherPath == null) {
            return false;
        }
        if (this._promotionPath.size() != otherPath.size()) {
            return false;
        }
        int i = 0;
        for (XmlKey k : otherPath) {
            if (!k.equals((Object)this._promotionPath.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int _getPathCode(int code) {
        for (XmlKey k : this._promotionPath) {
            code = 31 * code + k.hashCode();
        }
        return code;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertyType
    extends Enum<PropertyType> {
        private static final /* synthetic */ PropertyType[] $v;
        public static final /* enum */ PropertyType ELEMENT;
        public static final /* enum */ PropertyType ATTRIBUTE;
        public static final /* enum */ PropertyType ANNOTATION;

        public static PropertyType valueOf(String string) {
            return Enum.valueOf(PropertyType.class, string);
        }

        public static final PropertyType[] values() {
            return (PropertyType[])$v.clone();
        }

        static {
            PropertyType[] propertyTypeArray = new PropertyType[3];
            propertyTypeArray[2] = ANNOTATION = new PropertyType("ANNOTATION", 2);
            propertyTypeArray[1] = ATTRIBUTE = new PropertyType("ATTRIBUTE", 1);
            propertyTypeArray[0] = ELEMENT = new PropertyType("ELEMENT", 0);
            $v = propertyTypeArray;
        }

        private PropertyType(String string2, int n2) {
        }
    }
}

